/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.requestcenter.RequestsService;
import com.dataiku.dip.server.notifications.backend.ProfileUpgradeRequestEvent;
import com.dataiku.dip.server.notifications.emails.ProfileUpgradeApprovedEmailBuilder;
import com.dataiku.dip.server.notifications.emails.ProfileUpgradeRequestEmailBuilder;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProfileUpgradeRequestEmailSendService {
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private RequestsService requestsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UserSettingsService userSettingsService;
    private static final Logger logger = Logger.getLogger((String)"dku.notifications.profile-upgrade-request-email");

    @PostConstruct
    public void init() {
        this.pubSubService.subscribe("profile-upgrade-request", evt -> {
            Map<String, UserSettingsService.UserSettings> usersSettings;
            ProfileUpgradeRequestEmailBuilder emailBuilder = new ProfileUpgradeRequestEmailBuilder();
            List<String> logins = this.requestsService.getRequestTargets_NT(evt.getRequestType(), evt.getObjectType(), null);
            try (Transaction ignored = this.transactionService.beginRead();){
                usersSettings = this.userSettingsService.getForUsers(logins);
            }
            for (Map.Entry<String, UserSettingsService.UserSettings> userSettings : usersSettings.entrySet()) {
                String toUser = userSettings.getKey();
                if (!userSettings.getValue().profileUpgradeRequestsEmails.enabled) continue;
                try {
                    emailBuilder.sendToUser((ProfileUpgradeRequestEvent)evt, toUser);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to send email to " + toUser + " for profile upgrade request"), (Throwable)e);
                }
            }
        });
        this.pubSubService.subscribe("profile-upgrade-approved", evt -> {
            ProfileUpgradeApprovedEmailBuilder emailBuilder = new ProfileUpgradeApprovedEmailBuilder();
            String toUser = evt.getUserLogin();
            try {
                emailBuilder.sendToUser(toUser, evt.getSelectedUserProfile());
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to send email to " + toUser + " for approved profile upgrade request"), (Throwable)e);
            }
        });
    }
}

