/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.MultiEngineRecipeRunner;
import com.dataiku.dip.dataflow.exec.dataquality.ExtractFailedRowsRecipePayloadParams;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.server.recipes.ExtractFailedRowsQueryGenerator;
import com.dataiku.dip.server.recipes.ExtractFailedRowsSchemaGenerator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExtractFailedRowsRecipeService {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.dataquality");

    public ExtractFailedRowsRecipePayloadParams loadParams(String payload, SerializedRecipe sr) {
        return (ExtractFailedRowsRecipePayloadParams)JSON.parse((String)payload, ExtractFailedRowsRecipePayloadParams.class);
    }

    public Schema getOutputSchemaBeforeOverride(Dataset inputDS, ExtractFailedRowsRecipePayloadParams params, boolean lowerCaseColumnsNames, Integer identifierMaxLength) {
        return this.getOutputSchemaDetailsBeforeOverride((Dataset)inputDS, (ExtractFailedRowsRecipePayloadParams)params, (boolean)lowerCaseColumnsNames, (Integer)identifierMaxLength).outputSchema;
    }

    public ExtractFailedRowsSchemaGenerator.FailedRowsSchemaDetails getOutputSchemaDetailsBeforeOverride(Dataset inputDS, ExtractFailedRowsRecipePayloadParams params, boolean lowerCaseColumnsNames, Integer identifierMaxLength) {
        ExtractFailedRowsSchemaGenerator.FailedRowsSchemaDetails schemaDetails = this.getBaseOutputSchemaDetails(inputDS, params, identifierMaxLength);
        if (lowerCaseColumnsNames) {
            SchemaUtils.lowerCase(schemaDetails.outputSchema);
        }
        return schemaDetails;
    }

    public Schema getOutputSchemaAfterOverride(Dataset inputDS, ExtractFailedRowsRecipePayloadParams params, boolean lowerCaseColumnsNames, Integer identifierMaxLength) {
        Schema schema = this.getOutputSchemaBeforeOverride(inputDS, params, lowerCaseColumnsNames, identifierMaxLength);
        SchemaUtils.applyOverrides(schema, params.outputColumnNameOverrides, lowerCaseColumnsNames);
        return schema;
    }

    public ExtractFailedRowsSchemaGenerator.FailedRowsSchemaDetails getBaseOutputSchemaDetails(Dataset inputDS, ExtractFailedRowsRecipePayloadParams params, Integer identifierMaxLength) {
        return new ExtractFailedRowsSchemaGenerator(inputDS).generate(params, identifierMaxLength);
    }

    public String generateSQL(JobActivity activity, SQLDialect dialect, ExtractFailedRowsRecipePayloadParams params) throws IOException {
        Partition part;
        List<Partition> parts;
        Dataset source = activity.getSubgraph().getSingleSourceDataset().getMandatory(this.datasetsDAO);
        List<Partition> sourcePartitions = null;
        PartitioningScheme sourcePartitionScheme = null;
        PartitioningScheme targetPartitionScheme = null;
        boolean usePartitionsInQueries = MultiEngineRecipeRunner.shouldSpecifySourcePartitionInWhereClause(dialect, params.engineParams);
        if (usePartitionsInQueries && (parts = activity.getSubgraph().getSourcePartitions(activity.getSubgraph().getSingleSourceDataset())) != null && !parts.isEmpty() && !parts.get(0).isAll() && !parts.get(0).isNP() && source.getPartitioningSchema().isPartitioned()) {
            sourcePartitions = parts;
            sourcePartitionScheme = source.getPartitioningSchema();
        }
        Dataset outputDS = activity.getSubgraph().getSingleTargetDataset().getMandatory(this.datasetsDAO);
        if (usePartitionsInQueries && (part = activity.getSubgraph().getTargetPartition(activity.getSubgraph().getSingleTargetDataset())) != null && !part.isNP() && !part.isAll() && outputDS.getPartitioningSchema().isPartitioned()) {
            targetPartitionScheme = outputDS.getPartitioningSchema();
        }
        return this.generateSQL(dialect, params, source, outputDS, sourcePartitionScheme, sourcePartitions, targetPartitionScheme);
    }

    public String generateSQLIgnorePartitions(SQLDialect dialect, ExtractFailedRowsRecipePayloadParams params, Dataset source, Dataset target) throws IOException {
        return this.generateSQL(dialect, params, source, target, null, null, null);
    }

    public String generateSQL(SQLDialect dialect, ExtractFailedRowsRecipePayloadParams params, Dataset source, Dataset target, PartitioningScheme sourcePartitionScheme, List<Partition> sourcePartitions, PartitioningScheme targetPartitionScheme) throws IOException {
        SQLUtils.SQLTable table = DatasetUtils.getResolvedTableWithSparkSQLFallback(source, dialect, params.engineParams);
        ExtractFailedRowsQueryGenerator sqlGenerator = new ExtractFailedRowsQueryGenerator(params, source, table, target);
        sqlGenerator.setPartitioning(sourcePartitionScheme, sourcePartitions, targetPartitionScheme);
        return sqlGenerator.generateSQL(dialect);
    }
}

