/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.ParamsWithVariablesExpansionLoopConfig;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.recipes.RecipeVariablesHelper;
import com.dataiku.dip.server.services.AchievementsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class GenericRecipeInteractionController
extends DIPInternalControllerBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private AchievementsService achievementsService;
    @Autowired
    private AuditTrailService auditTrailService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.interactioncontroller");

    @AuditInline
    @RequestMapping(value={"/api/flow/recipes/generic/create"})
    @ResponseBody
    public RecipeCreator.CreationResult create(HttpServletRequest req, @RequestParam(value="recipeData") SerializedRecipe recipe, @RequestParam(value="creationSettingsData") JsonObject data) throws Exception {
        try {
            AuthCtx authCtx = null;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                this.projectsService.checkPerm(authCtx, recipe.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                this.projectsService.checkPerm(authCtx, recipe.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
            RecipeMeta meta = RecipeRegistry.getMeta(recipe.type);
            RecipeCreator creator = meta.buildCreator(authCtx);
            assert (creator != null);
            RecipeCreator.CreationResult creationResult = creator.create_NT(recipe, data);
            this.achievementsService.win(authCtx, AchievementsService.AchievementId.LETS_GET_COOKING);
            this.auditTrailService.generic("recipe-create").with("projectKey", recipe.projectKey).with("recipeName", creationResult.id).with("recipeType", recipe.type).emit();
            return creationResult;
        }
        catch (Exception e) {
            this.auditTrailService.failure("recipe-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/flow/recipes/generic/copy"})
    public void copy(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String sourceProjectKey, @RequestParam String sourceRecipeName, @RequestParam String copySettingsData) throws Exception {
        try {
            AuthCtx authCtx = null;
            SerializedRecipe sourceRecipe = null;
            String sourcePayload = null;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                this.projectsService.checkPerm(authCtx, sourceProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                sourceRecipe = (SerializedRecipe)this.recipesDAO.getMandatory(sourceProjectKey, sourceRecipeName);
                sourcePayload = this.recipesDAO.getPayloadOrNull(sourceProjectKey, sourceRecipeName);
            }
            logger.info((Object)("Copying recipe " + sourceProjectKey + "." + sourceRecipeName + " to project " + projectKey));
            RecipeMeta meta = RecipeRegistry.getMeta(sourceRecipe.type);
            RecipeCreator creator = meta.buildCreator(authCtx);
            assert (creator != null);
            JsonObject copySettings = (JsonObject)JSON.parse((String)copySettingsData, JsonObject.class);
            RecipeCreator.CreationResult creationResult = creator.copy_NT(projectKey, new SerializedRecipe.SerializedRecipeAndPayload(sourceRecipe, sourcePayload), copySettings);
            GenericRecipeInteractionController.writeJSON((HttpServletResponse)resp, (Object)creationResult);
            this.auditTrailService.generic("recipe-create").with("projectKey", sourceRecipe.projectKey).with("origRecipeName", sourceRecipe.name).with("recipeName", creationResult.id).with("recipeType", sourceRecipe.type).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("recipe-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/flow/recipes/generic/get-variables"})
    public void getVariables(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String recipeData, @RequestParam(required=false) String projectKey) throws DKUSecurityException, IOException {
        Preconditions.checkArgument((StringUtils.isNotBlank((String)recipeData) || StringUtils.isNotBlank((String)projectKey) ? 1 : 0) != 0, (Object)"recipeData or projectKey is mandatory");
        if (StringUtils.isNotBlank((String)recipeData)) {
            SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
            VariablesExpansionLoopConfig veLoopConfig = null;
            if (sr.params instanceof ParamsWithVariablesExpansionLoopConfig) {
                veLoopConfig = ((ParamsWithVariablesExpansionLoopConfig)((Object)sr.params)).getVariablesExpansionLoopConfig();
            }
            this.getVariablesInternal(req, resp, sr.projectKey, veLoopConfig);
            this.auditTrailService.generic("recipe-get-variables").with("projectKey", sr.projectKey).with("veLoopConfigDatasetRef", veLoopConfig != null && veLoopConfig.isEnabled() ? veLoopConfig.datasetRef : null).emit();
        } else {
            this.getVariablesInternal(req, resp, projectKey, null);
        }
    }

    private void getVariablesInternal(HttpServletRequest req, HttpServletResponse resp, String projectKey, VariablesExpansionLoopConfig veLoopConfig) throws DKUSecurityException, IOException {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        RecipeVariablesHelper helper = new RecipeVariablesHelper();
        VariablesContext vc = helper.getVariablesContext(authCtx, projectKey, veLoopConfig);
        GenericRecipeInteractionController.writeJSON((HttpServletResponse)resp, (Object)vc.getAllVariables());
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/generic/get-status"})
    public void getStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipeData, @RequestParam String payloadData, @RequestParam String sequenceId, @RequestParam String requestData) throws Exception {
        RecipeStatus status;
        AuthCtx authCtx;
        SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, sr.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        RecipeStatusComputer computer = RecipeRegistry.getMeta(sr).buildStatusComputer(sr, payloadData);
        if (computer == null) {
            throw new Error("Recipes of type " + sr.type + " do not have a computable status");
        }
        logger.info((Object)("Computing status of recipe " + sr.name + " on computer " + String.valueOf(computer)));
        try {
            status = computer.getFullStatus_NT(authCtx, requestData);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to compute recipe status", e);
            status = new RecipeStatus.BasicRecipeStatus();
            status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute recipe status: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
        assert (status != null);
        status.sequenceId = sequenceId;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Send visual recipe status: " + JSON.json((Object)status)));
        }
        status.allMessagesForFrontend = status.gatherAllMessages();
        GenericRecipeInteractionController.writeJSON((HttpServletResponse)resp, (Object)status);
    }
}

