/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesMeta;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.code.CodeConversionService;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.codestudio.template.CodeStudioTemplatesService;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.connections.FTPConnection;
import com.dataiku.dip.connections.NonWritableConnection;
import com.dataiku.dip.connections.SSHConnection;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.exec.r.RRecipeMeta;
import com.dataiku.dip.dataflow.exec.sql.SQLQueryRecipeMeta;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderBuilder;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderBuildersRegistry;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDesc;
import com.dataiku.dip.datasets.fs.plugin.LoadedFSProvider;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.julia.JuliaRecipeMeta;
import com.dataiku.dip.recipes.code.python.PythonRecipeMeta;
import com.dataiku.dip.recipes.code.scala.SparkScalaRecipeMeta;
import com.dataiku.dip.recipes.code.spark.PySparkRecipeMeta;
import com.dataiku.dip.recipes.code.spark.SparkRRecipeMeta;
import com.dataiku.dip.recipes.eda.EDARecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.TagFilterUtils;
import com.dataiku.dip.server.UsabilityComputer;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.ETaggedResponseBody;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.recipes.InsertableFragmentsComputer;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.recipes.ShakerRecipeService;
import com.dataiku.dip.server.services.AchievementsService;
import com.dataiku.dip.server.services.ConflictCheckService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.RecipeSchemaChangeService;
import com.dataiku.dip.server.services.SQLNotebooksService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RecipesCRUDController
extends DIPInternalControllerBase {
    @Autowired
    private ShakerRecipeService shakerFlowService;
    @Autowired
    private ComputableFromRefService computableFromRefService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private RecipeSaveService saveService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private AchievementsService achievementsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private RecipeSchemaService recipeSchemaService;
    @Autowired
    private ManagedFoldersService managedFolderService;
    @Autowired
    private ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService;
    @Autowired
    private ManagedDatasetsCreationService managedDatasetsCreationService;
    @Autowired
    private StreamingEndpointService streamingEndpointService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private ConflictCheckService conflictCheckService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private JupyterService jupyterService;
    @Autowired
    private SQLNotebooksService sqlNotebooksService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private CodeConversionService codeConvService;
    @Autowired
    private CodeStudioTemplatesService codeStudioTemplatesService;
    @Autowired
    private RecipeSchemaChangeService recipeSchemaChangeService;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private IPermissionsService permissionsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.crud");

    private boolean canManagedDatasetsOnConnection(DSSConnection c2, AuthCtx liu) {
        if (!c2.allowManagedDatasets) {
            return false;
        }
        return c2.isFreelyUsableBy(liu);
    }

    @AuditedCall(value={"msgType", "connections-list"})
    @RequestMapping(value={"/api/flow/recipes/list-managed-dataset-connections"})
    public void listManagedDatasetConnections(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ArrayList<ManagedDatasetConnection> ret = new ArrayList<ManagedDatasetConnection>();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx liu = this.authService.getMandatoryUser(req);
            this.authService.getMandatoryUser(req);
            for (DSSConnection c2 : this.connectionsDAO.listUnsafe().values()) {
                if (!this.canManagedDatasetsOnConnection(c2, liu)) continue;
                ManagedDatasetConnection mdc = new ManagedDatasetConnection();
                mdc.name = c2.name;
                mdc.type = c2.getType();
                mdc.sql = c2.isProperSQL();
                if (c2 instanceof FSProviderizableConnection) {
                    mdc.fsProviderTypes = ((FSProviderizableConnection)((Object)c2)).getProviderTypes();
                }
                ret.add(mdc);
            }
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, ret);
        }
    }

    @AuditedCall(value={"msgType", "connections-list"})
    @RequestMapping(value={"/api/flow/recipes/list-managed-uploadable-connections"})
    public void listManagedUploadableConnections(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws IOException {
        ManagedDatasetsCreationService.ManagedUploadableConnectionsResponse ret = null;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            ret = this.managedDatasetsCreationService.listManagedUploadableConnections(authCtx, projectKey);
        }
        RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "connections-list"})
    @RequestMapping(value={"/api/flow/recipes/get-managed-dataset-options"})
    public void getManagedDatasetsOptions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipeData, @RequestParam String role) throws Exception {
        SerializedRecipe recipe = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, recipe.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            String lang = this.userSettingsService.getLangForUser(authCtx.getIdentifier());
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.managedDatasetsCreationService.getOptionsForRecipe(recipe, role, authCtx, true, false, false, false, lang));
        }
    }

    @AuditedCall(value={"msgType", "connections-list"})
    @RequestMapping(value={"/api/flow/recipes/get-managed-folder-options"})
    public void getManagedFoldersOptions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipeData, @RequestParam String role) throws Exception {
        SerializedRecipe recipe = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, recipe.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            String lang = this.userSettingsService.getLangForUser(authCtx.getIdentifier());
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.managedDatasetsCreationService.getOptionsForRecipe(recipe, role, authCtx, false, true, false, false, lang));
        }
    }

    @AuditedCall(value={"msgType", "connections-list"})
    @RequestMapping(value={"/api/flow/recipes/get-model-evaluation-store-options"})
    public void getModelEvaluationStoresOptions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipeData, @RequestParam String role) throws Exception {
        SerializedRecipe recipe = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, recipe.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            String lang = this.userSettingsService.getLangForUser(authCtx.getIdentifier());
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.managedDatasetsCreationService.getOptionsForRecipe(recipe, role, authCtx, false, false, false, true, lang));
        }
    }

    @AuditedCall(value={"msgType", "connections-list"})
    @RequestMapping(value={"/api/flow/recipes/get-streaming-endpoint-options"})
    public void getStreamingEndpointsOptions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipeData, @RequestParam String role) throws Exception {
        SerializedRecipe recipe = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, recipe.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            String lang = this.userSettingsService.getLangForUser(authCtx.getIdentifier());
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.managedDatasetsCreationService.getOptionsForRecipe(recipe, role, authCtx, false, false, true, false, lang));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/get-types-descriptors"})
    @ETaggedResponseBody
    public Map<String, RecipeDesc> getTypesDescriptors(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String lang) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        HashMap<String, RecipeDesc> descriptors = new HashMap<String, RecipeDesc>();
        for (RecipeMeta meta : RecipeRegistry.getAllMeta()) {
            RecipeDesc desc = meta.getRecipeDesc(lang);
            if (desc == null) continue;
            descriptors.put(meta.getType(), desc);
        }
        return descriptors;
    }

    @AuditedCall(value={"msgType", "connections-list"})
    @RequestMapping(value={"/api/flow/recipes/get-managed-dataset-options-no-context"})
    public void getManagedDatasetsOptionsNoContext(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            String lang = this.userSettingsService.getLangForUser(authCtx.getIdentifier());
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.managedDatasetsCreationService.getOptionsNoContext(authCtx, projectKey, true, false, false, false, lang));
        }
    }

    @AuditedCall(value={"msgType", "connections-list"})
    @RequestMapping(value={"/api/flow/recipes/get-managed-folder-options-no-context"})
    public void getManagedFoldersOptionsNoContext(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            String lang = this.userSettingsService.getLangForUser(authCtx.getIdentifier());
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.managedDatasetsCreationService.getOptionsNoContext(authCtx, projectKey, false, true, false, false, lang));
        }
    }

    @AuditedCall(value={"msgType", "connections-list"})
    @RequestMapping(value={"/api/flow/recipes/get-model-evaluation-store-options-no-context"})
    public void getModelEvaluationStoresOptionsNoContext(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            String lang = this.userSettingsService.getLangForUser(authCtx.getIdentifier());
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.managedDatasetsCreationService.getOptionsNoContext(authCtx, projectKey, false, false, false, true, lang));
        }
    }

    @AuditedCall(value={"msgType", "connections-list"})
    @RequestMapping(value={"/api/flow/recipes/get-streaming-endpoint-options-no-context"})
    public void getStreamingEndpointsOptionsNoContext(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            String lang = this.userSettingsService.getLangForUser(authCtx.getIdentifier());
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.managedDatasetsCreationService.getOptionsNoContext(authCtx, projectKey, false, false, true, false, lang));
        }
    }

    @AuditedCall(value={"msgType", "fsproviders-list"})
    @RequestMapping(value={"/api/flow/recipes/list-fs-providers"})
    public void listFSProviders(HttpServletRequest req, HttpServletResponse resp, @RequestParam boolean withNonWritable) throws IOException, DKUSecurityException {
        TreeMap<String, ProviderTypeAndUsability> map = new TreeMap<String, ProviderTypeAndUsability>();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            for (DSSConnection c2 : this.connectionsDAO.listUnsafe().values()) {
                if (!withNonWritable && c2 instanceof NonWritableConnection || !(c2 instanceof FSProviderizableConnection)) continue;
                for (String providerType : ((FSProviderizableConnection)((Object)c2)).getProviderTypes()) {
                    map.put(providerType, ProviderTypeAndUsability.selectable(providerType));
                }
            }
            for (String fsProviderType : CustomFSProviderBuildersRegistry.getTypes()) {
                CustomFSProviderBuilder<? extends LoadedFSProvider<? extends CustomFSProviderDesc>> provider = CustomFSProviderBuildersRegistry.get(fsProviderType);
                if (!this.permissionsService.hasPluginPrivilege(authCtx, provider.getLoaded().getOwnerPluginId(), Privileges.PluginLevelPrivilegeType.COMPONENTS_VIEWER)) {
                    map.put(fsProviderType, ProviderTypeAndUsability.nonSelectable(fsProviderType));
                    continue;
                }
                map.put(fsProviderType, ProviderTypeAndUsability.selectable(fsProviderType));
            }
            ArrayList ret = Lists.newArrayList(map.values());
            Collections.sort(ret, (a, b) -> a.providerType.compareTo(b.providerType));
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "connections-list"})
    @RequestMapping(value={"/api/flow/recipes/list-remote-dataset-connections"})
    public void listRemoteDatasetConnections(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ArrayList<RemoteDatasetConnection> ret = new ArrayList<RemoteDatasetConnection>();
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            for (DSSConnection c2 : this.connectionsDAO.listUnsafe().values()) {
                if (!(c2 instanceof SSHConnection) && !(c2 instanceof FTPConnection)) continue;
                RemoteDatasetConnection rdc = new RemoteDatasetConnection();
                rdc.name = c2.name;
                rdc.type = c2.getType();
                ret.add(rdc);
            }
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, ret);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/flow/recipes/new-managed-dataset"})
    public void newManagedDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name, @RequestParam(value="settings") ManagedDatasetsCreationService.ManagedDatasetCreationSettings settingsObj) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            AuthCtx liu = this.authService.getMandatoryUser(req);
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.managedDatasetsCreationService.create(liu, projectKey, name, settingsObj));
            t.commit("Created managed dataset: " + projectKey + "." + name);
            this.auditTrailService.generic("dataset-create").with("projectKey", projectKey).with("datasetName", name).with("connection", settingsObj.connectionId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("dataset-create", (Throwable)e).with("projectKey", projectKey).with("datasetName", name).with("connection", settingsObj.connectionId).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/flow/recipes/new-managed-folder"})
    public void newManagedFolder(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name, @RequestParam ManagedFoldersService.ManagedFolderCreationSettings settings) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            logger.info((Object)("Creating managed folder in project " + projectKey));
            ManagedFolder odb = this.managedFolderService.create(projectKey, name, settings, t.getUser());
            logger.info((Object)"Managed folder ready to commit ");
            t.commit("Created managed folder: " + projectKey + "." + name);
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)odb);
            this.auditTrailService.generic("folder-create").with("projectKey", projectKey).with("folderId", odb.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("folder-create", (Throwable)e).with("projectKey", projectKey).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/flow/recipes/new-model-evaluation-store"})
    public void newModelEvaluationStore(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name, @RequestParam ModelEvaluationStoresCRUDService.ModelEvaluationStoreCreationSettings settings) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            logger.info((Object)("Creating model evaluation store in project " + projectKey));
            ModelEvaluationStore mes = this.modelEvaluationStoresCRUDService.create(projectKey, name, settings);
            logger.info((Object)"Model evaluation store ready to commit ");
            t.commit("Created model evaluation store: " + projectKey + "." + name);
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)mes);
            this.auditTrailService.generic("evaluation-store-create").with("projectKey", projectKey).with("mesId", mes.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("evaluation-store-create", (Throwable)e).with("projectKey", projectKey).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/flow/recipes/new-streaming-endpoint"})
    public void newStreamingEndpoint(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name, @RequestParam StreamingEndpointService.StreamingEndpointCreationSettings settings) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            logger.info((Object)("Creating streaming endpoint in project " + projectKey));
            StreamingEndpoint se = this.streamingEndpointService.create_T(t.getUser(), projectKey, name, settings);
            logger.info((Object)"Streaming endpoint ready to commit ");
            t.commit("Created streaming endpoint : " + projectKey + "." + name);
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)se);
            this.auditTrailService.generic("streaming-endpoint-create").with("projectKey", projectKey).with("streamingEndpointId", se.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("streaming-endpoint-create", (Throwable)e).with("projectKey", projectKey).emit();
            throw e;
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/check-save-conflict"})
    public void checkSaveConflict(HttpServletRequest req, HttpServletResponse resp, String projectKey, String name, String recipe) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SerializedRecipe existingRecipe = (SerializedRecipe)this.recipesDAO.getOrNullUnsafe(projectKey, name);
            SerializedRecipe newRecipe = (SerializedRecipe)JSON.parse((String)recipe, SerializedRecipe.class);
            VersionTag.ConflictCheckResult ccr = existingRecipe != null ? this.conflictCheckService.checkConflict(existingRecipe.versionTag, newRecipe.versionTag) : this.conflictCheckService.checkConflict(null, newRecipe.versionTag);
            if (!ccr.canBeSaved) {
                ccr.message = "This recipe is being edited by more than one user.";
            }
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)ccr);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/flow/recipes/create"})
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipe, @RequestParam(required=false, value="scriptData") String scriptData) throws Exception {
        SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipe, SerializedRecipe.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            logger.info((Object)("Create recipe of type: " + sr.type));
            if (StringUtils.isBlank((String)sr.name)) {
                throw ErrorContext.iae((String)"Recipe has no name");
            }
            if (this.recipesDAO.getOrNullUnsafe(projectKey, sr.name) != null) {
                sr.name = this.saveService.transmogrifyName(projectKey, sr.name);
            }
            if (sr.type.equals("shaker")) {
                SerializedShakerScript sss = (SerializedShakerScript)JSON.parse((String)scriptData, SerializedShakerScript.class);
                scriptData = JSON.pretty((Object)sss);
            }
            SerializedRecipe savedRecipe = this.saveService.create(projectKey, sr, scriptData);
            if (sr.type.equals("shaker")) {
                savedRecipe = this.shakerFlowService.tryUpdateShakerRecipeDependencies(projectKey, sr.name);
            }
            savedRecipe.name = sr.name;
            this.achievementsService.win(u, AchievementsService.AchievementId.LETS_GET_COOKING);
            t.commit("Created recipe: " + projectKey + "." + sr.name, 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)savedRecipe);
            this.auditTrailService.generic("recipe-create").with("projectKey", projectKey).with("recipeType", sr.type).with("recipeName", sr.name).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("recipe-create", (Throwable)e).with("projectKey", projectKey).with("recipeType", sr.type).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/flow/recipes/save"})
    public void saveRecipe(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipe, @RequestParam(required=false, value="scriptData") String scriptData, @RequestParam(required=false, value="commitMessage") String commitMessage) throws Exception {
        Transaction t;
        SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipe, SerializedRecipe.class);
        try {
            t = this.transactionService.beginRead();
            try {
                this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
            this.checkNotNull(sr, "Empty recipe", new Object[0]);
            if (StringUtils.isBlank((String)sr.name)) {
                throw ErrorContext.iae((String)"Recipe has no name");
            }
            if (sr.type.equals("shaker")) {
                SerializedShakerScript sss = (SerializedShakerScript)JSON.parse((String)scriptData, SerializedShakerScript.class);
                scriptData = JSON.pretty((Object)sss);
            }
            if (sr.type.equals(PredictionRecipesMeta.EVALUATION_META.getType())) {
                scriptData = this.recipeSchemaChangeService.updateEvalRecipeScriptDataPossibleCustomMetrics_NT(projectKey, sr, scriptData);
            }
        }
        catch (Exception e) {
            this.auditTrailService.failure("recipe-save", (Throwable)e).with("projectKey", sr.projectKey).with("recipeName", sr.name).emit();
            throw e;
        }
        try {
            t = this.transactionService.beginWriteForUI(req);
            try {
                SerializedRecipe savedRecipe = this.saveService.save(projectKey, sr, scriptData);
                if (sr.type.equals("shaker")) {
                    savedRecipe = this.shakerFlowService.tryUpdateShakerRecipeDependencies(projectKey, sr.name);
                }
                savedRecipe.name = sr.name;
                if (StringUtils.isNotBlank((String)commitMessage)) {
                    t.commit(commitMessage, 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
                } else {
                    t.commit("Saved recipe: " + projectKey + "." + sr.name, 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
                }
                RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)savedRecipe);
                this.auditTrailService.generic("recipe-save").with("projectKey", sr.projectKey).with("recipeName", sr.name).emit();
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
        }
        catch (Exception e) {
            this.auditTrailService.failure("recipe-save", (Throwable)e).with("projectKey", sr.projectKey).with("recipeName", sr.name).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "recipe-rename", "projectKey", "${projectKey}", "origName", "${origName}", "newName", "${newName}"})
    @RequestMapping(value={"/api/flow/recipes/rename"})
    public void renameRecipe(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String origName, @RequestParam String newName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            logger.info((Object)("Rename recipe: " + origName + " -> " + newName));
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.saveService.rename(t, projectKey, origName, newName);
            t.commit("Renamed recipe " + origName + " to " + newName);
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/get-shaker-save-impact"})
    public void getShakerSaveImpact(HttpServletRequest req, HttpServletResponse resp, String projectKey, @RequestParam String recipe, @RequestParam String shaker, @RequestParam String outputSchema) throws Exception {
        Schema inputDatasetSchema;
        Dataset dataset;
        SerializedRecipe.RecipeOutput ro;
        AuthCtx authCtx;
        SerializedRecipe sa = (SerializedRecipe)JSON.parse((String)recipe, SerializedRecipe.class);
        assert (sa.type.equals("shaker"));
        DataService.ShakerRecipeSchema srs = null;
        if (outputSchema != null) {
            srs = (DataService.ShakerRecipeSchema)JSON.parse((String)outputSchema, DataService.ShakerRecipeSchema.class);
        }
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            ro = sa.getSingleOutput("main");
            logger.info((Object)("Checking schema compatibility for " + sa.name));
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(sa.projectKey, ro.ref);
            dataset = this.datasetAccessService.getMandatory(loc);
            inputDatasetSchema = this.shakerFlowService.getInputDatasetSchema(sa);
        }
        RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.shakerFlowService.getSchemaUpdateResult_NT(authCtx, ro.ref, srs, dataset, false, false, inputDatasetSchema));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/get-computable-save-impact"})
    public void getComputableSaveImpact(HttpServletRequest req, HttpServletResponse resp, String projectKey, @RequestParam String recipe, @RequestParam String payload) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipe, SerializedRecipe.class);
        RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.recipeSchemaService.computeSaveImpact_NT(authCtx, sr, payload));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/recipes/get-computable-save-impacts"})
    public void getComputableSaveImpacts(HttpServletRequest req, HttpServletResponse resp, String projectKey, @RequestParam String recipes, @RequestParam String payloads) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        List srs = (List)JSON.parse((String)recipes, (TypeToken)new TypeToken<ArrayList<SerializedRecipe>>(){});
        List rds = (List)JSON.parse((String)payloads, (TypeToken)new TypeToken<ArrayList<String>>(){});
        if (srs.size() != rds.size()) {
            throw new IllegalArgumentException("Recipes and payloads don't have the same length");
        }
        int i = 0;
        RecipeSchemaService.RecipeSchemaAutoupdateResult acc = new RecipeSchemaService.RecipeSchemaAutoupdateResult();
        for (SerializedRecipe sr : srs) {
            RecipeSchemaService.RecipeSchemaAutoupdateResult add = this.recipeSchemaService.computeSaveImpact_NT(authCtx, sr, (String)rds.get(i++));
            acc.totalIncompatibilities += add.totalIncompatibilities;
            acc.computables.addAll(add.computables);
        }
        RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)acc);
    }

    @AuditedCall(value={"msgType", "recipe-update-sm-usabilities", "projectKey", "${projectKey}", "predictionType", "${predictionType}"})
    @RequestMapping(value={"/api/flow/recipes/update-sm-usabilities"})
    @ResponseBody
    public List<UsabilityComputer.UsableComputable> updateSavedModelUsabilities(HttpServletRequest req, @RequestParam String projectKey, @RequestParam Boolean inputModelNeedsDataFolder, @RequestParam String inputModelPredictionTypeAsString, @RequestParam List<UsabilityComputer.UsableComputable> computables) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        PredictionMLTask.PredictionType inputModelPredictionType = null;
        if (StringUtils.isNotBlank((String)inputModelPredictionTypeAsString)) {
            inputModelPredictionType = PredictionMLTask.PredictionType.valueOf(inputModelPredictionTypeAsString);
        }
        for (UsabilityComputer.UsableComputable computable : computables) {
            computable.checkPredictionSMInputCompatibilityForRecipes(inputModelNeedsDataFolder, inputModelPredictionType);
        }
        return computables;
    }

    @AuditedCall(value={"msgType", "dataset-save-schema", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/flow/recipes/save-output-schema"})
    public void saveRecipeOutputSchema(HttpServletRequest req, HttpServletResponse resp, String projectKey, @RequestParam String computableType, @RequestParam String computableId, @RequestParam String newSchema, @RequestParam boolean dropAndRecreate, @RequestParam boolean synchronizeMetastore, @RequestParam(required=false) String extraOptions) throws Exception {
        Callable<RecipeSaveService.RecipeSchemaUpdatedWarnings> delayedUpdateResult;
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, computableId);
        Schema newSchemaObj = (Schema)JSON.parse((String)newSchema, Schema.class);
        JsonObject extra = StringUtils.isNotBlank((String)extraOptions) ? (JsonObject)JSON.parse((String)extraOptions, JsonObject.class) : null;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            delayedUpdateResult = this.recipeSchemaService.updateComputableOutputSchemaForRecipe(t.getUser(), projectKey, FlowComputable.FCType.valueOf(computableType), loc, newSchemaObj, dropAndRecreate, synchronizeMetastore, extra);
            t.commit("Updated schema of " + loc.getFullName() + " from recipe in project " + projectKey);
        }
        RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)delayedUpdateResult.call());
    }

    @AuditedCall(value={"msgType", "recipes-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/recipes/list"})
    public void listRecipes(HttpServletRequest req, HttpServletResponse resp, String projectKey) throws Exception {
        ArrayList<SerializedRecipe.RecipeListItem> heads = new ArrayList<SerializedRecipe.RecipeListItem>();
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            for (SerializedRecipe sr : this.recipesDAO.listUnsafe(projectKey)) {
                try {
                    SerializedRecipe.RecipeListItem head = new SerializedRecipe.RecipeListItem(sr);
                    this.taggableObjectsService.setEditionInfoFromTags(sr, head);
                    heads.add(head);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to read recipe " + sr.name), (Throwable)e);
                }
            }
        }
        RecipesCRUDController.writeJSON((HttpServletResponse)resp, heads);
    }

    @AuditedCall(value={"msgType", "recipes-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/recipes/list-heads"})
    public void listHeads(HttpServletRequest req, HttpServletResponse resp, String projectKey, String tagFilter) throws Exception {
        AuthCtx u;
        TagFilterUtils.TagFilter tf = (TagFilterUtils.TagFilter)JSON.parse((String)tagFilter, TagFilterUtils.TagFilter.class);
        TaggableObjectsService.FilteredTaggableItems heads = new TaggableObjectsService.FilteredTaggableItems();
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            u = this.authService.getMandatoryUser(req);
            for (SerializedRecipe sr : this.recipesDAO.listUnsafe(projectKey)) {
                if (!TagFilterUtils.matches(tf, sr.tags)) {
                    ++heads.filteredOut;
                    continue;
                }
                SerializedRecipe.RecipeListItem head = new SerializedRecipe.RecipeListItem(sr);
                this.taggableObjectsService.setEditionInfoFromTags(sr, head);
                heads.items.add(head);
            }
        }
        this.interestsService.enrichListItems(u.getAssociatedDSSUser(), projectKey, heads.items);
        RecipesCRUDController.writeJSON((HttpServletResponse)resp, heads);
    }

    @AuditedCall(value={"msgType", "recipes-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/recipes/list-names"})
    public void listNames(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        List<String> datasetsNames;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            datasetsNames = this.recipesDAO.listUsedNames(projectKey);
        }
        RecipesCRUDController.writeJSON((HttpServletResponse)resp, datasetsNames);
    }

    @AuditedCall(value={"msgType", "recipe-get", "projectKey", "${projectKey}", "recipeName", "${name}"})
    @RequestMapping(value={"/api/flow/recipes/get"})
    public void getRecipe(HttpServletRequest req, HttpServletResponse resp, String projectKey, String name) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, this.recipesDAO.getMandatoryUnsafe(projectKey, name));
        }
    }

    @AuditedCall(value={"msgType", "recipe-get", "projectKey", "${projectKey}", "recipeName", "${name}"})
    @RequestMapping(value={"/api/flow/recipes/get-with-inline-script"})
    public void getWithScript(HttpServletRequest req, HttpServletResponse resp, String projectKey, String name) throws Exception {
        RecipeWithScript ret = new RecipeWithScript();
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ret.recipe = (SerializedRecipe)this.recipesDAO.getMandatoryUnsafe(projectKey, name);
            ret.script = this.recipesDAO.getPayloadOrNull(projectKey, name);
            if (RecipeRegistry.getMeta(ret.recipe) instanceof EDARecipeMeta) {
                EDARecipeMeta meta = (EDARecipeMeta)RecipeRegistry.getMeta(ret.recipe);
                ret.script = JSON.json((Object)meta.parsePayload(ret.script));
            }
            ret.canEditInCodeStudio = this.codeStudioTemplatesService.canEditInCodeStudio();
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/flow/recipes/get-insertable-fragments"})
    public void getInsertableFragments(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipe) throws Exception {
        SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipe, SerializedRecipe.class);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            InsertableFragmentsComputer ifc = new InsertableFragmentsComputer(projectKey, this.authService.getMandatoryUser(req));
            this.auditTrailService.generic("get-insertable-fragments").with("projectKey", projectKey).with("recipeName", sr.name).emit();
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)ifc.computeInsertableCodeFragments(sr));
        }
    }

    @AuditedCall(value={"msgType", "recipe-get", "projectKey", "${projectKey}", "recipeName", "${name}"})
    @RequestMapping(value={"/api/flow/recipes/get-full-info"})
    public void getFullInfo(HttpServletRequest req, HttpServletResponse resp, String projectKey, String name) throws Exception {
        NavigatorService.RecipeFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            u = this.authService.getMandatoryUser(req);
            info = this.navigatorService.getRecipeFullInfo(projectKey, name);
        }
        this.navigatorService.addInfo_NT(info, u);
        RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)info);
    }

    @AuditedCall(value={"msgType", "creating-recipes-get", "computables", "${computables}"})
    @RequestMapping(value={"/api/flow/recipes/get-creating-recipes"})
    public void getCreatingRecipes(HttpServletRequest req, HttpServletResponse resp, String computables) throws Exception {
        List parsedComputables = (List)JSON.parse((String)computables, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        ArrayList<NavigatorService.CreatingRecipeFullInfo> recipes = new ArrayList<NavigatorService.CreatingRecipeFullInfo>();
        try (Transaction t = this.transactionService.beginRead();){
            for (TaggableObjectsService.TaggableObjectRef objectRef : parsedComputables) {
                this.projectsService.checkPerm(req, objectRef.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                NavigatorService.CreatingRecipeFullInfo creatingRecipe = this.navigatorService.getCreatingRecipe(objectRef.projectKey, objectRef.type, objectRef.id);
                if (creatingRecipe == null) continue;
                recipes.add(creatingRecipe);
            }
        }
        RecipesCRUDController.writeJSON((HttpServletResponse)resp, recipes);
    }

    @AuditedCall(value={"msgType", "recipe-check-notebook-edition", "projectKey", "${projectKey}", "recipeName", "${name}"})
    @RequestMapping(value={"/api/flow/recipes/check-notebook-edition"})
    public void checkNotebookEdition(HttpServletRequest req, HttpServletResponse resp, String projectKey, String name) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            liu.failIfNoSafeCode("create a Jupyter notebook");
            SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatoryUnsafe(projectKey, name);
            String recipeCode = this.recipesDAO.getPayloadOrNull(projectKey, name);
            String recipeType = recipe.getType();
            if (!(PythonRecipeMeta.META.getType().equals(recipeType) || PySparkRecipeMeta.META.getType().equals(recipeType) || RRecipeMeta.META.getType().equals(recipeType) || SparkRRecipeMeta.META.getType().equals(recipeType) || SparkScalaRecipeMeta.META.getType().equals(recipeType) || JuliaRecipeMeta.META.getType().equals(recipeType))) {
                throw ErrorContext.iae((String)("Invalid recipe type: " + recipeType));
            }
            if (PythonRecipeMeta.META.getType().equals(recipeType) || PySparkRecipeMeta.META.getType().equals(recipeType) || RRecipeMeta.META.getType().equals(recipeType) || SparkRRecipeMeta.META.getType().equals(recipeType) || SparkScalaRecipeMeta.META.getType().equals(recipeType) || JuliaRecipeMeta.META.getType().equals(recipeType)) {
                this.licenseEnforcementService.checkRegularCodeAllowed(liu);
            }
            NotebookConflictResponse response = new NotebookConflictResponse();
            JupyterUtils.JupyterNotebookListEntry jupy = this.jupyterService.getNotebookForAssociatedRecipe(projectKey, name);
            if (jupy != null) {
                RelFile nbFile = this.jupyterService.getNotebookFile(jupy.projectKey, jupy.name);
                JsonParser jp = new JsonParser();
                String nbRecipeCode = this.codeConvService.notebookToRecipe(recipeType, jp.parse(t.readStringUTF8(nbFile)).getAsJsonObject());
                String recipeCodeStrandardized = this.codeConvService.notebookToRecipe(recipeType, this.codeConvService.recipeToNotebook(recipeType, recipeCode, null));
                if (!recipeCodeStrandardized.equals(nbRecipeCode)) {
                    response.conflict = true;
                    response.notebook = jupy.name;
                }
            }
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)response);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/flow/recipes/edit-in-sql-notebook"}, method={RequestMethod.POST})
    public void editInSQLNotebook(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeName) throws Exception {
        String recipeCode;
        SerializedRecipe recipe;
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            recipe = (SerializedRecipe)this.recipesDAO.getMandatory(projectKey, recipeName);
            recipeCode = this.recipesDAO.getPayloadOrNull(projectKey, recipeName);
        }
        ErrorContext.check((boolean)Objects.equals(recipe.type, SQLQueryRecipeMeta.META.getType()), (String)"Recipe is not a SQL query recipe");
        this.licenseEnforcementService.checkSQLAllowed(liu);
        SQLNotebook notebook = this.sqlNotebooksService.getOrCreateForSQLRecipe(liu, recipe, recipeCode.trim());
        RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)new JSON.JsonBuilder().kv("notebookId", (Object)notebook.id).kv("cellId", (Object)notebook.cells.get((int)(notebook.cells.size() - 1)).id).get());
        this.auditTrailService.generic("recipe-edit-in-notebook").with("projectKey", projectKey).with("notebookName", notebook.name).with("forRecipe", recipe.name).emit();
    }

    @AuditInline
    @RequestMapping(value={"/api/flow/recipes/edit-in-notebook"})
    public void editInNotebook(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name, @RequestParam(required=false, value="codeEnvSelection") String codeEnvSelectionStr, @RequestParam(required=false, value="containerSelection") String containerSelectionStr) throws Exception {
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, name);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            liu.failIfNoSafeCode("create a Jupyter notebook");
            SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatoryUnsafe(projectKey, name);
            String recipeType = recipe.getType();
            if (!(PythonRecipeMeta.META.getType().equals(recipeType) || PySparkRecipeMeta.META.getType().equals(recipeType) || RRecipeMeta.META.getType().equals(recipeType) || SparkRRecipeMeta.META.getType().equals(recipeType) || SparkScalaRecipeMeta.META.getType().equals(recipeType) || JuliaRecipeMeta.META.getType().equals(recipeType))) {
                throw ErrorContext.iae((String)("Invalid recipe type: " + recipeType));
            }
            if (PythonRecipeMeta.META.getType().equals(recipeType) || PySparkRecipeMeta.META.getType().equals(recipeType) || RRecipeMeta.META.getType().equals(recipeType) || SparkRRecipeMeta.META.getType().equals(recipeType) || SparkScalaRecipeMeta.META.getType().equals(recipeType) || JuliaRecipeMeta.META.getType().equals(recipeType)) {
                this.licenseEnforcementService.checkRegularCodeAllowed(liu);
            }
            CodeEnvSelection codeEnvSelection = StringUtils.isNotBlank((String)codeEnvSelectionStr) ? (CodeEnvSelection)JSON.parse((String)codeEnvSelectionStr, CodeEnvSelection.class) : null;
            ContainerExecSelection containerSelection = StringUtils.isNotBlank((String)containerSelectionStr) ? (ContainerExecSelection)JSON.parse((String)containerSelectionStr, ContainerExecSelection.class) : null;
            JupyterUtils.JupyterNotebookListEntry nb = this.jupyterService.createNotebookForRecipe(liu, projectKey, loc, codeEnvSelection, containerSelection);
            RecipesCRUDController.writeJSON((HttpServletResponse)resp, (Object)new Id(nb.name));
            t.commit("Created Jupyter notebook '" + nb.name + "' for recipe '" + loc.getFullName() + "' (lang=" + recipe.getType() + ")");
            this.auditTrailService.generic("recipe-edit-in-notebook").with("projectKey", projectKey).with("notebookName", nb.name).with("forRecipe", loc.getFullName()).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("recipe-edit-in-notebook", (Throwable)e).with("projectKey", projectKey).emit();
            throw e;
        }
    }

    public static class ManagedDatasetConnection {
        public String name;
        public String type;
        public boolean sql;
        public List<String> fsProviderTypes;
    }

    public static class ProviderTypeAndUsability {
        public String providerType;
        public boolean permitted;

        static ProviderTypeAndUsability selectable(String providerType) {
            ProviderTypeAndUsability ret = new ProviderTypeAndUsability();
            ret.providerType = providerType;
            ret.permitted = true;
            return ret;
        }

        static ProviderTypeAndUsability nonSelectable(String providerType) {
            ProviderTypeAndUsability ret = new ProviderTypeAndUsability();
            ret.providerType = providerType;
            ret.permitted = false;
            return ret;
        }
    }

    public static class RemoteDatasetConnection {
        public String name;
        public String type;
        public List<String> providerTypes;
    }

    public static class RecipeWithScript {
        public SerializedRecipe recipe;
        public String script;
        public boolean canEditInCodeStudio;
    }

    static class NotebookConflictResponse {
        boolean conflict;
        String notebook;

        NotebookConflictResponse() {
        }
    }

    static class ValidateGRELResponse {
        boolean ok;
        String message;
        String sql;
        boolean fullyTranslated;

        ValidateGRELResponse() {
        }
    }
}

