/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.stereotype.Service;

@Service
public class AsyncTasksService {
    private final Queue<AsyncTask> queue;
    private final List<Thread> threads = new ArrayList<Thread>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.pubsub");

    public AsyncTasksService() {
        int queueMax = DKUApp.getParams().getIntParam("dku.asynctasks.queue.max", Integer.valueOf(1000000));
        this.queue = new LinkedBlockingQueue<AsyncTask>(queueMax);
        int processingThreads = DKUApp.getParams().getIntParam("dku.asynctasks.threads", Integer.valueOf(2));
        for (int i = 0; i < processingThreads; ++i) {
            ProcessingThread pt = new ProcessingThread(i);
            this.threads.add(pt);
            pt.start();
        }
        DSSMetrics.registry().register("dku.asynctasks.queue.size", (Metric)((Gauge)this.queue::size));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        logger.info((Object)"Clearing async tasks queue");
        AsyncTasksService asyncTasksService = this;
        synchronized (asyncTasksService) {
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String debug() {
        StringBuilder sb = new StringBuilder();
        long now = System.currentTimeMillis();
        AsyncTasksService asyncTasksService = this;
        synchronized (asyncTasksService) {
            for (AsyncTask task : this.queue) {
                sb.append("Task type=").append(task.type).append(" label=").append(task.label).append(" clazz=").append(task.runnable.getClass().getCanonicalName()).append(" queueTimeMS=").append(now - task.submitTS).append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(String type, String label, Runnable runnable) {
        AsyncTask at = new AsyncTask();
        at.submitTS = System.currentTimeMillis();
        at.type = type;
        at.label = label;
        at.runnable = runnable;
        AsyncTasksService asyncTasksService = this;
        synchronized (asyncTasksService) {
            this.queue.add(at);
            this.notifyAll();
        }
    }

    class ProcessingThread
    extends Thread {
        ProcessingThread(int i) {
            this.setName("AsyncTasksProcessor-" + i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                AsyncTask task;
                logger.info((Object)"Waiting for a task to run");
                try {
                    AsyncTasksService asyncTasksService = AsyncTasksService.this;
                    synchronized (asyncTasksService) {
                        while (AsyncTasksService.this.queue.isEmpty()) {
                            AsyncTasksService.this.wait();
                        }
                        task = AsyncTasksService.this.queue.remove();
                    }
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"The AsyncTasksProcessor thread was interrupted, but it must stay alive, ignoring", (Throwable)e);
                    continue;
                }
                if (task == null) {
                    logger.warn((Object)"The AsyncTasksProcessor thread got a null task ... weird ... ignoring");
                    continue;
                }
                logger.info((Object)("Running task " + task.label + " (in the queue for " + (System.currentTimeMillis() - task.submitTS) / 1000L + "s)"));
                DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)("dku.asynctasks.process." + task.type));
                try {
                    long now = System.currentTimeMillis();
                    try {
                        task.runnable.run();
                        logger.warn((Object)("Task " + task.label + " done in " + (System.currentTimeMillis() - now)));
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("Task " + task.label + " failed in " + (System.currentTimeMillis() - now)), t);
                    }
                    continue;
                }
                finally {
                    if (tctx == null) continue;
                    tctx.close();
                    continue;
                }
                break;
            }
        }
    }

    static class AsyncTask {
        long submitTS;
        Runnable runnable;
        String type;
        String label;

        AsyncTask() {
        }
    }
}

