/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.ConnectionMetadataDAO;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConnectionMetadataService {
    @Autowired
    private ConnectionMetadataDAO connectionMetadataDAO;

    public void saveMessages(Map<String, InfoMessage.InfoMessages> messagesPerConnection) throws IOException {
        Map<String, ConnectionMetadataDAO.ConnectionMetadata> metadataPerConnection = this.connectionMetadataDAO.getAll();
        for (Map.Entry<String, InfoMessage.InfoMessages> connectionAndMessages : messagesPerConnection.entrySet()) {
            if (connectionAndMessages.getValue().messages.isEmpty()) continue;
            ConnectionMetadataDAO.ConnectionMetadata connectionMetadata = metadataPerConnection.get(connectionAndMessages.getKey());
            if (connectionMetadata == null) {
                connectionMetadata = new ConnectionMetadataDAO.ConnectionMetadata();
            }
            connectionMetadata.messages = connectionAndMessages.getValue();
        }
        this.connectionMetadataDAO.save(metadataPerConnection.values());
    }

    public ConnectionMetadataDAO.ConnectionMetadata getConnectionMetadata(String connectionName) throws IOException {
        return this.connectionMetadataDAO.getAll().get(connectionName);
    }

    public Map<String, ConnectionMetadataDAO.ConnectionMetadata> getAllConnectionsMetadata() throws IOException {
        return this.connectionMetadataDAO.getAll();
    }

    public void save(Collection<ConnectionMetadataDAO.ConnectionMetadata> metadata) throws IOException {
        this.connectionMetadataDAO.save(metadata);
    }

    public void save(ConnectionMetadataDAO.ConnectionMetadata mc) throws IOException {
        this.connectionMetadataDAO.save(mc);
    }
}

