/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.ImagesDAO;
import com.dataiku.dip.projects.apps.CustomAppTemplatesService;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelib.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.input.AutoCloseInputStream;
import com.mortennobel.imagescaling.AdvancedResizeOp;
import com.mortennobel.imagescaling.ResampleOp;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImageService {
    public static final int THUMBNAIL_IMAGE_HEIGHT = 150;
    @Autowired
    ImagesDAO dao;
    @Autowired
    PubSubService pubSub;
    @Autowired
    CustomAppTemplatesService customAppTemplatesService;
    public List<Color> defaultProjectColors = ImmutableList.of((Object)new Color(249, 189, 56), (Object)new Color(160, 160, 160), (Object)new Color(40, 170, 221), (Object)new Color(41, 175, 93), (Object)new Color(242, 140, 56), (Object)new Color(244, 67, 54));
    private static final int PATTERN_COUNT = 8;
    private final Pattern sizePattern = Pattern.compile("^[0-9]{1,3}x[0-9]{1,3}$");
    private static final Logger logger = Logger.getLogger((String)"image.service");

    public void setImage(String projectKey, String type, String id, byte[] imgBytes) throws IOException {
        ByteArrayInputStream imgStream = new ByteArrayInputStream(imgBytes);
        BufferedImage img = ImageIO.read(imgStream);
        if (img == null) {
            logger.error((Object)"Unable to set image as no decoder have been found for the supplied image data");
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if ("USER".equals(type)) {
            BufferedImage imgToWrite;
            int h = img.getHeight();
            int w = img.getWidth();
            if (h > 256 || w > 256) {
                int requiredWidth;
                int requiredHeight;
                if (h > w) {
                    requiredHeight = 256;
                    requiredWidth = w * 256 / h;
                } else {
                    requiredHeight = h * 256 / w;
                    requiredWidth = 256;
                }
                ResampleOp resampler = new ResampleOp(requiredWidth, requiredHeight);
                resampler.setUnsharpenMask(AdvancedResizeOp.UnsharpenMask.None);
                BufferedImage rescaledImage = resampler.filter(img, null);
                BufferedImage output = new BufferedImage(requiredWidth, requiredHeight, 2);
                Graphics2D g2d = output.createGraphics();
                g2d.setBackground(new Color(0, 0, 0, 0));
                AffineTransform at = new AffineTransform();
                g2d.drawRenderedImage(rescaledImage, at);
                imgToWrite = output;
            } else {
                imgToWrite = img;
            }
            ImageIO.write((RenderedImage)imgToWrite, "png", baos);
        } else {
            ImageIO.write((RenderedImage)img, "png", baos);
        }
        this.dao.clearCachedPictures(projectKey, type, id);
        this.dao.setOriginalImage(projectKey, type, id, new ByteArrayInputStream(baos.toByteArray()));
    }

    public void setCapturedThumbnail_NT(String projectKey, String type, String id, byte[] imgBytes, Integer resizeWidth, Integer resizeHeight) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        ByteArrayInputStream imgStream = new ByteArrayInputStream(imgBytes);
        BufferedImage img = ImageIO.read(imgStream);
        if (img == null) {
            logger.error((Object)"Unable to set image as no decoder have been found for the supplied image data");
            return;
        }
        if (resizeWidth != null || resizeHeight != null) {
            if (resizeHeight == null) {
                resizeHeight = (int)Math.round((double)resizeWidth.intValue() * (double)img.getHeight() / (double)img.getWidth());
            } else if (resizeWidth == null) {
                resizeWidth = (int)Math.round((double)resizeHeight.intValue() * (double)img.getWidth() / (double)img.getHeight());
            }
            img = ImageService.generateThumbnail(img, resizeWidth + "x" + resizeHeight);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "png", baos);
        this.dao.clearCachedPictures(projectKey, type, id);
        this.dao.setCapturedThumbnail(projectKey, type, id, new ByteArrayInputStream(baos.toByteArray()));
    }

    public void clearCache(String projectKey) {
        logger.info((Object)("Clearing cached pictures for project " + projectKey));
        try {
            this.dao.clearProjectCachedPictures(projectKey);
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to clear cached pictures for project", (Throwable)e);
        }
    }

    @PostConstruct
    public void registerHandlers() {
        logger.debug((Object)"Init images service");
        DSSEventListener listener = evt -> this.clearCache(evt.projectKey);
        this.pubSub.subscribe("project-bundle-activated", listener);
        this.pubSub.subscribe("project-deleted", listener);
        this.pubSub.subscribe("project-created", listener);
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        if (gs.whiteLabeling != null && gs.whiteLabeling.defaultProjectColors != null && !gs.whiteLabeling.defaultProjectColors.isEmpty()) {
            this.defaultProjectColors = gs.whiteLabeling.defaultProjectColors.stream().map(col -> new Color((Integer)col.get(0), (Integer)col.get(1), (Integer)col.get(2))).collect(Collectors.toList());
        }
        logger.debug((Object)"Done init images settings service");
    }

    public Set<String> cleanupPromotedContentImages(Set<String> imagesToKeep) throws IOException {
        return this.dao.cleanupPromotedContentImages(imagesToKeep);
    }

    public void removeImage(String projectKey, String type, String id) throws IOException {
        this.dao.removeOriginalImage(projectKey, type, id);
    }

    private AutoCloseInputStream getDefaultInsightPicture(String projectKey, String type, String id) {
        if (type.equals("DASHBOARD_TILE")) {
            String res = "com/dataiku/dip/images/default-INSIGHT.png";
            return new AutoCloseInputStream(this.getClass().getClassLoader().getResourceAsStream(res));
        }
        throw new Error("Should not ask for default image here");
    }

    private Color darker(Color in) {
        double FACTOR = 0.92;
        return new Color(Math.max((int)((double)in.getRed() * FACTOR), 0), Math.max((int)((double)in.getGreen() * FACTOR), 0), Math.max((int)((double)in.getBlue() * FACTOR), 0));
    }

    private Color generateProjectColor(String seed) {
        int hashcode = seed.hashCode();
        int rnd = hashcode == Integer.MIN_VALUE ? 0 : Math.abs(hashcode) % this.defaultProjectColors.size();
        return this.defaultProjectColors.get(rnd);
    }

    public Integer generateProjectPattern(String seed) {
        int hashcode = seed.hashCode();
        return (hashcode == Integer.MIN_VALUE ? 0 : Math.abs(hashcode) % 8) + 1;
    }

    public String generateProjectColorAsHex(String projectKey) {
        return String.format("#%06x", this.generateProjectColor(projectKey).getRGB() & 0xFFFFFF);
    }

    private InputStream makeDefaultProjectPic(String projectKey, String color, Integer pattern, String initials) throws IOException {
        if (pattern == null || pattern <= 0 || pattern > 8) {
            pattern = this.generateProjectPattern(projectKey);
        }
        AutoCloseInputStream in = new AutoCloseInputStream(this.getClass().getClassLoader().getResourceAsStream("com/dataiku/dip/images/patterns/" + pattern + ".png"));
        BufferedImage newImg = ImageIO.read((InputStream)in);
        int width = newImg.getWidth();
        int height = newImg.getHeight();
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.drawImage((Image)newImg, 0, 0, null);
        Color imageColor = color != null ? Color.decode(color) : this.generateProjectColor(projectKey);
        g2d.setColor(imageColor);
        g2d.setComposite(AlphaComposite.getInstance(10, 0.75f));
        g2d.fillRect(0, 0, width, height);
        if (initials != null) {
            initials = initials.length() < 2 ? initials : initials.substring(0, 2);
            Font font = new Font("Arial", 0, 80);
            FontRenderContext frc = new FontRenderContext(null, true, true);
            TextLayout layout = new TextLayout(initials, font, frc);
            Rectangle textR = layout.getPixelBounds(null, 0.0f, 0.0f);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2d.setFont(font);
            g2d.setColor(Color.white);
            g2d.setComposite(AlphaComposite.getInstance(10, 1.0f));
            g2d.drawString(initials, (int)((double)(width / 2) - textR.getWidth() / 2.0), (int)((double)(height / 2) + textR.getHeight() / 2.0));
        }
        img.flush();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "png", baos);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private InputStream makeDefaultUserPic(String id) throws IOException {
        int margin = 300;
        Font font = new Font("Arial", 0, 418);
        FontRenderContext frc = new FontRenderContext(null, true, true);
        TextLayout layout = new TextLayout(id.substring(0, 1).toUpperCase(), font, frc);
        Rectangle r = layout.getPixelBounds(null, 0.0f, 0.0f);
        int imageSize = Math.max(r.width, r.height) + margin;
        BufferedImage bi = new BufferedImage(imageSize, imageSize, 2);
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        int hashcode = id.hashCode();
        int rnd = hashcode == Integer.MIN_VALUE ? 0 : Math.abs(hashcode) % 12;
        switch (rnd) {
            case 0: {
                g2d.setColor(new Color(244, 67, 54));
                break;
            }
            case 1: {
                g2d.setColor(new Color(233, 30, 99));
                break;
            }
            case 2: {
                g2d.setColor(new Color(156, 39, 176));
                break;
            }
            case 3: {
                g2d.setColor(new Color(103, 58, 183));
                break;
            }
            case 4: {
                g2d.setColor(new Color(33, 150, 243));
                break;
            }
            case 5: {
                g2d.setColor(new Color(0, 188, 212));
                break;
            }
            case 6: {
                g2d.setColor(new Color(0, 150, 136));
                break;
            }
            case 7: {
                g2d.setColor(new Color(76, 175, 80));
                break;
            }
            case 8: {
                g2d.setColor(new Color(139, 195, 74));
                break;
            }
            case 9: {
                g2d.setColor(new Color(205, 220, 57));
                break;
            }
            case 10: {
                g2d.setColor(new Color(249, 189, 56));
                break;
            }
            case 11: {
                g2d.setColor(new Color(242, 140, 56));
            }
        }
        g2d.fillRect(0, 0, imageSize, imageSize);
        g2d.setColor(Color.white);
        int offsetX = -r.x + (imageSize - r.width) / 2;
        int offsetY = -r.y + (imageSize - r.height) / 2;
        layout.draw(g2d, offsetX, offsetY);
        g2d.dispose();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, "png", baos);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private InputStream getDefaultPicture(String projectKey, String type, String id, String color, Integer pattern, String initials) throws IOException {
        if (type.equals("PROJECT") || type.equals("PUBLISHED_PROJECT")) {
            return this.makeDefaultProjectPic(projectKey, color, pattern, initials);
        }
        if (type.equals("USER")) {
            return this.makeDefaultUserPic(id);
        }
        if (type.equals("APP") || type.equals("APPFULL")) {
            return this.makeDefaultProjectPic(id, color, pattern, initials);
        }
        if ("DASHBOARD".equals(type) || "WEB_APP".equals(type) || "ARTICLE".equals(type) || "DATASET".equals(type)) {
            return this.dao.getCapturedThumbnail(projectKey, type, id);
        }
        return this.getDefaultInsightPicture(projectKey, type, id);
    }

    public long getOriginalImgHash(String projectKey, String type, String id) throws IOException {
        if (this.isPluginAppTemplate(type, id)) {
            File appImage = this.customAppTemplatesService.getAppImage(id, "APPFULL".equals(type));
            if (appImage == null) {
                return 0L;
            }
            return appImage.lastModified();
        }
        return this.dao.getOriginalImageHash(projectKey, type, id);
    }

    public long generateNewImgHash(String projectKey, String type, String id) throws IOException {
        int h = (projectKey + "." + type + "." + id).hashCode();
        return h < 0 ? (long)(-h) : (long)h;
    }

    public long getImgHash(String projectKey, String type, String id) throws IOException {
        long hash = this.getOriginalImgHash(projectKey, type, id);
        if (hash == 0L) {
            return this.generateNewImgHash(projectKey, type, id);
        }
        return hash;
    }

    private InputStream getPluginAppImage(String id, String color, Integer pattern, String initials, boolean fullImage) throws IOException {
        File appImage = this.customAppTemplatesService.getAppImage(id, fullImage);
        if (appImage == null) {
            return this.makeDefaultProjectPic(id, color, pattern, initials);
        }
        return FileUtils.openInputStream((File)appImage);
    }

    public long getCapturedObjectThumbnailLastModified(String projectKey, String type, String id) throws IOException {
        long originalImageHash = this.dao.getOriginalImageHash(projectKey, type, id);
        if (originalImageHash != 0L) {
            return Long.MAX_VALUE;
        }
        return this.dao.getCapturedThumbnailLastModified(projectKey, type, id);
    }

    public synchronized InputStream getImage(String projectKey, String type, String id, String size, MutableLong lastModified, String color, Integer pattern, String initials) throws IOException {
        if (this.isPluginAppTemplate(type, id)) {
            return this.getPluginAppImage(id, color, pattern, initials, "APPFULL".equals(type));
        }
        if (StringUtils.isBlank((String)size) || StringUtils.equals((String)size, (String)"original")) {
            InputStream pic = this.dao.getOriginalImage(projectKey, type, id, lastModified);
            if (pic == null) {
                pic = this.getDefaultPicture(projectKey, type, id, color, pattern, initials);
            }
            return pic;
        }
        if (this.sizePattern.matcher(size).find()) {
            InputStream pic = this.dao.getResizedImage(projectKey, type, id, size, lastModified);
            if (pic != null) {
                return pic;
            }
            InputStream originalPic = this.dao.getOriginalImage(projectKey, type, id, lastModified);
            BufferedImage originalImg = null;
            originalImg = originalPic != null ? ImageIO.read(originalPic) : ImageIO.read(this.getDefaultPicture(projectKey, type, id, color, pattern, initials));
            BufferedImage resizedThumbnail = ImageService.generateThumbnail(originalImg, size);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)resizedThumbnail, "png", baos);
            byte[] bytes = baos.toByteArray();
            this.dao.setResizedImage(projectKey, type, id, new ByteArrayInputStream(bytes), size);
            return new ByteArrayInputStream(bytes);
        }
        throw ErrorContext.iaef((String)"Invalid size argument : %s", (Object)size, (Object[])new Object[0]);
    }

    private boolean isPluginAppTemplate(String type, String id) {
        return ("APP".equals(type) || "APPFULL".equals(type)) && id.startsWith("PLUGIN_");
    }

    private static BufferedImage generateThumbnail(BufferedImage image, String size) {
        String[] splits = size.split("x");
        int requiredWidth = Integer.parseInt(splits[0]);
        int requiredHeight = Integer.parseInt(splits[1]);
        ResampleOp resampler = new ResampleOp(requiredWidth, requiredHeight);
        resampler.setUnsharpenMask(AdvancedResizeOp.UnsharpenMask.None);
        BufferedImage rescaledImage = resampler.filter(image, null);
        BufferedImage output = new BufferedImage(requiredWidth, requiredHeight, 2);
        Graphics2D g2d = output.createGraphics();
        g2d.setBackground(new Color(0, 0, 0, 0));
        AffineTransform at = new AffineTransform();
        g2d.drawRenderedImage(rescaledImage, at);
        return output;
    }
}

