/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.dao.IPersistentNotificationsInternalDB;
import com.dataiku.dip.dao.PersistentNotificationsInternalDB;
import com.dataiku.dip.plugins.PluginStoreService;
import com.dataiku.dip.plugins.model.StorePluginsList;
import com.dataiku.dip.requestcenter.Request;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.AbstractCodeEnvRequestEvent;
import com.dataiku.dip.server.notifications.backend.AbstractPluginRequestEvent;
import com.dataiku.dip.server.notifications.backend.AccessGrantedEvent;
import com.dataiku.dip.server.notifications.backend.AccessRequestEvent;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.CodeEnvRequestGrantedEvent;
import com.dataiku.dip.server.notifications.backend.CommitMentionEvent;
import com.dataiku.dip.server.notifications.backend.InstanceAccessRequestEvent;
import com.dataiku.dip.server.notifications.backend.JobStateChangedEvent;
import com.dataiku.dip.server.notifications.backend.NotificationsCountUpdatedEvent;
import com.dataiku.dip.server.notifications.backend.ProfileUpgradeRequestEvent;
import com.dataiku.dip.server.notifications.backend.TimelineItemEvent;
import com.dataiku.dip.server.notifications.backend.UserEvent;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.dataiku.dip.timelines.TimelineItem;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersistentNotificationsService {
    private static final int MAX_NOTIFICATIONS_PER_USER = 50;
    public static final String NAME = "persistent_notifications";
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private EnrichmentService enrichmentService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private PluginStoreService pluginsStoreService;
    private IPersistentNotificationsInternalDB dao;
    private static Logger logger = Logger.getLogger((String)"dku.pnotifications");

    public PersistentNotificationsService() {
        try {
            this.dao = new PersistentNotificationsInternalDB(NAME, 50);
            this.dao.create();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to init persistent notifications service", (Throwable)e);
        }
    }

    public void push(String user, String id, DSSEvent evt, boolean markAsRead) {
        try {
            IPersistentNotificationsInternalDB.PersistentNotification latest = this.dao.getLatestForUserAndObject(user, id);
            if (this.collapse(evt, latest)) {
                this.dao.update(user, id, latest.timestamp, evt);
                logger.info((Object)("Updated notification user=" + user + " object=" + id + " evt=" + evt.getName() + " read=" + markAsRead));
            } else {
                this.dao.insert(user, id, evt, markAsRead);
                int unread = this.dao.getUnreadCountForUser(user);
                this.pubSub.publish(new NotificationsCountUpdatedEvent(user, unread));
                logger.info((Object)("Added notification user=" + user + " object=" + id + " evt=" + evt.getName() + " unread=" + unread));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to store notification", (Throwable)e);
        }
    }

    private boolean collapse(DSSEvent a, IPersistentNotificationsInternalDB.PersistentNotification latest) {
        if (latest == null) {
            return false;
        }
        UserEvent b = latest.evt;
        if (a instanceof TimelineItemEvent && b instanceof TimelineItemEvent) {
            TimelineItem tia = ((TimelineItemEvent)a).item;
            TimelineItem tib = ((TimelineItemEvent)b).item;
            return tia != null && tib != null && tia.action == tib.action && StringUtils.equals((String)tia.user, (String)tib.user) && latest.unread;
        }
        return false;
    }

    public void deleteForUser(String user) {
        try {
            this.dao.deleteForUser(user);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to delete notifications", (Throwable)e);
        }
    }

    public void updateTask(String id, DSSEvent evt) {
        try {
            this.dao.updateTask(id, evt);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to update job state in notifications", (Throwable)e);
        }
    }

    public void acknowledge(String user, long timestamp) {
        try {
            this.dao.acknowledge(user, timestamp);
            this.pubSub.publish(new NotificationsCountUpdatedEvent(user, 0));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to acknowledge persistent notifications", (Throwable)e);
        }
    }

    public void acknowledgeObject(String user, String fullyQualifiedObjectId) {
        try {
            boolean hasAcknowledge = this.dao.acknowledgeObject(user, fullyQualifiedObjectId);
            if (hasAcknowledge) {
                this.pubSub.publish(new NotificationsCountUpdatedEvent(user, this.dao.getUnreadCountForUser(user)));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to acknowledge persistent notifications", (Throwable)e);
        }
    }

    public void acknowledgeObject(String user, String projectKey, ITaggingService.TaggableType objectType, String objectId, String workspaceKey) {
        this.acknowledgeObject(user, this.getFullyQualifiedDSSObjectId(objectType, projectKey, objectId, workspaceKey));
    }

    public NotificationsResponse getForUser(String user) throws Exception {
        NotificationsResponse ret = new NotificationsResponse();
        ret.notifications = this.dao.getForUser(user);
        ret.computeUnreadCount();
        return ret;
    }

    public int getUnreadCountForUser(String user) throws Exception {
        int ret = this.dao.getUnreadCountForUser(user);
        logger.info((Object)("Get unread notification count for " + user + ": " + ret));
        return ret;
    }

    public NotificationsResponse getForUserWithSummaries(String user) throws Exception {
        NotificationsResponse ret = this.getForUser(user);
        try (Transaction t = this.transactionService.beginRead();){
            for (IPersistentNotificationsInternalDB.PersistentNotification pn : ret.notifications) {
                TaggableObjectsService.TaggableObject to;
                ITaggingService.TaggableType taggableType;
                Request.RequestObjectType requestObjectType;
                TaggableObjectsService.TaggableObject project;
                Object pu;
                BackendEvent evt;
                if (pn.evt instanceof TimelineItemEvent) {
                    TimelineItemEvent tie = (TimelineItemEvent)pn.evt;
                    this.enrichmentService.enrich(tie.item);
                    continue;
                }
                if (pn.evt instanceof CommitMentionEvent) {
                    evt = (CommitMentionEvent)pn.evt;
                    this.enrichmentService.enrich((EnrichmentService.Enrichable)evt);
                    pu = this.usersService.getPublicUser(evt.author);
                    evt.getDetails().addProperty("authorDisplayName", ((PublicUser)pu).displayName);
                    continue;
                }
                if (pn.evt instanceof JobStateChangedEvent) {
                    evt = (JobStateChangedEvent)pn.evt;
                    if (evt.outputs == null) continue;
                    for (JobDef.JobOutput output : evt.outputs) {
                        this.enrichmentService.enrich(output);
                    }
                    continue;
                }
                if (pn.evt instanceof AccessRequestEvent) {
                    evt = (AccessRequestEvent)pn.evt;
                    this.enrichmentService.enrich((EnrichmentService.Enrichable)evt);
                    pu = this.usersService.getPublicUser(evt.getUserLogin());
                    evt.getDetails().addProperty("authorDisplayName", ((PublicUser)pu).displayName);
                    project = this.taggableObjectsReadService.getOrNullUnsafe(evt.getProjectKey(), ITaggingService.TaggableType.PROJECT, evt.getProjectKey());
                    if (project != null) {
                        evt.getDetails().addProperty("projectDisplayName", project.getDisplayName());
                    }
                    requestObjectType = evt.getObjectType();
                    taggableType = requestObjectType.toTaggableType().orElse(null);
                    if (!evt.getObjectType().needsNameEnrichment() || taggableType == null || (to = this.taggableObjectsReadService.getOrNullUnsafe(evt.getProjectKey(), taggableType, evt.getObjectId())) == null) continue;
                    evt.getDetails().addProperty("objectDisplayName", to.getDisplayName());
                    continue;
                }
                if (pn.evt instanceof AbstractPluginRequestEvent) {
                    evt = (AbstractPluginRequestEvent)pn.evt;
                    pu = this.usersService.getPublicUser(evt.getUserLogin());
                    evt.getDetails().addProperty("authorDisplayName", ((PublicUser)pu).displayName);
                    this.pluginsStoreService.getStorePluginDesc(evt.getObjectId()).ifPresent(arg_0 -> PersistentNotificationsService.lambda$getForUserWithSummaries$0((AbstractPluginRequestEvent)evt, arg_0));
                    continue;
                }
                if (pn.evt instanceof AbstractCodeEnvRequestEvent) {
                    evt = (AbstractCodeEnvRequestEvent)pn.evt;
                    pu = this.usersService.getPublicUser(evt.getUserLogin());
                    evt.getDetails().addProperty("authorDisplayName", ((PublicUser)pu).displayName);
                    if (!(pn.evt instanceof CodeEnvRequestGrantedEvent)) continue;
                    CodeEnvRequestGrantedEvent grantedEvent = (CodeEnvRequestGrantedEvent)pn.evt;
                    evt.getDetails().addProperty("objectDisplayName", grantedEvent.getTargetName());
                    continue;
                }
                if (pn.evt instanceof AccessGrantedEvent) {
                    evt = (AccessGrantedEvent)pn.evt;
                    this.enrichmentService.enrich((EnrichmentService.Enrichable)evt);
                    pu = this.usersService.getPublicUser(evt.getUserLogin());
                    evt.getDetails().addProperty("authorDisplayName", ((PublicUser)pu).displayName);
                    project = this.taggableObjectsReadService.getOrNullUnsafe(evt.getProjectKey(), ITaggingService.TaggableType.PROJECT, evt.getProjectKey());
                    if (project != null) {
                        evt.getDetails().addProperty("projectDisplayName", project.getDisplayName());
                    }
                    requestObjectType = evt.getObjectType();
                    taggableType = requestObjectType.toTaggableType().orElse(null);
                    if (!requestObjectType.needsNameEnrichment() || taggableType == null || (to = this.taggableObjectsReadService.getOrNullUnsafe(evt.getProjectKey(), taggableType, evt.getObjectId())) == null) continue;
                    evt.getDetails().addProperty("objectDisplayName", to.getDisplayName());
                    continue;
                }
                if (pn.evt instanceof InstanceAccessRequestEvent) {
                    evt = (InstanceAccessRequestEvent)pn.evt;
                    pu = this.usersService.getPublicUser(evt.getUserLogin());
                    evt.getDetails().addProperty("authorDisplayName", ((PublicUser)pu).displayName);
                    continue;
                }
                if (!(pn.evt instanceof ProfileUpgradeRequestEvent)) continue;
                evt = (ProfileUpgradeRequestEvent)pn.evt;
                pu = this.usersService.getPublicUser(evt.getUserLogin());
                evt.getDetails().addProperty("authorDisplayName", ((PublicUser)pu).displayName);
            }
        }
        return ret;
    }

    public String getFullyQualifiedDSSObjectId(ITaggingService.TaggableType objectType, String projectKey, String objectId, String workspaceKey) {
        if (StringUtils.isNotBlank((String)workspaceKey)) {
            return String.valueOf((Object)objectType) + "$$$" + projectKey + "$$$" + objectId + "$$$" + workspaceKey;
        }
        return String.valueOf((Object)objectType) + "$$$" + projectKey + "$$$" + objectId;
    }

    public void garbageCollect() throws Exception {
        ((PersistentNotificationsInternalDB)this.dao).garbageCollect();
    }

    private static /* synthetic */ void lambda$getForUserWithSummaries$0(AbstractPluginRequestEvent evt, StorePluginsList.StorePlugin storePlugin) {
        evt.getDetails().addProperty("objectDisplayName", storePlugin.meta.label);
    }

    public static class NotificationsResponse {
        public List<IPersistentNotificationsInternalDB.PersistentNotification> notifications;
        public int totalUnread;
        public long timestamp = new Date().getTime();

        public void computeUnreadCount() {
            this.totalUnread = 0;
            for (IPersistentNotificationsInternalDB.PersistentNotification notif : this.notifications) {
                if (!notif.unread) continue;
                ++this.totalUnread;
            }
        }
    }

    public static class GroupedPersistentNotification {
        GroupedNotificationType groupType;
        List<IPersistentNotificationsInternalDB.PersistentNotification> notifications;
    }

    public static enum GroupedNotificationType {
        RECIPE_EDITIONS;

    }

    public static class JobPersistentNotificationWithSummary
    extends IPersistentNotificationsInternalDB.PersistentNotification {
        FlowExecutionService2.JobSummary summary;

        JobPersistentNotificationWithSummary(IPersistentNotificationsInternalDB.PersistentNotification other, FlowExecutionService2.JobSummary summary) {
            super(other);
            this.summary = summary;
        }
    }
}

