/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.ElasticSearchConnection;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.SearchNotebooksDAO;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDialect;
import com.dataiku.dip.searchnotebooks.SearchNotebook;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchNotebooksService {
    @Autowired
    private SearchNotebooksDAO searchNotebooksDAO;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private ITaggingService taggingService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private TaggableObjectDiffService colaborativeMetadataDiffService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private TaggableObjectsService taggableObjectsService;

    public void delete(AuthCtx user, String projectKey, String id) throws Exception {
        SearchNotebook nbk = this.getMandatoryUnsafe(projectKey, id);
        this.customPolicyHooksRegistry.onPreObjectDelete(user, (TaggableObjectsService.TaggableObject)this.searchNotebooksDAO.getOrNull(projectKey, id));
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", nbk.name);
        this.searchNotebooksDAO.delete(projectKey, id);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.SEARCH_NOTEBOOK, projectKey, id, user, TaggableObjectChangedEvent.ActionType.SEARCH_NOTEBOOK_DELETE).withDetails(details));
    }

    public String copy(AuthCtx liu, String projectKey, String notebookId, String newNotebookName) throws Exception {
        SearchNotebook nbk = (SearchNotebook)this.searchNotebooksDAO.getMandatory(projectKey, notebookId);
        this.connectionsService.checkUserForConnection(liu, nbk.connection);
        String id = this.copyInternal(liu, nbk, newNotebookName);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", newNotebookName);
        TaggableObjectChangedEvent taggableObjectChangedEvent = new TaggableObjectChangedEvent(ITaggingService.TaggableType.SEARCH_NOTEBOOK, projectKey, id, liu, TaggableObjectChangedEvent.ActionType.SEARCH_NOTEBOOK_CREATE);
        this.pubSub.publishAfterTransaction(taggableObjectChangedEvent.withDetails(details));
        return id;
    }

    private String copyInternal(AuthCtx user, SearchNotebook nbk, String newNotebookName) throws Exception {
        StringTransmogrifier stm = new StringTransmogrifier(" ");
        for (SearchNotebook head : this.searchNotebooksDAO.listUnsafe(nbk.projectKey)) {
            stm.addAlreadyTransmogrifiedAcceptDupes(head.name);
        }
        String id = SecretKeyGenerator.generateSmall();
        SearchNotebook newNbk = (SearchNotebook)this.searchNotebooksDAO.getMandatory(nbk.projectKey, nbk.id);
        newNbk.id = id;
        newNbk.creationTag = new VersionTag(user.getIdentifier());
        newNbk.versionTag = new VersionTag(user.getIdentifier());
        if (StringUtils.isBlank((String)newNotebookName)) {
            newNotebookName = "Untitled search notebook";
        }
        newNbk.name = stm.transmogrify(newNotebookName);
        this.customPolicyHooksRegistry.onPreObjectSave(user, nbk, newNbk);
        this.searchNotebooksDAO.copy(nbk, newNbk);
        return id;
    }

    public boolean isDialectCompatible(ElasticSearchConnection connection) {
        return connection.params.dialect == ElasticSearchDialect.ES_7;
    }

    public String create(AuthCtx u, String projectKey, String connection, String name) throws Exception {
        this.connectionsService.checkUserForConnection(u, connection);
        ElasticSearchConnection esConn = (ElasticSearchConnection)this.connectionsService.listUnsafe().get(connection);
        if (!this.isDialectCompatible(esConn)) {
            throw new IllegalArgumentException("Search notebooks only support dialect 7 and above. Got: " + String.valueOf((Object)esConn.params.dialect));
        }
        StringTransmogrifier stm = new StringTransmogrifier(" ");
        for (SearchNotebook head : this.list(projectKey)) {
            stm.addAlreadyTransmogrifiedAcceptDupes(head.name);
        }
        String id = SecretKeyGenerator.generateSmall();
        SearchNotebook nbk = new SearchNotebook();
        nbk.projectKey = projectKey;
        nbk.id = id;
        nbk.connection = connection;
        nbk.creationTag = new VersionTag(u.getIdentifier());
        nbk.versionTag = new VersionTag(u.getIdentifier());
        if (StringUtils.isBlank((String)name)) {
            name = "Untitled search notebook";
        }
        nbk.name = stm.transmogrify(name);
        if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            nbk.automationLocal = true;
        }
        this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(nbk);
        this.customPolicyHooksRegistry.onPreObjectSave(u, null, nbk);
        this.searchNotebooksDAO.save(nbk);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", name);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.SEARCH_NOTEBOOK, projectKey, id, u, TaggableObjectChangedEvent.ActionType.SEARCH_NOTEBOOK_CREATE).withDetails(details));
        return id;
    }

    public List<SearchNotebook> list(String projectKey) throws IOException {
        return this.searchNotebooksDAO.list(projectKey);
    }

    public SearchNotebook save(SearchNotebook nbk, boolean summaryOnly) throws Exception {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        SearchNotebook preExisting = this.getMandatoryUnsafe(nbk.projectKey, nbk.id);
        TaggableObjectDiffService.TaggableObjectsDiff diff = this.colaborativeMetadataDiffService.diff(preExisting, nbk, t.getUser().getIdentifier());
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(nbk, preExisting);
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), (TaggableObjectsService.TaggableObject)this.searchNotebooksDAO.getOrNull(nbk.projectKey, nbk.id), nbk);
        this.searchNotebooksDAO.save(nbk);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", nbk.name);
        if (diff.metadataChanged()) {
            this.colaborativeMetadataDiffService.publishAfterTransaction(diff);
        }
        if (!summaryOnly) {
            TaggableObjectChangedEvent event = new TaggableObjectChangedEvent(ITaggingService.TaggableType.SEARCH_NOTEBOOK, nbk.projectKey, nbk.id, t.getUser(), TaggableObjectChangedEvent.ActionType.SEARCH_NOTEBOOK_EDIT);
            this.pubSub.publishAfterTransaction(event.withDetails(details));
        }
        this.taggingService.onObjectSaved(nbk.projectKey, nbk.tags);
        return nbk;
    }

    public SearchNotebook getMandatoryUnsafe(String projectKey, String id) throws IOException {
        return (SearchNotebook)this.searchNotebooksDAO.getMandatoryUnsafe(projectKey, id);
    }
}

