/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThemesService {
    @Autowired
    IPluginsRegistryService pluginsService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.themes");

    public Theme get(String themeId) throws IOException {
        File themesFolder = ApplicationConfigurator.getFile((String[])new String[]{"resources", "themes", themeId});
        if (themesFolder.isDirectory()) {
            return this.readTheme(themesFolder, ThemeOrigin.USER);
        }
        for (InstalledPluginDesc ipd : this.pluginsService.getLoadedPlugins()) {
            File pluginResourceDirectory = this.pluginsService.getActualPluginFolder(ipd.desc.id);
            File pluginThemesDirectory = new File(pluginResourceDirectory, "themes");
            File pluginThemeDirectory = DKUFileUtils.getWithin((File)pluginThemesDirectory, (String[])new String[]{themeId});
            if (!pluginThemeDirectory.isDirectory()) continue;
            return this.readTheme(pluginThemeDirectory, ThemeOrigin.PLUGIN, ipd.desc.id);
        }
        File builtinThemeFolder = ApplicationConfigurator.getResourceFile((String[])new String[]{"themes", themeId});
        if (builtinThemeFolder.isDirectory()) {
            return this.readTheme(builtinThemeFolder, ThemeOrigin.BUILTIN);
        }
        throw new IllegalArgumentException("Unknown theme: " + themeId);
    }

    public List<Theme> list(AuthCtx user) throws IOException {
        File[] files;
        Object files2;
        ArrayList<Theme> list = new ArrayList<Theme>();
        File themesFolder = ApplicationConfigurator.getFile((String[])new String[]{"resources", "themes"});
        if (themesFolder.isDirectory() && (files2 = themesFolder.listFiles()) != null) {
            for (Object themeFolder : files2) {
                if (!((File)themeFolder).isDirectory()) continue;
                try {
                    list.add(this.readTheme((File)themeFolder, ThemeOrigin.USER));
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to read theme from " + String.valueOf(themeFolder)), (Throwable)e);
                }
            }
        }
        for (InstalledPluginDesc ipd : this.pluginsService.getLoadedPlugins()) {
            File pluginThemeDirectory;
            logger.info((Object)("Checking for themes in plugin " + ipd.desc.id));
            File pluginResourceDirectory = this.pluginsService.getPluginResourceFolder(ipd.desc.id);
            if (!pluginResourceDirectory.isDirectory() || !(pluginThemeDirectory = new File(pluginResourceDirectory, "themes")).isDirectory()) continue;
            logger.info((Object)("Plugin " + ipd.desc.id + " has themes : " + String.valueOf(pluginThemeDirectory)));
            File[] files3 = pluginThemeDirectory.listFiles();
            if (files3 == null) continue;
            for (File themeFolder : files3) {
                if (!themeFolder.isDirectory()) continue;
                try {
                    list.add(this.readTheme(themeFolder, ThemeOrigin.PLUGIN, ipd.desc.id));
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to read theme from " + String.valueOf(themeFolder)), (Throwable)e);
                }
            }
        }
        File builtInSnippetFolder = ApplicationConfigurator.getResourceFile((String)"themes");
        if (builtInSnippetFolder.isDirectory() && (files = builtInSnippetFolder.listFiles()) != null) {
            for (File themeFolder : files) {
                if (!themeFolder.isDirectory()) continue;
                try {
                    list.add(this.readTheme(themeFolder, ThemeOrigin.BUILTIN));
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to read theme from " + String.valueOf(themeFolder)), (Throwable)e);
                }
            }
        }
        return list;
    }

    private Theme readTheme(File folder, ThemeOrigin themeOrigin) throws IOException {
        Theme theme = (Theme)JSON.parseFile((File)new File(folder, "theme.json"), Theme.class);
        theme.id = folder.getName();
        theme.origin = themeOrigin.toString();
        return theme;
    }

    private Theme readTheme(File folder, ThemeOrigin themeOrigin, String pluginId) throws IOException {
        Theme theme = this.readTheme(folder, themeOrigin);
        theme.pluginId = pluginId;
        return theme;
    }

    public static enum ThemeOrigin {
        BUILTIN,
        USER,
        PLUGIN;

    }

    public static class Theme {
        public String id;
        public String name;
        public String author;
        public String background;
        public String thumbnail;
        public String origin;
        public String pluginId;
        public String favicon;
        public boolean isUnitedColorBg;
    }
}

