/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TrackingService;
import com.dataiku.dip.utils.DKULogger;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TrackingSessionUtils {
    private static Map<ITaggingService.TaggableType, String> statePrefixes = new EnumMap<ITaggingService.TaggableType, String>(ITaggingService.TaggableType.class);
    static DKULogger logger;

    private TrackingSessionUtils() {
    }

    public static boolean isOnProject(TrackingService.TrackingSession session, String projectKey) {
        String currentProjectKey = session.getStateParamAsString("projectKey");
        return currentProjectKey != null && currentProjectKey.equals(projectKey);
    }

    public static boolean isOnModelsListPage(TrackingService.TrackingSession session, String projectKey, String mlTaskId) {
        String stateName = session.getState();
        if (stateName == null) {
            return false;
        }
        if (!"projects.project.analyses.analysis.ml.predmltask.list".equals(stateName) && !"projects.project.analyses.analysis.ml.clsutmltask.list".equals(stateName)) {
            return false;
        }
        String currentProjectKey = session.getStateParamAsString("projectKey");
        if (currentProjectKey == null || !currentProjectKey.equals(projectKey)) {
            return false;
        }
        String currentTaskId = session.getStateParamAsString("mlTaskId");
        return currentTaskId != null && currentTaskId.equals(mlTaskId);
    }

    public static ObjectDesc getTaggableObjectDesc(TrackingService.TrackingSession session) {
        if (session == null || session.getStateParams() == null) {
            return null;
        }
        ObjectDesc desc = new ObjectDesc();
        desc.projectKey = session.getStateParamAsString("projectKey");
        desc.objectType = TrackingSessionUtils.getObjectType(session);
        desc.objectId = TrackingSessionUtils.getObjectId(session, desc.objectType);
        desc.workspaceKey = session.getStateParamAsString("workspaceKey");
        if (desc.objectId == null) {
            return null;
        }
        return desc;
    }

    public static boolean isOnObjectPage(TrackingService.TrackingSession session, ITaggingService.TaggableType objectType, String projectKey, String objectId) {
        ObjectDesc desc = TrackingSessionUtils.getTaggableObjectDesc(session);
        if (desc == null) {
            return false;
        }
        return objectType == desc.objectType && StringUtils.equals((String)projectKey, (String)desc.projectKey) && StringUtils.equals((String)objectId, (String)desc.objectId);
    }

    public static boolean isOnFQObjectPage(TrackingService.TrackingSession session, String fullyQualifiedObjectId) {
        String desc = TrackingSessionUtils.getNonTaggableObjectIdOrNull(session);
        if (desc == null) {
            return false;
        }
        return StringUtils.equals((String)fullyQualifiedObjectId, (String)desc);
    }

    public static String getNonTaggableObjectIdOrNull(TrackingService.TrackingSession session) {
        if (session == null || session.getStateParams() == null) {
            return null;
        }
        String stateName = session.getState();
        if (stateName == null) {
            return null;
        }
        if (stateName.startsWith("projects.project.jobs.job")) {
            return session.getStateParamAsString("jobId");
        }
        if (stateName.startsWith("projects.project.analyses.analysis.ml.clustmltask")) {
            return session.getStateParamAsString("mlTaskId");
        }
        if (stateName.startsWith("projects.project.analyses.analysis.ml.predmltask")) {
            return session.getStateParamAsString("mlTaskId");
        }
        return null;
    }

    private static ITaggingService.TaggableType getObjectType(TrackingService.TrackingSession session) {
        String stateName = session.getState();
        if (stateName == null) {
            return null;
        }
        for (Map.Entry<ITaggingService.TaggableType, String> e : statePrefixes.entrySet()) {
            if (!stateName.startsWith(e.getValue())) continue;
            return e.getKey();
        }
        if (stateName.startsWith("projects.project")) {
            return ITaggingService.TaggableType.PROJECT;
        }
        return null;
    }

    private static String getObjectId(TrackingService.TrackingSession session, ITaggingService.TaggableType objectType) {
        if (objectType == null) {
            return null;
        }
        objectType.assertNotFakeType();
        switch (objectType) {
            case DATASET: {
                return session.getStateParamAsString("datasetName");
            }
            case STREAMING_ENDPOINT: {
                return session.getStateParamAsString("streamingEndpointId");
            }
            case RECIPE: {
                return session.getStateParamAsString("recipeName");
            }
            case LABELING_TASK: {
                return session.getStateParamAsString("labelingTaskId");
            }
            case ANALYSIS: {
                return session.getStateParamAsString("analysisId");
            }
            case STATISTICS_WORKSHEET: {
                return session.getStateParamAsString("worksheetId");
            }
            case SAVED_MODEL: {
                return session.getStateParamAsString("smId");
            }
            case MODEL_EVALUATION_STORE: {
                return session.getStateParamAsString("mesId");
            }
            case MANAGED_FOLDER: {
                return session.getStateParamAsString("odbId");
            }
            case SQL_NOTEBOOK: {
                return session.getStateParamAsString("notebookId");
            }
            case SEARCH_NOTEBOOK: {
                return session.getStateParamAsString("notebookId");
            }
            case JUPYTER_NOTEBOOK: {
                return session.getStateParamAsString("notebookId");
            }
            case DASHBOARD: {
                return session.getStateParamAsString("dashboardId");
            }
            case INSIGHT: {
                return session.getStateParamAsString("insightId");
            }
            case LAMBDA_SERVICE: {
                return session.getStateParamAsString("serviceId");
            }
            case PROJECT: {
                return session.getStateParamAsString("projectKey");
            }
            case SCENARIO: {
                return session.getStateParamAsString("scenarioId");
            }
            case WEB_APP: {
                return session.getStateParamAsString("webAppId");
            }
            case CODE_STUDIO: {
                return session.getStateParamAsString("codeStudioObjectId");
            }
            case REPORT: {
                return session.getStateParamAsString("reportId");
            }
            case ARTICLE: {
                return session.getStateParamAsString("articleId");
            }
            case DATA_COLLECTION: {
                return session.getStateParamAsString("dataCollectionId");
            }
            case FLOW_ZONE: {
                return null;
            }
        }
        return null;
    }

    static {
        for (ITaggingService.TaggableType t : ITaggingService.TaggableType.values()) {
            String prefix = null;
            switch (t) {
                case ANALYSIS: {
                    prefix = "projects.project.analyses.analysis";
                    break;
                }
                case STATISTICS_WORKSHEET: {
                    prefix = "projects.project.worksheets.worksheet";
                    break;
                }
                case DASHBOARD: {
                    prefix = "projects.project.dashboards.dashboard";
                    break;
                }
                case DATASET: {
                    prefix = "projects.project.datasets.dataset";
                    break;
                }
                case STREAMING_ENDPOINT: {
                    prefix = "projects.project.streaming-endpoints.streaming-endpoint";
                    break;
                }
                case INSIGHT: {
                    prefix = "projects.project.dashboards.insights.insight";
                    break;
                }
                case JUPYTER_NOTEBOOK: {
                    prefix = "projects.project.notebooks.jupyter_notebook";
                    break;
                }
                case MANAGED_FOLDER: {
                    prefix = "projects.project.managedfolders.managedfolder";
                    break;
                }
                case RECIPE: {
                    prefix = "projects.project.recipes.recipe";
                    break;
                }
                case LABELING_TASK: {
                    prefix = "projects.project.labelingtasks.labelingtask";
                    break;
                }
                case REPORT: {
                    prefix = "projects.project.reports.report";
                    break;
                }
                case SAVED_MODEL: {
                    prefix = "projects.project.savedmodels.savedmodel";
                    break;
                }
                case MODEL_EVALUATION_STORE: {
                    prefix = "projects.project.modelevaluationstores.modelevaluationstore";
                    break;
                }
                case SCENARIO: {
                    prefix = "projects.project.scenarios.scenario";
                    break;
                }
                case SQL_NOTEBOOK: {
                    prefix = "projects.project.notebooks.sql_notebook";
                    break;
                }
                case SEARCH_NOTEBOOK: {
                    prefix = "projects.project.notebooks.search_notebook";
                    break;
                }
                case WEB_APP: {
                    prefix = "projects.project.webapps.webapp";
                    break;
                }
                case CODE_STUDIO: {
                    prefix = "projects.project.code-studios.code-studio";
                    break;
                }
                case ARTICLE: {
                    prefix = "projects.project.wiki.article";
                    break;
                }
                case LAMBDA_SERVICE: {
                    prefix = "projects.project.lambdaservices.service";
                    break;
                }
                case MODEL_COMPARISON: {
                    prefix = "projects.project.modelcomparisons.modelcomparison";
                    break;
                }
                case DATA_COLLECTION: {
                    prefix = "datacatalog.datacollections.datacollection";
                    break;
                }
                case PROJECT: 
                case FLOW_ZONE: {
                    prefix = null;
                }
            }
            if (prefix == null) continue;
            statePrefixes.put(t, prefix);
        }
        logger = DKULogger.getLogger((String)"dku.tracking");
    }

    public static class ObjectDesc {
        public ITaggingService.TaggableType objectType;
        public String projectKey;
        public String objectId;
        public String workspaceKey;
    }
}

