/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.dataquality;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataquality.DataQualityDailyStatus;
import com.dataiku.dip.dataquality.DataQualityOutcome;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.DataQualityRuleSet;
import com.dataiku.dip.dataquality.DataQualityTemplate;
import com.dataiku.dip.dataquality.DataQualityTemplatesDAO;
import com.dataiku.dip.dataquality.DatasetQuality;
import com.dataiku.dip.dataquality.UIRuleHistory;
import com.dataiku.dip.dataquality.rules.DataQualityBreakdown;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetParams;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.ExternalCheck;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.dataquality.DataQualitySummaryService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataQualityService {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DataQualityTemplatesDAO dataQualityTemplatesDAO;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private DataQualitySummaryService dataQualitySummaryService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.dataquality");

    public static void registerAdapters() {
        DataQualityRule.registerJsonAdapters();
    }

    public Map<String, String> saveConfig(SerializedDataset dataset, List<DataQualityRule> rules, MetricsEngineDesc.MetricsEngineConfig engineConfig, AuthCtx user) throws Exception {
        TransactionContext.assertAttachedRWTransaction();
        HashMap<String, String> result = new HashMap<String, String>();
        DataQualityRuleSet ruleSet = dataset.getDataQualityRuleSet();
        Set existingRuleIdsSet = ruleSet.getRules().stream().map(DataQualityRule::getId).collect(Collectors.toSet());
        for (DataQualityRule rule : rules) {
            if (existingRuleIdsSet.contains(rule.getId())) continue;
            String previousId = rule.getId();
            rule.initializeId();
            result.put(previousId, rule.getId());
        }
        ruleSet.withRules(rules);
        ProbesSet metrics = dataset.getMetrics();
        metrics.engineConfig = engineConfig;
        this.saveDataset(dataset.projectKey, dataset.name, user, dataset);
        return result;
    }

    public Set<String> getPartitionSetToRecompute_NT(List<DataQualityRule> rules, List<DataQualityRule> originalRules, SerializedDataset dataset) throws SQLException {
        Map<String, Boolean> mapNewRulesIdToEnabled = rules.stream().collect(Collectors.toMap(DataQualityRule::getId, r -> r.enabled));
        Set<String> rulesToRecompute = originalRules.stream().filter(r -> !mapNewRulesIdToEnabled.containsKey(r.getId()) || (Boolean)mapNewRulesIdToEnabled.get(r.getId()) != r.enabled).map(DataQualityRule::getId).collect(Collectors.toSet());
        return this.jobsDatabaseService.getDistinctPartitionWhereChecksComputed(dataset.projectKey, dataset.name, rulesToRecompute);
    }

    public DataQualityConfig getConfig(String projectKey, String datasetName) throws Exception {
        TransactionContext.assertAttachedTransaction();
        SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        DataQualityRuleSet ruleSet = dataset.getDataQualityRuleSet();
        return new DataQualityConfig(ruleSet.getRules(), dataset.getMetrics().engineConfig);
    }

    public boolean setMonitoring(SerializedDataset dataset, boolean monitor, AuthCtx user) throws Exception {
        TransactionContext.assertAttachedRWTransaction();
        DataQualityRuleSet ruleSet = dataset.getDataQualityRuleSet();
        if (ruleSet.monitor != monitor) {
            ruleSet.monitor = monitor;
            this.saveDataset(dataset.projectKey, dataset.name, user, dataset);
            return true;
        }
        return false;
    }

    public boolean getMonitoring(String projectKey, String datasetName) throws Exception {
        TransactionContext.assertAttachedTransaction();
        SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        return dataset.getDataQualityRuleSet().monitor;
    }

    public DataQualityDailyStatus getDatasetStatusLast_NT(SerializedDataset dataset) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        return dataset.isPartitioned() ? DataQualityDailyStatus.fromDataPoint(this.jobsDatabaseService.getLastDataQualityObjectStatus(dataset.projectKey, dataset.name)) : DataQualityDailyStatus.fromDataPoint(this.jobsDatabaseService.getLastDataQualityPartitionStatus(dataset.projectKey, dataset.name, "NP"));
    }

    public DataQualityBreakdown getDatasetBreakDownLast_NT(SerializedDataset dataset) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        int enabledRuleCount = (int)dataset.getDataQualityRuleSet().checks.stream().filter(r -> r.enabled).count();
        ReadOnlyJobsInternalDB.DataQualityProjectPoint pt = dataset.isPartitioned() ? this.jobsDatabaseService.getLastDataQualityObjectStatus(dataset.projectKey, dataset.name) : this.jobsDatabaseService.getLastDataQualityPartitionStatus(dataset.projectKey, dataset.name, "NP");
        DataQualityOutcome outcome = pt == null ? DataQualityOutcome.NONE : pt.last;
        return new DataQualityBreakdown(outcome, dataset.isPartitioned() ? DataQualityBreakdown.Scope.PARTITION : DataQualityBreakdown.Scope.RULE, enabledRuleCount - outcome.totalCount());
    }

    public Map<String, AbstractCheckContext.CheckOutcome> getDatasetStatusLastEachPartition_NT(SerializedDataset dataset) throws SQLException {
        List<String> allPartitions = dataset.isPartitioned() ? this.jobsDatabaseService.getAllPartitionsWithChecksForObjectIncludingLegacy(dataset.projectKey, dataset.name) : Collections.singletonList("NP");
        Map<String, ReadOnlyJobsInternalDB.DataQualityPartitionPoint> statuses = this.jobsDatabaseService.getLastDataQualityPartitionStatusesForObject(dataset.projectKey, dataset.name);
        HashMap<String, AbstractCheckContext.CheckOutcome> res = new HashMap<String, AbstractCheckContext.CheckOutcome>();
        for (String partitionId : allPartitions) {
            res.put(partitionId, statuses.containsKey(partitionId) ? statuses.get((Object)partitionId).last.getOutcome() : null);
        }
        return res;
    }

    public Map<AnyLoc, DatasetQuality> getDatasetsStatusLastInProject_NT(String projectKey, boolean withForeignDatasets) throws SQLException, IOException {
        List<SerializedDataset> localDatasets;
        TransactionContext.assertNoAttachedTransaction();
        ArrayList<SerializedDataset> foreignDatasets = new ArrayList<SerializedDataset>();
        try (Transaction t = this.transactionService.beginRead();){
            localDatasets = this.datasetsDAO.listUnsafe(projectKey);
            if (withForeignDatasets) {
                for (DatasetLocUtils.DatasetLoc datasetLoc : this.projectsService.getExposedDatasets(projectKey)) {
                    SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(datasetLoc);
                    foreignDatasets.add(dataset);
                }
            }
        }
        HashMap<AnyLoc, DatasetQuality> result = new HashMap<AnyLoc, DatasetQuality>();
        Map<String, ReadOnlyJobsInternalDB.DataQualityLastObjectPoint> dataPoints = this.jobsDatabaseService.getLastDataQualityObjectStatusesForProject(projectKey);
        Map<String, ReadOnlyJobsInternalDB.DataQualityPartitionPoint> map = this.jobsDatabaseService.getLastDataQualityPartitionStatusesForNPProject(projectKey);
        localDatasets.forEach(sd -> {
            AnyLoc loc = new AnyLoc(projectKey, sd.getId());
            if (sd.isPartitioned()) {
                result.put(loc, DatasetQuality.fromDataPoint((ReadOnlyJobsInternalDB.DataQualityObjectPoint)dataPoints.get(sd.getId())));
            } else {
                result.put(loc, DatasetQuality.fromDataPoint((ReadOnlyJobsInternalDB.DataQualityPartitionPoint)npDataPoints.get(sd.getId())));
            }
        });
        if (withForeignDatasets) {
            List<AnyLoc> foreignDatasetsRefs = foreignDatasets.stream().map(sd -> new AnyLoc(sd.projectKey, sd.name)).collect(Collectors.toList());
            Map<AnyLoc, ReadOnlyJobsInternalDB.DataQualityLastObjectPoint> foreignDataPoints = this.jobsDatabaseService.getLastDataQualityObjectStatusesForList(foreignDatasetsRefs);
            Map<AnyLoc, ReadOnlyJobsInternalDB.DataQualityPartitionPoint> foreignNpDataPoints = this.jobsDatabaseService.getLastDataQualityPartitionStatusesForNPObjectList(foreignDatasetsRefs);
            foreignDatasets.forEach(sd -> {
                AnyLoc loc = new AnyLoc(sd.projectKey, sd.getId());
                if (sd.isPartitioned()) {
                    result.put(loc, DatasetQuality.fromDataPoint((ReadOnlyJobsInternalDB.DataQualityObjectPoint)foreignDataPoints.get(loc)));
                } else {
                    result.put(loc, DatasetQuality.fromDataPoint((ReadOnlyJobsInternalDB.DataQualityPartitionPoint)foreignNpDataPoints.get(loc)));
                }
            });
        }
        return result;
    }

    public List<DataQualityDailyStatus> getDatasetStatusTimeline_NT(SerializedDataset dataset, String partitionId, long startDay, long endDay) throws SQLException {
        ReadOnlyJobsInternalDB.DataQualityPartitionPoint mostRecentDataPoint;
        TransactionContext.assertNoAttachedTransaction();
        List<DataQualityDailyStatus> timeline = this.jobsDatabaseService.getDataQualityPartitionTimeline(dataset.projectKey, dataset.name, partitionId, startDay, endDay).stream().map(DataQualityDailyStatus::new).collect(Collectors.toList());
        if ((timeline.isEmpty() || ((DataQualityDailyStatus)timeline.get((int)0)).computeTime != startDay) && (mostRecentDataPoint = this.jobsDatabaseService.getMostRecentDataQualityPartitionStatus(dataset.projectKey, dataset.name, partitionId, startDay)) != null) {
            timeline.add(0, new DataQualityDailyStatus(mostRecentDataPoint));
        }
        return timeline;
    }

    public DataQualityDailyStatus getProjectStatusLast_NT(String projectKey) throws SQLException {
        TransactionContext.assertNoAttachedTransaction();
        return DataQualityDailyStatus.fromDataPoint(this.jobsDatabaseService.getLastDataQualityProjectStatus(projectKey));
    }

    public DataQualityBreakdown getProjectBreakDownLast_NT(String projectKey) throws SQLException, IOException {
        TransactionContext.assertNoAttachedTransaction();
        ReadOnlyJobsInternalDB.DataQualityProjectPoint pt = this.jobsDatabaseService.getLastDataQualityProjectStatus(projectKey);
        DataQualityOutcome outcome = pt == null ? DataQualityOutcome.NONE : pt.last;
        int count = 0;
        try (Transaction t = this.transactionService.beginRead();){
            for (SerializedDataset sd : this.datasetsDAO.listUnsafe(projectKey)) {
                try {
                    if (!sd.getDataQualityRuleSet().monitor) continue;
                    ++count;
                }
                catch (JsonParseException e) {
                    logger.warn((Object)("Cannot deserialize the rules of " + sd.getFullName()), (Throwable)e);
                }
            }
        }
        return new DataQualityBreakdown(outcome, DataQualityBreakdown.Scope.OBJECT, count - outcome.totalCount());
    }

    public List<DataQualityDailyStatus> getProjectStatusTimeline_NT(String projectKey, long startDay, long endDay) throws SQLException {
        ReadOnlyJobsInternalDB.DataQualityProjectPoint mostRecentDataPoint;
        TransactionContext.assertNoAttachedTransaction();
        List<DataQualityDailyStatus> timeline = this.jobsDatabaseService.getDataQualityProjectTimeline(projectKey, startDay, endDay).stream().map(DataQualityDailyStatus::new).collect(Collectors.toList());
        if ((timeline.isEmpty() || ((DataQualityDailyStatus)timeline.get((int)0)).computeTime != startDay) && (mostRecentDataPoint = this.jobsDatabaseService.getMostRecentDataQualityProjectStatus(projectKey, startDay)) != null) {
            timeline.add(0, new DataQualityDailyStatus(mostRecentDataPoint));
        }
        return timeline;
    }

    public void updateDatasetStatusForPartitionsCascade_NT(SerializedDataset dataset, Collection<String> partitionIds) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        long now = DateTime.now().getMillis();
        this.updateDatasetStatusForPartitionsCascade_NT(dataset, partitionIds, now);
    }

    public void updateDatasetStatusForPartitionsCascade_NT(SerializedDataset dataset, Collection<String> partitionIds, long computeTime) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        for (String partitionId : partitionIds) {
            this.dataQualitySummaryService.updatePartitionStatus_NT(dataset.getProjectKey(), dataset.getDisplayName(), partitionId, computeTime);
        }
        if (!partitionIds.isEmpty()) {
            this.updateObjectStatusCascade_NT(dataset.projectKey, dataset.name, computeTime, dataset.getDisplayName(), dataset.getDataQualityRuleSet().monitor, false);
        }
    }

    public void updateObjectStatusNoCascade_NT(String projectKey, String datasetName, long computeTime, String displayName, boolean monitored, boolean deleted) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        this.dataQualitySummaryService.updateDataQualityObjectStatus_NT(projectKey, datasetName, computeTime, displayName, monitored, deleted);
    }

    public void updateObjectStatusCascade_NT(String projectKey, String datasetName, long computeTime, String displayName, boolean monitored, boolean deleted) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        this.dataQualitySummaryService.updateDataQualityObjectStatus_NT(projectKey, datasetName, computeTime, displayName, monitored, deleted);
        this.dataQualitySummaryService.updateDataQualityProjectStatus_NT(projectKey, computeTime);
    }

    public UIRuleHistory.RuleFetchResult getDatasetRuleHistory_NT(SerializedDataset dataset, UIRuleHistory.PageFilters filters) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        UIRuleHistory.RuleFetchResult result = new UIRuleHistory.RuleFetchResult();
        result.ruleHistory = this.jobsDatabaseService.getChecksWithFilter(dataset.projectKey, dataset.name, filters);
        result.totalRules = this.jobsDatabaseService.countCheckWithFilter(dataset.projectKey, dataset.name, filters);
        return result;
    }

    public boolean hasDatasetRuleHistory_NT(SerializedDataset dataset, @Nullable List<String> partitionList) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        return this.jobsDatabaseService.hasDataInChecksHistory(dataset.projectKey, dataset.name, partitionList);
    }

    public UIRuleHistory.RuleList getAllRulesThatExisted_NT(SerializedDataset dataset, String partitionId) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        UIRuleHistory.RuleList result = new UIRuleHistory.RuleList();
        Map<String, String> allRules = this.jobsDatabaseService.getAllRulesThatEverExisted(dataset.projectKey, dataset.name, partitionId);
        for (DataQualityRule rule : dataset.getDataQualityRuleSet().getRules()) {
            result.existingRules.put(rule.getId(), rule.getDisplayName());
            allRules.remove(rule.getId());
        }
        result.deletedRules.putAll(allRules);
        return result;
    }

    public void deletePartitionHistory(SerializedDataset dataset, String partitionId) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        this.jobsDatabaseService.clearDataQualityForPartition(dataset.projectKey, dataset.name, partitionId);
        this.updateObjectStatusCascade_NT(dataset.projectKey, dataset.name, DateTime.now().getMillis(), dataset.getDisplayName(), dataset.getDataQualityRuleSet().monitor, false);
    }

    private void saveDataset(String projectKey, String datasetName, AuthCtx user, SerializedDataset dataset) throws Exception {
        TransactionContext.assertAttachedRWTransaction();
        this.datasetSaveService.saveWithCustomEvent(projectKey, datasetName, dataset, user, new TaggableObjectChangedEvent(ITaggingService.TaggableType.DATASET, projectKey, datasetName, user, TaggableObjectChangedEvent.ActionType.DATASET_DQ_RULES_EDIT));
    }

    public void saveExternalRulesIfNotExists(SerializedDataset sd, Set<String> externalRuleIds, AuthCtx user) throws Exception {
        TransactionContext.assertAttachedRWTransaction();
        List<DataQualityRule> rules = sd.getDataQualityRuleSet().getRules();
        for (DataQualityRule rule : rules) {
            externalRuleIds.remove(rule.getId());
        }
        List externalRules = externalRuleIds.stream().map(id -> {
            ExternalCheck r = new ExternalCheck((String)id);
            r.withId((String)id);
            return r;
        }).collect(Collectors.toList());
        rules.addAll(externalRules);
        this.saveDataset(sd.projectKey, sd.name, user, sd);
    }

    public Map<String, AbstractCheckContext.CheckOutcome> getLastRunPartitions_NT(String projectKey, String datasetName) throws Exception {
        Set<String> partitions = this.jobsDatabaseService.getLastRunPartitions(projectKey, datasetName);
        return Maps.transformValues(this.jobsDatabaseService.getLastDataQualityPartitionStatusesForList(projectKey, datasetName, partitions), pt -> pt.last.getOutcome());
    }

    public boolean datasetHasDataQualityHistory(DatasetLocUtils.DatasetLoc loc) throws SQLException {
        return this.jobsDatabaseService.getCheckHistoryCount(JobsdbDatasetParams.RetrievalScope.SINGLE_OBJECT, loc) > 0L;
    }

    public boolean datasetHasMetricHistory(DatasetLocUtils.DatasetLoc loc, ReadOnlyJobsInternalDB.ProbeTypeFilter probeTypeFilter) throws SQLException {
        return this.jobsDatabaseService.hasMetricHistory(loc, probeTypeFilter);
    }

    public List<DataQualityTemplate> listDataQualityTemplatesUnsafe() throws IOException {
        return this.dataQualityTemplatesDAO.listUnsafe();
    }

    public DataQualityTemplate getDataQualityTemplateMandatoryUnsafe(String id) throws IOException {
        return this.dataQualityTemplatesDAO.getMandatoryUnsafe(id);
    }

    public DataQualityTemplate createTemplate(String name, String description, List<DataQualityRule> rules) throws IOException {
        TransactionContext.assertAttachedRWTransaction();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"Template name is not specified");
        Preconditions.checkArgument((rules != null ? 1 : 0) != 0, (Object)"No rules specified for template");
        DataQualityTemplate dataQualityTemplate = new DataQualityTemplate(name, description, rules);
        this.dataQualityTemplatesDAO.save(dataQualityTemplate);
        return dataQualityTemplate;
    }

    public Map<String, String> updateTemplate(DataQualityTemplate template) throws IOException {
        TransactionContext.assertAttachedRWTransaction();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)template.getId()), (Object)"Template id is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)template.getName()), (Object)"Template name is not specified");
        Preconditions.checkArgument((template.getRules() != null ? 1 : 0) != 0, (Object)"No rules specified for template");
        HashMap<String, String> result = new HashMap<String, String>();
        DataQualityTemplate originalTemplate = this.dataQualityTemplatesDAO.getMandatory(template.getId());
        Set existingRuleIdsSet = originalTemplate.getRules().stream().map(DataQualityRule::getId).collect(Collectors.toSet());
        for (DataQualityRule rule : template.getRules()) {
            if (existingRuleIdsSet.contains(rule.getId())) continue;
            String previousId = rule.getId();
            rule.initializeId();
            result.put(previousId, rule.getId());
        }
        this.dataQualityTemplatesDAO.save(template);
        return result;
    }

    public void deleteTemplate(String id) throws IOException {
        TransactionContext.assertAttachedRWTransaction();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Template id is not specified");
        Preconditions.checkArgument((this.dataQualityTemplatesDAO.getOrNullUnsafe(id) != null ? 1 : 0) != 0, (Object)"Template doesn't exist");
        this.dataQualityTemplatesDAO.delete(id);
    }

    @UIModel
    public static class DataQualityConfig {
        List<DataQualityRule> rules;
        MetricsEngineDesc.MetricsEngineConfig engineConfig;

        public DataQualityConfig(List<DataQualityRule> rules, MetricsEngineDesc.MetricsEngineConfig engineConfig) {
            this.rules = rules;
            this.engineConfig = engineConfig;
        }
    }
}

