/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.licensing;

import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

public class TrialTokenRequestUtils {
    private static final String DKU1_HMAC_SHA256 = "DKU1-HMAC-SHA256";
    private static final String URL_PATH = "/api/comm/managed/instance/flex-user-token";
    private static final String SERVICE = "licenseserver";
    private static final long MAX_TIME_DRIFT = 30000000L;
    private static Logger logger = Logger.getLogger((String)"dku.saas.trial");

    private static byte[] hmacSHA256(String data, byte[] key) {
        try {
            String algorithm = "HmacSHA256";
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key, algorithm));
            return mac.doFinal(data.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException("internal error", e);
        }
    }

    private static String computeStringToSign(JsonObject payload, long date) {
        return "DKU1-HMAC-SHA256\n" + date + "\n" + JSON.json((Object)payload) + "\nGET /api/comm/managed/instance/flex-user-token";
    }

    private static byte[] computeSigningKey(String token) {
        byte[] kSecret = ("DKU1" + token).getBytes(StandardCharsets.UTF_8);
        byte[] signingKey = TrialTokenRequestUtils.hmacSHA256(SERVICE, kSecret);
        return signingKey;
    }

    private static String sign(String stringToSign, byte[] signingKey) {
        return Hex.encodeHexString((byte[])TrialTokenRequestUtils.hmacSHA256(stringToSign, signingKey));
    }

    public static TrialTokenRequest buildRequest(JsonObject payload, String instanceId) {
        long now = System.currentTimeMillis();
        String stringToSign = TrialTokenRequestUtils.computeStringToSign(payload, now);
        byte[] signingKey = TrialTokenRequestUtils.computeSigningKey(instanceId);
        String signature = TrialTokenRequestUtils.sign(stringToSign, signingKey);
        TrialTokenRequest req = new TrialTokenRequest();
        req.version = DKU1_HMAC_SHA256;
        req.date = now;
        req.payload = payload;
        req.signature = signature;
        return req;
    }

    public static void verifyRequest(TrialTokenRequest request, String expectedInstanceId) {
        long serverNow = System.currentTimeMillis();
        if (Math.abs(serverNow - request.date) > 30000000L) {
            throw new RuntimeException("denied");
        }
        if (!DKU1_HMAC_SHA256.equals(request.version)) {
            throw new RuntimeException("denied");
        }
        String stringToSign = TrialTokenRequestUtils.computeStringToSign(request.payload, request.date);
        logger.info((Object)("String to sign:" + stringToSign));
        byte[] signingKey = TrialTokenRequestUtils.computeSigningKey(expectedInstanceId);
        String signature = TrialTokenRequestUtils.sign(stringToSign, signingKey);
        logger.info((Object)("Signature required:" + signature));
        if (!signature.equals(request.signature)) {
            throw new RuntimeException("denied");
        }
    }

    public static class TrialTokenRequest {
        String version;
        long date;
        public JsonObject payload;
        String signature;
    }
}

