/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.facet;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.shaker.facet.AlphanumFacetWithMap;
import com.dataiku.dip.shaker.facet.CountMap;
import com.dataiku.dip.shaker.facet.FacetUtils;
import com.dataiku.dip.utils.DKUMathsUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class AlphanumFacetBuilderNoHapax {
    /*
     * WARNING - void declaration
     */
    public AlphanumFacetWithMap build(MemTable mt, MemColumn col, int nbFrequent) {
        void var8_14;
        CountMap<String> counts = new CountMap<String>();
        int missing = 0;
        for (MemRow memRow : mt.rows) {
            if (memRow.isDeleted()) continue;
            String string = memRow.get((Column)col, "");
            counts.inc(string);
        }
        ArrayList<FacetUtils.FacetValue> values = new ArrayList<FacetUtils.FacetValue>();
        for (Map.Entry entry : counts) {
            FacetUtils.FacetValue fv = new FacetUtils.FacetValue();
            fv.key = (String)entry.getKey();
            fv.value = entry.getValue().intValue();
            values.add(fv);
            if (!fv.key.isEmpty()) continue;
            missing += fv.value;
        }
        Collections.sort(values, FacetUtils.Sort.COUNT_FAST);
        AlphanumFacetWithMap alphanumFacetWithMap = new AlphanumFacetWithMap();
        boolean bl = false;
        int idx = -1;
        for (FacetUtils.FacetValue fv : values) {
            ++idx;
            var8_14 += fv.value;
            if (fv.value <= 1) continue;
            if (idx < nbFrequent) {
                alphanumFacetWithMap.frequent.add(fv.key);
                alphanumFacetWithMap.frequentIndex.put(fv.key, idx);
                continue;
            }
            alphanumFacetWithMap.infrequent.add(fv.key);
        }
        alphanumFacetWithMap.totalRows = var8_14;
        alphanumFacetWithMap.totalNbValues = counts.size();
        alphanumFacetWithMap.counts = new int[Math.min(counts.size(), nbFrequent)];
        alphanumFacetWithMap.values = new String[Math.min(counts.size(), nbFrequent)];
        alphanumFacetWithMap.percentages = new double[Math.min(counts.size(), nbFrequent)];
        alphanumFacetWithMap.cumPercentages = new double[Math.min(counts.size(), nbFrequent)];
        alphanumFacetWithMap.missing = var8_14 == false ? 0.0 : (double)missing / (double)mt.nrows();
        int i = 0;
        int cur = 0;
        for (FacetUtils.FacetValue fv : values) {
            alphanumFacetWithMap.values[i] = fv.key;
            alphanumFacetWithMap.counts[i] = fv.value;
            alphanumFacetWithMap.percentages[i] = DKUMathsUtils.safeDivide((int)fv.value, (int)var8_14);
            alphanumFacetWithMap.cumPercentages[i] = DKUMathsUtils.safeDivide((int)(cur += fv.value), (int)var8_14);
            if (++i < nbFrequent) continue;
            break;
        }
        return alphanumFacetWithMap;
    }
}

