/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.filtering;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.FilterAndFlagProcessor;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.sql.SqlFilterAndFlagOnNumericalRange;
import com.dataiku.dip.shaker.types.Number;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.util.ParamDesc;
import com.google.common.collect.Sets;
import java.util.Set;

public class FilterAndFlagOnNumericalRange {
    public static final ProcessorMeta<StreamImpl, Parameter> META_FILTER = new FilterAndFlagProcessor.FilterProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "FilterOnNumericalRange";
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.KNOWN_INPUTS, ProcessorCapabilities.KNOWN_OUTPUTS, ProcessorCapabilities.TYPE_FILTERING_ONLY, ProcessorCapabilities.SQL_TRANSLATABLE, ProcessorCapabilities.NATIVE_SPARK_IMPL);
        }

        @Override
        public String getDocPage() {
            return "filter-on-range";
        }

        @Override
        public Category getCategory() {
            return Category.FILTER;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.FILTER, ProcessorTag.MATH});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnNumericalRange.FILTER.HELP", "Filter rows from the dataset that contain numbers within a numerical range. Alternatively, this processor can clear content from matching cells instead of filtering entire rows. \n\nThe boundaries of the numerical range are inclusive. A value is considered out of range if it isn't a valid numerical value. \n\n# Options\n\n**Action**\n\nSelect the action to perform on matching (in range) rows or cells: \n\n* Keep matching rows only\n\n* Remove matching rows\n\n* Clear content of matching cells\n\n* Clear content of non-matching cells\n\n**Column**\n\nApply the matching condition to the following: \n\n* A single column\n\n* An explicit list of columns\n\n* All columns matching a regex pattern\n\n* All columns\n\n<u>*Note*</u>\nWhen applying the match condition to several columns (multiple, pattern, all), select whether the row will be considered as matching if all columns match (ALL) or at least one column matches (OR).\n");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnNumericalRange.FILTER.DESCRIPTION", 1.actionVerb("Filter") + " rows/cells on numerical range")).withParam(new ParamDesc("min", "double").withMandatory(false).withLabel(this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnNumericalRange.DESCRIPTION.IS_BETWEEN", "is between")).withCanBeEmpty(true).withDefaultValue(null)).withParam(new ParamDesc("max", "double").withMandatory(false).withLabel(this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnNumericalRange.DESCRIPTION.AND", "and")).withCanBeEmpty(true).withDefaultValue(null)).withHiddenDescription("number").withFilterAndFlagMode("FILTER");
        }

        @Override
        public Object selfReport(Parameter parameter) {
            return FilterAndFlagProcessor.selfReport(parameter);
        }

        @Override
        public StreamImpl build(Parameter parameter) {
            return new StreamImpl(parameter);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new FilterSQLTranslator((Parameter)parameter);
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.cleansing.FilterAndFlagOnNumericalRangeNS";
        }
    };
    public static final ProcessorMeta<StreamImpl, Parameter> META_FLAG = new FilterAndFlagProcessor.FlagProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "FlagOnNumericalRange";
        }

        @Override
        public String getDocPage() {
            return "flag-on-range";
        }

        @Override
        public Category getCategory() {
            return Category.FILTER;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.FILTER, ProcessorTag.MATH});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnNumericalRange.FLAG.HELP", "This processor flags rows for which the value is within a numerical range.\n\nThe boundaries of the numerical range are inclusive. If the column does not contain a valid numerical value for a row, this row is considered as being out of the range.\n\nThis processor creates a column containing '1' for matching (in-range) rows, nothing else.\n\n# Columns selection\n\nThis processor can check its matching condition on multiple columns:\n\n* A single colum\n* An explicit list of columns\n* All columns matching a given pattern\n* All columns\n\nYou can select whether the row will be considered as matching if:\n\n* All columns are matching\n* Or, at least one column is matching\n\n");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnNumericalRange.FLAG.DESCRIPTION", 2.actionVerb("Flag") + " rows on numerical range")).withParam(new ParamDesc("min", "double").withMandatory(false).withLabel(this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnNumericalRange.DESCRIPTION.IS_BETWEEN", "is between")).withCanBeEmpty(true).withDefaultValue(null)).withParam(new ParamDesc("max", "double").withMandatory(false).withLabel(this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnNumericalRange.DESCRIPTION.AND", "and")).withCanBeEmpty(true).withDefaultValue(null)).withHiddenDescription("number").withFilterAndFlagMode("FLAG");
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.KNOWN_INPUTS, ProcessorCapabilities.KNOWN_OUTPUTS, ProcessorCapabilities.TYPE_FILTERING_ONLY, ProcessorCapabilities.SQL_TRANSLATABLE, ProcessorCapabilities.NATIVE_SPARK_IMPL);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new FilterSQLTranslator((Parameter)parameter);
        }

        @Override
        public Object selfReport(Parameter parameter) {
            return FilterAndFlagProcessor.selfReport(parameter);
        }

        @Override
        public StreamImpl build(Parameter parameter) {
            return new StreamImpl(parameter);
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.cleansing.FilterAndFlagOnNumericalRangeNS";
        }
    };

    static class StreamImpl
    extends FilterAndFlagProcessor
    implements Processor {
        private final Parameter parameter;
        final Number dt = new Number();
        private final double min;
        private final double max;

        public StreamImpl(Parameter parameter) {
            this.parameter = parameter;
            this.min = parameter.min == null ? Double.NEGATIVE_INFINITY : parameter.min;
            this.max = parameter.max == null ? Double.POSITIVE_INFINITY : parameter.max;
        }

        @Override
        public boolean matchCell(Row row, Column column) throws Exception {
            String val = row.get(column);
            if (val == null || val.isEmpty()) {
                return this.parameter.includeEmptyValues;
            }
            double dv = this.dt.doubleValue(val);
            return !Double.isNaN(dv) && this.min <= dv && dv <= this.max;
        }

        @Override
        public FilterAndFlagProcessor.FilterAndFlagParams getParams() {
            return this.parameter;
        }

        public void postProcess() {
        }
    }

    private static class FilterSQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;

        private FilterSQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema input) {
            return new SqlFilterAndFlagOnNumericalRange(input, this.parameter).apply();
        }
    }

    public static class Parameter
    extends FilterAndFlagProcessor.FilterAndFlagParams
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public Double min;
        public Double max;
        public boolean includeEmptyValues;
    }
}

