/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.geo;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.geo.Geocoder;
import com.dataiku.dip.shaker.processors.geo.GeocoderBing;
import com.dataiku.dip.shaker.processors.geo.GeocoderMapQuest;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.text.Labelled;
import com.dataiku.dip.util.ParamDesc;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class GeocoderProcessor
extends SingleInputSingleOutputRowProcessor
implements Processor {
    public static final ProcessorMeta<GeocoderProcessor, Parameter> META = new ProcessorMeta<GeocoderProcessor, Parameter>(){

        @Override
        public String getName() {
            return "Geocoder";
        }

        @Override
        public Category getCategory() {
            return Category.GEOGRAPHIC;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.GEOGRAPHIC, ProcessorTag.ENRICH});
        }

        @Override
        public String getHelp() {
            return "This processor performs forward geocoding. It can use 2 different API : <b>MapQuest</b> and <b>Bing</b>. Please read the terms of use  before using these services. \n \nOnce you are happy with the result, you should export to another dataset so that the processor does not make API call every time you restart the studio. API calls can be expensive, depending on the key you use.\n\n# Output \n* <i>prefix</i>lat : Contains latitude\n* <i>prefix</i>lon : Contains longitude";
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe() {
            return ProcessorDesc.withGenericForm(this.getName(), 1.actionVerb("Geocode")).withMNEColParam("inCol", "Column").withParam(ParamDesc.advancedSelect("api", "API", "", API.class).withDefaultValue(API.MAPQUEST)).withMNESParam("apiKey", "API Key").withMNESParam("prefixOutCol", "Prefix for generated output columns").deprecate().withReplacementDocLink("geographic/geocoding").withReplacementName("geocoding").doNotDisplayInLibrary();
        }

        @Override
        public GeocoderProcessor build(Parameter parameter) throws Exception {
            return new GeocoderProcessor(parameter);
        }
    };
    Parameter params;
    private Column outputLat;
    private Column outputLon;
    private Column outputGranularity;
    private Column cd;
    int bufferSize = 1;
    private LinkedHashSet<String> addressesBatch = new LinkedHashSet();
    private List<Row> rowBuffer = new ArrayList<Row>();
    Geocoder geocoder;
    protected static Logger logger = Logger.getLogger((String)"dku.shaker.geocoder");

    public GeocoderProcessor(Parameter params) {
        this.params = params;
    }

    private void processBuffer() throws Exception {
        if (this.addressesBatch.size() == 0) {
            return;
        }
        List<Geocoder.Coord> results = this.geocoder.callAPI(this.addressesBatch);
        assert (this.addressesBatch.size() == results.size());
        HashMap<String, Geocoder.Coord> indices = new HashMap<String, Geocoder.Coord>();
        int i = 0;
        for (String a : this.addressesBatch) {
            indices.put(a, results.get(i));
            ++i;
        }
        for (Row buffered : this.rowBuffer) {
            String query = buffered.get(this.cd);
            Geocoder.Coord c2 = (Geocoder.Coord)indices.get(query);
            if (c2 != null && c2.found) {
                buffered.put(this.outputLat, c2.lat);
                buffered.put(this.outputLon, c2.lon);
                if (c2.granularity != null) {
                    buffered.put(this.outputGranularity, String.valueOf((Object)c2.granularity));
                }
            }
            this.getProcessorOutput().emitRow(buffered);
            ++i;
        }
        this.rowBuffer.clear();
        this.addressesBatch.clear();
    }

    public void processRow(Row row) throws Exception {
        String query = row.get(this.cd);
        if (query == null || query.equals("")) {
            this.getProcessorOutput().emitRow(row);
            return;
        }
        Geocoder.Coord result = this.geocoder.getCached(query);
        if (result != null) {
            if (result.found) {
                row.put(this.outputLat, result.lat);
                row.put(this.outputLon, result.lon);
                if (result.granularity != null) {
                    row.put(this.outputGranularity, String.valueOf((Object)result.granularity));
                }
            }
            this.getProcessorOutput().emitRow(row);
            return;
        }
        this.addressesBatch.add(query);
        this.rowBuffer.add(row);
        if (this.addressesBatch.size() == this.bufferSize) {
            this.processBuffer();
        }
    }

    public void postProcess() throws Exception {
        this.processBuffer();
        this.getProcessorOutput().lastRowEmitted();
    }

    public void init() throws Exception {
        this.cd = this.getCf().column(this.params.inCol, Processor.ProcessorRole.INPUT_COLUMN);
        this.outputLat = this.getCf().column(this.params.prefixOutCol + "lat", Processor.ProcessorRole.OUTPUT_COLUMN);
        this.outputLon = this.getCf().column(this.params.prefixOutCol + "lon", Processor.ProcessorRole.OUTPUT_COLUMN);
        this.outputGranularity = this.getCf().column(this.params.prefixOutCol + "granularity", Processor.ProcessorRole.OUTPUT_COLUMN);
        if (this.params.api == API.BING) {
            this.geocoder = GeocoderBing.getInstance();
        } else if (this.params.api == API.MAPQUEST) {
            this.geocoder = GeocoderMapQuest.getInstance();
        }
        this.geocoder.setAPIKey(this.params.apiKey);
        this.bufferSize = this.geocoder.getLimit();
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String inCol;
        public String prefixOutCol;
        public API api;
        public String apiKey;

        public void validate() throws IllegalArgumentException {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum API implements Labelled
    {
        BING{

            @Override
            public String getLabel() {
                return "Bing Spatial Data Services";
            }
        }
        ,
        MAPQUEST{

            @Override
            public String getLabel() {
                return "MapQuest Open API";
            }
        };

    }
}

