/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.publicdata;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProcessorWithResourceFiles;
import com.dataiku.dip.SingleCopyAdditionalInputsLoader;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.publicdata.EnrichWithINSEEData;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class EnrichFrenchPostcode
extends EnrichWithINSEEData
implements ProcessorWithResourceFiles {
    public static final Map<EnrichWithINSEEData.SourceDatasetVersion, EnrichWithINSEEData.Col[]> COLUMNS_TO_CATEGORIES_BY_SOURCE_DATASET = Collections.unmodifiableMap(new EnumMap<EnrichWithINSEEData.SourceDatasetVersion, EnrichWithINSEEData.Col[]>(Map.of(EnrichWithINSEEData.SourceDatasetVersion.INSEE_2009_2011, new EnrichWithINSEEData.Col[]{new EnrichWithINSEEData.Col("postal_code", null), new EnrichWithINSEEData.Col("departement", "departement"), new EnrichWithINSEEData.Col("nb_departements", null), new EnrichWithINSEEData.Col("nb_communes", null), new EnrichWithINSEEData.Col("population_2009", "basicDemography"), new EnrichWithINSEEData.Col("menages_2009", "basicDemography"), new EnrichWithINSEEData.Col("naissances_2011", "basicDemography"), new EnrichWithINSEEData.Col("deces_2011", "basicDemography"), new EnrichWithINSEEData.Col("logements_2009", "housing"), new EnrichWithINSEEData.Col("residencesprincipales_2009", "housing"), new EnrichWithINSEEData.Col("residencessec_2009", "housing"), new EnrichWithINSEEData.Col("logvacants_2009", "housing"), new EnrichWithINSEEData.Col("residencesprincipales_proprietaire_2009", "housing"), new EnrichWithINSEEData.Col("ffiscaux_2009", "fiscal"), new EnrichWithINSEEData.Col("ffiscaux_imposables_2009", "fiscal"), new EnrichWithINSEEData.Col("revenufiscalmedianmoyen_2010", "fiscal"), new EnrichWithINSEEData.Col("emploi_2009", "employment"), new EnrichWithINSEEData.Col("population_1564_2009", "basicDemography"), new EnrichWithINSEEData.Col("chomage_1564_2009", "employment"), new EnrichWithINSEEData.Col("actifs_1564_2009", "employment"), new EnrichWithINSEEData.Col("ets_2010", "companies"), new EnrichWithINSEEData.Col("ets_agri_2010", "companies"), new EnrichWithINSEEData.Col("ets_indus_2010", "companies"), new EnrichWithINSEEData.Col("ets_construc_2010", "companies"), new EnrichWithINSEEData.Col("ets_comm_plus_services_2010", "companies"), new EnrichWithINSEEData.Col("ets_comm_2010", "companies"), new EnrichWithINSEEData.Col("ets_admin_2010", "companies"), new EnrichWithINSEEData.Col("ets_service_2010", "companies"), new EnrichWithINSEEData.Col("ets_1_9_2010", "companies"), new EnrichWithINSEEData.Col("ets_10plus_201", "companies")}, EnrichWithINSEEData.SourceDatasetVersion.INSEE_JAN_2024, new EnrichWithINSEEData.Col[]{new EnrichWithINSEEData.Col("postal_code", null), new EnrichWithINSEEData.Col("departement", "departement"), new EnrichWithINSEEData.Col("nb_communes", null), new EnrichWithINSEEData.Col("population", "basicDemography"), new EnrichWithINSEEData.Col("menages", "basicDemography"), new EnrichWithINSEEData.Col("naissances", "basicDemography"), new EnrichWithINSEEData.Col("deces", "basicDemography"), new EnrichWithINSEEData.Col("logements", "housing"), new EnrichWithINSEEData.Col("residencesprincipales", "housing"), new EnrichWithINSEEData.Col("residencessec", "housing"), new EnrichWithINSEEData.Col("logvacants", "housing"), new EnrichWithINSEEData.Col("residencesprincipales_proprietaire", "housing"), new EnrichWithINSEEData.Col("ffiscaux", "fiscal"), new EnrichWithINSEEData.Col("ffiscaux_imposables", "fiscal"), new EnrichWithINSEEData.Col("revenufiscalmedianmoyen", "fiscal"), new EnrichWithINSEEData.Col("emploi", "employment"), new EnrichWithINSEEData.Col("population_1564", "basicDemography"), new EnrichWithINSEEData.Col("chomage_1564", "employment"), new EnrichWithINSEEData.Col("actifs_1564", "employment"), new EnrichWithINSEEData.Col("ets", "companies"), new EnrichWithINSEEData.Col("ets_agri", "companies"), new EnrichWithINSEEData.Col("ets_indus", "companies"), new EnrichWithINSEEData.Col("ets_construc", "companies"), new EnrichWithINSEEData.Col("ets_comm_plus_services", "companies"), new EnrichWithINSEEData.Col("ets_comm", "companies"), new EnrichWithINSEEData.Col("ets_admin", "companies"), new EnrichWithINSEEData.Col("ets_service", "companies"), new EnrichWithINSEEData.Col("ets_1_9", "companies"), new EnrichWithINSEEData.Col("ets_10plus", "companies")})));
    public static final ProcessorMeta<EnrichFrenchPostcode, Parameter> META = new ProcessorMeta<EnrichFrenchPostcode, Parameter>(){

        @Override
        public String getName() {
            return "EnrichFrenchPostcode";
        }

        @Override
        public String getDocPage() {
            return "enrich-french-postcode";
        }

        @Override
        public Category getCategory() {
            return Category.OPENDATA;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.ENRICH});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.EnrichFrenchPostcode.HELP", "This processor takes a column containing a French post code and outputs several columns with demographic data about the cities using this post code.\n\nThe source data from INSEE can be selected from either the 2009-2011 release (`INSEE 2009-2011`) or the January 2024 release (`INSEE Jan 2024`).\n\n# Available data\n* Associated department code\n* Basic demographic data (population, households, births, deaths, ...)\n* Housing data (households, second homes, ...)\n* Fiscal/Revenue data (number of 'foyers fiscaux', average revenue, ...)\n* Employment data (number of jobs, unemployment rate, ...)\n* Companies data (number of companies, breakdown by industry sector, breakdown by size, ...)\n");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.EnrichFrenchPostcode.DESCRIPTION", 1.actionVerb("Enrich") + " from French postcode"), true).withParam(ParamDesc.advancedSelect("sourceDatasetVersion", this.translate(language, "SHAKER.PROCESSOR.EnrichFrenchPostcode.DESCRIPTION.INSEE_SOURCE_VERSION", "INSEE source"), "", EnrichWithINSEEData.SourceDatasetVersion.class).withDefaultValue(EnrichWithINSEEData.SourceDatasetVersion.INSEE_JAN_2024)).withMNEColParam("column", this.translate(language, "SHAKER.PROCESSOR.EnrichFrenchPostcode.DESCRIPTION.COLUMN", "Column containing postcode")).withBoolDefaultTrue("departement", this.translate(language, "SHAKER.PROCESSOR.EnrichFrenchPostcode.DESCRIPTION.DEPARTEMENT", "Extract departement code"), "").withBoolDefaultTrue("basicDemography", this.translate(language, "SHAKER.PROCESSOR.EnrichFrenchPostcode.DESCRIPTION.BASIC_DEMOGRAPHY", "Extract demography data"), "").withBoolDefaultTrue("housing", this.translate(language, "SHAKER.PROCESSOR.EnrichFrenchPostcode.DESCRIPTION.HOUSING", "Extract housing data"), "").withBoolDefaultTrue("fiscal", this.translate(language, "SHAKER.PROCESSOR.EnrichFrenchPostcode.DESCRIPTION.FISCAL", "Extract fiscal/revenue data"), "").withBoolDefaultTrue("employment", this.translate(language, "SHAKER.PROCESSOR.EnrichFrenchPostcode.DESCRIPTION.EMPLOYMENT", "Extract employment data"), "").withBoolDefaultTrue("companies", this.translate(language, "SHAKER.PROCESSOR.EnrichFrenchPostcode.DESCRIPTION.COMPANIES", "Extract companies data"), "").withParam(ParamDesc.string("prefix", this.translate(language, "SHAKER.PROCESSOR.EnrichFrenchPostcode.DESCRIPTION.PREFIX", "Output columns prefix"), "", "postcode"));
        }

        @Override
        public Object selfReport(Parameter param) {
            return JSON.deepCopyExcept((Object)param, (String[])new String[]{"column", "prefix"});
        }

        @Override
        public EnrichFrenchPostcode build(Parameter parameter) {
            return new EnrichFrenchPostcode(parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            Parameter enrichParams = (Parameter)pss.params;
            EnrichWithINSEEData.Col[] columnsToCategories = EnrichFrenchPostcode.getColumnsToCategoriesFromSourceDataset(enrichParams.sourceDatasetVersion);
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                List<String> computeExtractedColumns = EnrichWithINSEEData.computeExtractedColumnNames(columnsToCategories, CATEGORIES, enrichParams, enrichParams.prefix);
                computeExtractedColumns.forEach(outColumn -> updatedDatasetPairLineage.addFactorizedColumnRelations(enrichParams.column, (String)outColumn));
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private final Parameter params;
    private Column inCol;
    private static final String[] CATEGORIES = new String[]{"departement", "basicDemography", "housing", "fiscal", "employment", "companies"};
    protected File dataFile;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.publicdata");

    private static EnrichWithINSEEData.Col[] getColumnsToCategoriesFromSourceDataset(EnrichWithINSEEData.SourceDatasetVersion sourceDatasetVersion) {
        EnrichWithINSEEData.Col[] columnsToCategory = COLUMNS_TO_CATEGORIES_BY_SOURCE_DATASET.get(sourceDatasetVersion);
        if (columnsToCategory == null) {
            logger.infoV("No columns to categories mapping for the given source dataset version: %s", new Object[]{sourceDatasetVersion});
            columnsToCategory = COLUMNS_TO_CATEGORIES_BY_SOURCE_DATASET.get(EnrichWithINSEEData.SourceDatasetVersion.INSEE_2009_2011);
        }
        return columnsToCategory;
    }

    public EnrichFrenchPostcode(Parameter params) {
        if (params.sourceDatasetVersion == null) {
            logger.info((Object)"No source dataset version parameter was set. Setting to default INSEE 2009-2011");
            params.sourceDatasetVersion = EnrichWithINSEEData.SourceDatasetVersion.INSEE_2009_2011;
        }
        this.params = params;
    }

    public void init() throws Exception {
        this.inCol = this.getColumnFactory().column(this.params.column, Processor.ProcessorRole.INPUT_COLUMN);
        logger.infoV("Selecting source dataset: %s", new Object[]{this.params.sourceDatasetVersion});
        EnrichWithINSEEData.Col[] columnsToCategories = EnrichFrenchPostcode.getColumnsToCategoriesFromSourceDataset(this.params.sourceDatasetVersion);
        this.loadExtractedCols(columnsToCategories, CATEGORIES, this.params, this.params.column, this.params.prefix);
    }

    public void processRow(Row row) {
        String postCode = row.get(this.inCol);
        if (postCode == null) {
            return;
        }
        try {
            int iPostCode = Integer.parseInt(postCode);
            String fPostCode = String.format("%05d", iPostCode);
            String[] data = (String[])this.dataMap.get(fPostCode);
            if (data == null) {
                return;
            }
            for (EnrichWithINSEEData.Col eCol : this.extractedCols) {
                String x = data[eCol.origIdx];
                if (StringUtils.isBlank((String)x)) continue;
                row.put(eCol.col, x);
            }
        }
        catch (Exception e) {
            logger.info((Object)"Postcode enrichment failure", (Throwable)e);
        }
    }

    public void postProcess() throws Exception {
    }

    @Override
    public SingleCopyAdditionalInputsLoader buildLoader() {
        logger.infoV("Loading file %s for %s", new Object[]{this.dataFile.getName(), this.params.sourceDatasetVersion.getLabel()});
        return new EnrichWithINSEEData.DataLoader(this.dataFile);
    }

    @Override
    public Map<String, File> gatherRequirements() {
        HashMap<String, File> requirements = new HashMap<String, File>();
        logger.infoV("Setting required dataset file for %s", new Object[]{this.params.sourceDatasetVersion.getLabel()});
        requirements.put("dku.insee.postcode", new File(DKUApp.getInstallFolder(), String.format("resources/publicdata/insee/%s", switch (this.params.sourceDatasetVersion) {
            case EnrichWithINSEEData.SourceDatasetVersion.INSEE_JAN_2024 -> "insee_2024-01_by_postal_code.csv";
            default -> "insee_resume_postcode_201312.csv";
        })));
        return requirements;
    }

    @Override
    public void setRequiredFiles(Map<String, File> requiredFiles) {
        this.dataFile = requiredFiles.get("dku.insee.postcode");
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String column;
        public EnrichWithINSEEData.SourceDatasetVersion sourceDatasetVersion;
        public boolean departement = true;
        public boolean basicDemography;
        public boolean housing;
        public boolean fiscal;
        public boolean employment;
        public boolean companies;
        public String prefix;

        public void validate() throws IllegalArgumentException {
        }
    }
}

