/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.time;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.time.TimezonableProcessor;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.types.AnyTemporal;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class DateComponentsExtractor {
    public static final ProcessorMeta<StreamImpl, Parameter> META = new ProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "DateComponentsExtractor";
        }

        @Override
        public String getDocPage() {
            return "date-components-extract";
        }

        @Override
        public Category getCategory() {
            return Category.DATE;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.DATE});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.DateComponentsExtractor.HELP", "Extract various elements of a ISO-8601 formatted date (``yyyy-MM-ddTHH:mm:ss.SSSZ``) to other columns.\n\n# Options\n**Date column**\nColumn containing data in ISO-8601 format. Use a Prepare step to parse your data into this format if it isn\u2019t already. \n**Timezone**\nChange the timezone from the UTC default. Options include using a TZ column, an IP column, or specifying a timezone from the dropdown.\n**Date elements**\nTo extract a given date element into a column, give the corresponding column a name. Each output column is optional; if left empty, the processor will not extract the date element.\nNote : Year, month (1-12), day, day of week (1-7, 1=Monday, 7=Sunday), hour, minutes, seconds, milliseconds, week of year (1-53), timestamp (UNIX timestamp in seconds since Epoch) can all be extracted as separate outputs.\n# Related resources\nFor more information on managing dates with Dataiku DSS, please see the [reference documentation](https://doc.dataiku.com/dss/latest/preparation/dates.html)");
        }

        @Override
        public ProcessorDesc describe(String language) {
            ProcessorDesc desc = new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.DateComponentsExtractor.DESCRIPTION", 1.actionVerb("Extract") + " date elements"), false).withMNEColParam("column", this.translate(language, "SHAKER.PROCESSOR.DateComponentsExtractor.DESCRIPTION.COLUMN", "Date column"));
            TimezonableProcessor.appendTimezoneParams(language, desc);
            desc.withParam("outYearColumn", "generic", false, true, this.translate(language, "SHAKER.PROCESSOR.DateComponentsExtractor.DESCRIPTION.OUT_YEAR_COLUMN", "'Year' column")).withParam("outMonthColumn", "generic", false, true, this.translate(language, "SHAKER.PROCESSOR.DateComponentsExtractor.DESCRIPTION.OUT_MONTH_COLUMN", "'Month' column")).withParam("outDayColumn", "generic", false, true, this.translate(language, "SHAKER.PROCESSOR.DateComponentsExtractor.DESCRIPTION.OUT_DAY_COLUMN", "'Day' column")).withParam("outDayOfWeekColumn", "generic", false, true, this.translate(language, "SHAKER.PROCESSOR.DateComponentsExtractor.DESCRIPTION.OUT_DAY_OF_WEEK_COLUMN", "'Day of week' column")).withParam("outHourColumn", "generic", false, true, this.translate(language, "SHAKER.PROCESSOR.DateComponentsExtractor.DESCRIPTION.OUT_HOUR_COLUMN", "'Hour' column")).withParam("outMinuteColumn", "generic", false, true, this.translate(language, "SHAKER.PROCESSOR.DateComponentsExtractor.DESCRIPTION.OUT_MINUTE_COLUMN", "'Minutes' column")).withParam("outSecondColumn", "generic", false, true, this.translate(language, "SHAKER.PROCESSOR.DateComponentsExtractor.DESCRIPTION.OUT_SECOND_COLUMN", "'Seconds' column")).withParam("outMSColumn", "generic", false, true, this.translate(language, "SHAKER.PROCESSOR.DateComponentsExtractor.DESCRIPTION.OUT_MSCOLUMN", "'Milliseconds' column")).withParam("outWeekOfYearColumn", "generic", false, true, this.translate(language, "SHAKER.PROCESSOR.DateComponentsExtractor.DESCRIPTION.OUT_WEEK_OF_YEAR_COLUMN", "'Week of Year' column")).withParam("outTimestampColumn", "generic", false, true, this.translate(language, "SHAKER.PROCESSOR.DateComponentsExtractor.DESCRIPTION.OUT_TIMESTAMP_COLUMN", "'UNIX Timestamp' column")).withParam("outWeekYearColumn", "generic", false, true, this.translate(language, "SHAKER.PROCESSOR.DateComponentsExtractor.DESCRIPTION.OUT_WEEK_YEAR_COLUMN", "'Week year' column"));
            return desc;
        }

        @Override
        public StreamImpl build(Parameter parameter) {
            return new StreamImpl(parameter);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            Parameter p = (Parameter)params;
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            if (!Sets.newHashSet((Object[])new String[]{"extract_from_ip"}).contains(p.timezone_id)) {
                ret.withCan(ProcessorCapabilities.NATIVE_SPARK_IMPL);
            } else {
                ret.withCould(ProcessorCapabilities.NATIVE_SPARK_IMPL, "Cannot use optimized engine: cannot translate dynamic timezone shift from IP");
            }
            if (Sets.newHashSet((Object[])new String[]{"extract_from_column", "extract_from_ip"}).contains(p.timezone_id)) {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot translate dynamic timezone shift in SQL");
            } else if (StringUtils.isNotBlank((String)p.outMSColumn) && !dialect.canExtractMilliseconds()) {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot extract milliseconds in this SQL dialect");
            } else if (StringUtils.isNotBlank((String)p.outWeekYearColumn)) {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot extract ISO year in SQL");
            } else {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
            }
            return ret;
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.time.DateComponentsExtractorNS";
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter dateExtractorParam = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                Stream.of(dateExtractorParam.outYearColumn, dateExtractorParam.outMonthColumn, dateExtractorParam.outDayColumn, dateExtractorParam.outDayOfWeekColumn, dateExtractorParam.outHourColumn, dateExtractorParam.outMinuteColumn, dateExtractorParam.outSecondColumn, dateExtractorParam.outMSColumn, dateExtractorParam.outWeekOfYearColumn, dateExtractorParam.outTimestampColumn, dateExtractorParam.outWeekYearColumn).filter(StringUtils::isNotBlank).forEach(column -> updatedDatasetPairLineage.addFactorizedColumnRelations(dateExtractorParam.column, (String)column));
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };

    public static class StreamImpl
    extends TimezonableProcessor {
        AnyTemporal temporalMeaning = new AnyTemporal();
        private Parameter params;
        private Column cd;
        private Column outYearCD;
        private Column outMonthCD;
        private Column outDayCD;
        private Column outDayOfWeekCD;
        private Column outHourCD;
        private Column outMinuteCD;
        private Column outSecondCD;
        private Column outMSCD;
        private Column outWeekOfYearCD;
        private Column outTimestampCD;
        private Column outWeekYearCD;

        public StreamImpl(Parameter params) {
            this.params = params;
        }

        public void init() throws Exception {
            if (this.params.column == null) {
                throw new Exception("Missing input column");
            }
            this.cd = this.getColumnFactory().column(this.params.column, Processor.ProcessorRole.INPUT_COLUMN);
            if (!StringUtils.isBlank((String)this.params.outMSColumn)) {
                this.outMSCD = this.getColumnFactory().columnAfter(this.params.column, this.params.outMSColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (!StringUtils.isBlank((String)this.params.outSecondColumn)) {
                this.outSecondCD = this.getColumnFactory().columnAfter(this.params.column, this.params.outSecondColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (!StringUtils.isBlank((String)this.params.outMinuteColumn)) {
                this.outMinuteCD = this.getColumnFactory().columnAfter(this.params.column, this.params.outMinuteColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (!StringUtils.isBlank((String)this.params.outHourColumn)) {
                this.outHourCD = this.getColumnFactory().columnAfter(this.params.column, this.params.outHourColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (!StringUtils.isBlank((String)this.params.outDayOfWeekColumn)) {
                this.outDayOfWeekCD = this.getColumnFactory().columnAfter(this.params.column, this.params.outDayOfWeekColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (!StringUtils.isBlank((String)this.params.outDayColumn)) {
                this.outDayCD = this.getColumnFactory().columnAfter(this.params.column, this.params.outDayColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (!StringUtils.isBlank((String)this.params.outWeekYearColumn)) {
                this.outWeekYearCD = this.getColumnFactory().columnAfter(this.params.column, this.params.outWeekYearColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (!StringUtils.isBlank((String)this.params.outWeekOfYearColumn)) {
                this.outWeekOfYearCD = this.getColumnFactory().columnAfter(this.params.column, this.params.outWeekOfYearColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (!StringUtils.isBlank((String)this.params.outMonthColumn)) {
                this.outMonthCD = this.getColumnFactory().columnAfter(this.params.column, this.params.outMonthColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (!StringUtils.isBlank((String)this.params.outYearColumn)) {
                this.outYearCD = this.getColumnFactory().columnAfter(this.params.column, this.params.outYearColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (!StringUtils.isBlank((String)this.params.outTimestampColumn)) {
                this.outTimestampCD = this.getColumnFactory().columnAfter(this.params.column, this.params.outTimestampColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            this.initTimezonableWithParams(this.params.timezone_id, this.params.timezone_src);
        }

        public void processRow(Row row) throws Exception {
            String val = row.get(this.cd);
            long lv = this.temporalMeaning.longValue(val);
            if (lv == Long.MAX_VALUE) {
                return;
            }
            DateTimeZone tz = this.getTimezone(row);
            if (tz == null) {
                return;
            }
            Date date = new Date(lv);
            GregorianCalendar outCal = new GregorianCalendar(tz.toTimeZone());
            outCal.setFirstDayOfWeek(2);
            outCal.setMinimalDaysInFirstWeek(4);
            outCal.setTime(date);
            if (this.outYearCD != null) {
                row.put(this.outYearCD, outCal.get(1));
            }
            if (this.outMonthCD != null) {
                row.put(this.outMonthCD, outCal.get(2) + 1);
            }
            if (this.outDayCD != null) {
                row.put(this.outDayCD, outCal.get(5));
            }
            if (this.outDayOfWeekCD != null) {
                int dow = outCal.get(7);
                dow = (dow + 5) % 7 + 1;
                row.put(this.outDayOfWeekCD, dow);
            }
            if (this.outHourCD != null) {
                row.put(this.outHourCD, outCal.get(11));
            }
            if (this.outMinuteCD != null) {
                row.put(this.outMinuteCD, outCal.get(12));
            }
            if (this.outSecondCD != null) {
                row.put(this.outSecondCD, outCal.get(13));
            }
            if (this.outMSCD != null) {
                row.put(this.outMSCD, date.getTime() % 1000L);
            }
            if (this.outWeekOfYearCD != null) {
                row.put(this.outWeekOfYearCD, outCal.get(3));
            }
            if (this.outTimestampCD != null) {
                row.put(this.outTimestampCD, outCal.getTimeInMillis() / 1000L);
            }
            if (this.outWeekYearCD != null) {
                row.put(this.outWeekYearCD, ((Calendar)outCal).getWeekYear());
            }
        }

        public void postProcess() throws Exception {
        }
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String column;
        public String outYearColumn;
        public String outMonthColumn;
        public String outDayColumn;
        public String outDayOfWeekColumn;
        public String outHourColumn;
        public String outMinuteColumn;
        public String outSecondColumn;
        public String outMSColumn;
        public String outWeekYearColumn;
        public String outWeekOfYearColumn;
        public String outTimestampColumn;
        public String timezone_id;
        public String timezone_src;

        public void validate() throws IllegalArgumentException {
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;

        private SQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(ProcessorSQLTranslator.ProcessorSQLTranslateParams translateParams) {
            SQLQueryWithSchema input = translateParams.input;
            ArrayList affectedColumns = Lists.newArrayList((Object[])new String[]{this.parameter.column});
            boolean needsSubquery = input.isAnyCreatedOrModifiedByCurrentQuery(affectedColumns);
            for (String c2 : new String[]{this.parameter.outDayColumn, this.parameter.outDayOfWeekColumn, this.parameter.outHourColumn, this.parameter.outMinuteColumn, this.parameter.outMonthColumn, this.parameter.outMSColumn, this.parameter.outSecondColumn, this.parameter.outTimestampColumn, this.parameter.outWeekOfYearColumn, this.parameter.outWeekYearColumn, this.parameter.outYearColumn}) {
                if (!StringUtils.isNotBlank((String)c2)) continue;
                needsSubquery |= input.isCreatedOrModifiedByCurrentQuery(c2);
                affectedColumns.add(c2);
            }
            if (needsSubquery) {
                input = input.makeSubquery();
            }
            SchemaColumn currentColumn = input.getMandatoryCurrentColumn(this.parameter.column);
            ExpressionBuilder dt = input.col(currentColumn, translateParams.typeSystemVersion, translateParams.isDatasetManaged);
            Type actualType = currentColumn.getType();
            if (!currentColumn.getType().isTemporal()) {
                dt = dt.castToDate();
                actualType = Type.DATE;
            }
            dt.expr.outputType.dssType = actualType;
            if (actualType.isTimestamp() && StringUtils.isNotBlank((String)this.parameter.timezone_id) && DateTimeZone.forID((String)this.parameter.timezone_id) != DateTimeZone.UTC) {
                dt = dt.convertFromTz(this.parameter.timezone_id, "UTC");
            }
            if (StringUtils.isNotBlank((String)this.parameter.outYearColumn)) {
                this.addColumnForDatePart(input, currentColumn, actualType, dt, DatePart.YEAR, this.parameter.outYearColumn);
            }
            if (StringUtils.isNotBlank((String)this.parameter.outMonthColumn)) {
                this.addColumnForDatePart(input, currentColumn, actualType, dt, DatePart.MONTH_OF_YEAR, this.parameter.outMonthColumn);
            }
            if (StringUtils.isNotBlank((String)this.parameter.outDayColumn)) {
                this.addColumnForDatePart(input, currentColumn, actualType, dt, DatePart.DAY_OF_MONTH, this.parameter.outDayColumn);
            }
            if (StringUtils.isNotBlank((String)this.parameter.outDayOfWeekColumn)) {
                this.addColumnForDatePart(input, currentColumn, actualType, dt, DatePart.DAY_OF_WEEK, this.parameter.outDayOfWeekColumn);
            }
            if (StringUtils.isNotBlank((String)this.parameter.outHourColumn)) {
                this.addColumnForDatePart(input, currentColumn, actualType, dt, DatePart.HOUR_OF_DAY, this.parameter.outHourColumn);
            }
            if (StringUtils.isNotBlank((String)this.parameter.outMinuteColumn)) {
                this.addColumnForDatePart(input, currentColumn, actualType, dt, DatePart.MINUTE_OF_HOUR, this.parameter.outMinuteColumn);
            }
            if (StringUtils.isNotBlank((String)this.parameter.outSecondColumn)) {
                this.addColumnForDatePart(input, currentColumn, actualType, dt, DatePart.SECOND_OF_MINUTE, this.parameter.outSecondColumn);
            }
            if (StringUtils.isNotBlank((String)this.parameter.outMSColumn)) {
                this.addColumnForDatePart(input, currentColumn, actualType, dt, DatePart.MILLISECOND_OF_SECOND, this.parameter.outMSColumn);
            }
            if (StringUtils.isNotBlank((String)this.parameter.outWeekOfYearColumn)) {
                this.addColumnForDatePart(input, currentColumn, actualType, dt, DatePart.WEEK_OF_YEAR, this.parameter.outWeekOfYearColumn);
            }
            if (StringUtils.isNotBlank((String)this.parameter.outTimestampColumn)) {
                this.addColumnForDatePart(input, currentColumn, actualType, dt, DatePart.SECOND_FROM_EPOCH, this.parameter.outTimestampColumn);
            }
            return input;
        }

        private void addColumnForDatePart(SQLQueryWithSchema input, SchemaColumn currentColumn, Type actualType, ExpressionBuilder dt, DatePart part, String outColumn) {
            ExpressionBuilder extracted = actualType == Type.DATEONLY ? dt.dateonlyPart(part.name()) : (actualType == Type.DATETIMENOTZ ? dt.datetimenotzPart(part.name()) : dt.datePart(part.name()));
            input.addAfterOrReplaceColumn(currentColumn, extracted.castToBigint(), Type.BIGINT, outColumn, false);
        }
    }
}

