/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.typespecific;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Sets;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.json.JsonSmartJsonProvider;
import com.jayway.jsonpath.spi.mapper.JsonSmartMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONStyle;
import org.apache.log4j.Logger;

public class JSONPathExtractor
extends SingleRowProcessor
implements Processor {
    public static final ProcessorMeta<JSONPathExtractor, Parameter> META = new ProcessorMeta<JSONPathExtractor, Parameter>(){

        @Override
        public String getName() {
            return "JSONPathExtractor";
        }

        @Override
        public String getDocPage() {
            return "jsonpath";
        }

        @Override
        public Category getCategory() {
            return Category.WEB;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.SPLIT, ProcessorTag.COMPLEX});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.JSONPathExtractor.HELP", "Extract data from a column containing JSON using the JSONPath syntax, and create a new column containing the extracted data.\n\n# Example\n\nJSON object from input column: `{\"person\":\"John\",\"age\":24}`\nJSONPath expression: `$.age`\nExtracted data: `24`\n\n# Options\n\n**Input column**\nColumn containing the JSON to extract.\n\n**Output column**\nCreate a new column for output.\n**JSONPath expression**\nExpression following the syntax in the [JSONPath documentation](http://goessner.net/articles/JsonPath/).\n**Single value**\nCheck if the path represents a single value and not an array.\n");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.JSONPathExtractor.DESCRIPTION", 1.actionVerb("Extract") + " with JSONPath")).withMNEColParam("inCol", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.INPUT_COLUMN", "Input column")).withMNEColParam("outCol", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.OUTPUT_COLUMN", "Output column")).withMNESParam("expression", this.translate(language, "SHAKER.PROCESSOR.JSONPathExtractor.DESCRIPTION.EXPRESSION", "JSONPath expression")).withParam(ParamDesc.booleanP("singleValue", this.translate(language, "SHAKER.PROCESSOR.JSONPathExtractor.DESCRIPTION.SINGLE_VALUE", "Single value"), this.translate(language, "SHAKER.PROCESSOR.JSONPathExtractor.DESCRIPTION.SINGLE_VALUE.TOOLTIP", "Path represents a single value (and not an array)"), true));
        }

        @Override
        public Object selfReport(Parameter p) {
            return JSON.deepCopyExcept((Object)p, (String[])new String[]{"inCol", "outCol", "expression"});
        }

        @Override
        public JSONPathExtractor build(Parameter parameter) throws Exception {
            return new JSONPathExtractor(parameter.inCol, parameter.outCol, parameter.expression, parameter.singleValue);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter jsonPathParam = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                updatedDatasetPairLineage.addFactorizedColumnRelations(jsonPathParam.inCol, jsonPathParam.outCol);
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private String inColumn;
    private String outColumn;
    private String expression;
    private Column inCD;
    private Column outCD;
    private JsonPath compiled;
    private ParseContext context;
    private boolean singleValue;
    private static Logger logger = Logger.getLogger((String)"dku.processors.json");

    public JSONPathExtractor(String inColumn, String outColumn, String expression, boolean singleValue) {
        this.inColumn = inColumn;
        this.outColumn = outColumn;
        this.expression = expression;
        this.singleValue = singleValue;
    }

    public void init() {
        this.inCD = this.getColumnFactory().column(this.inColumn, Processor.ProcessorRole.INPUT_COLUMN);
        this.outCD = this.getColumnFactory().columnAfter(this.inColumn, this.outColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
        this.compiled = JsonPath.compile((String)this.expression, (Predicate[])new Predicate[0]);
        this.context = JsonPath.using((Configuration)Configuration.builder().mappingProvider((MappingProvider)new JsonSmartMappingProvider()).jsonProvider((JsonProvider)new JsonSmartJsonProvider()).build());
    }

    public void processRow(Row row) throws Exception {
        String v = row.get(this.inCD);
        if (v == null) {
            return;
        }
        try {
            Object out = this.context.parse(v).read(this.compiled);
            if (out == null) {
                return;
            }
            if (this.singleValue) {
                if (out instanceof JSONObject || out instanceof Map) {
                    return;
                }
                if (out instanceof JSONArray) {
                    JSONArray list = (JSONArray)out;
                    if (list.size() > 0) {
                        row.put(this.outCD, JSONPathExtractor.printJSONValue(list.get(0)));
                    }
                    return;
                }
                if (out instanceof List) {
                    List list = (List)out;
                    if (list.size() > 0) {
                        row.put(this.outCD, JSONPathExtractor.printJSONValue(list.get(0)));
                    }
                    return;
                }
            }
            row.put(this.outCD, JSONPathExtractor.printJSONValue(out));
        }
        catch (PathNotFoundException out) {
        }
        catch (Exception e) {
            logger.info((Object)"Matching failed", (Throwable)e);
        }
    }

    public static String printJSONValue(Object out) {
        String value = out instanceof Map ? JSONObject.toJSONString((Map)((Map)out), (JSONStyle)JSONStyle.LT_COMPRESS) : (out instanceof List ? JSONArray.toJSONString((List)((List)out), (JSONStyle)JSONStyle.LT_COMPRESS) : out.toString());
        return value;
    }

    public void postProcess() {
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String inCol;
        public String outCol;
        String expression;
        boolean singleValue;

        public void validate() throws IllegalArgumentException {
        }
    }
}

