/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.udf;

import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.udf.CustomJythonStepParams;
import com.dataiku.dip.shaker.processors.udf.CustomJythonStepProcessor;
import com.dataiku.dip.shaker.processors.udf.LoadedJythonProcessor;
import com.dataiku.dip.shaker.processors.udf.MetaWithRemoteCodeEnv;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CustomJythonProcessorMeta
extends ProcessorMeta<CustomJythonStepProcessor, CustomJythonStepParams>
implements MetaWithRemoteCodeEnv,
IPluginifiedMeta {
    private final LoadedJythonProcessor loaded;

    public CustomJythonProcessorMeta(LoadedJythonProcessor loaded) {
        this.loaded = loaded;
        this.plugin = loaded.ownerPluginId;
    }

    @Override
    public String getName() {
        return this.loaded.getType();
    }

    @Override
    public Category getCategory() {
        return Category.MISC;
    }

    @Override
    public Set<ProcessorTag> getTags() {
        if (this.loaded.desc.processorTags != null && !this.loaded.desc.processorTags.isEmpty()) {
            HashSet tags = Sets.newHashSet();
            for (String tag : this.loaded.desc.processorTags) {
                tags.add(ProcessorTag.valueOf(tag));
            }
            return tags;
        }
        return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.CUSTOM, ProcessorTag.MISC});
    }

    @Override
    public Class<CustomJythonStepParams> stepParamClass() {
        return CustomJythonStepParams.class;
    }

    @Override
    public ProcessorDesc describe(String language) {
        ProcessorDesc desc = ProcessorDesc.withCustomForm(this.getName(), this.loaded.desc.meta.label);
        desc.withToolTip(this.loaded.desc.meta.description);
        return desc;
    }

    @Override
    public CustomJythonStepProcessor build(CustomJythonStepParams params) throws Exception {
        return new CustomJythonStepProcessor(this, this.loaded, params, this.loaded.desc.mode.build(this.loaded, params));
    }

    @Override
    public StepParams expandParams(StepParams params, VariablesContext vc) {
        CustomJythonStepParams pythonParams = (CustomJythonStepParams)params;
        Map variables = vc.getAllVariables();
        pythonParams.variablesDefinition.putAll(variables);
        return pythonParams;
    }

    @Override
    public IElementLoadedDesc getLoadedDesc() {
        return this.loaded;
    }
}

