/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server.controllers;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.ETaggedResponseBody;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.server.ProcessorLibraryDesc;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.Params;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ShakerStaticDataController
extends DIPInternalControllerBase {
    @Autowired
    TranslationService staticTranslationService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    UIAuthService authService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/shaker/get-processors-library"})
    @ETaggedResponseBody
    public ProcessorLibraryDesc getProcessorsLibrary(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String lang) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        Params p = DKUApp.getParams();
        return BaseProcessorsFactory.getStandardLibrary(p, lang);
    }
}

