/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.services.smartdate;

import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.shaker.DateTimeFormatterFix;
import com.dataiku.dip.shaker.processors.time.Language;
import com.dataiku.dip.shaker.services.smartdate.DateFormatGuesser;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.MutableDateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadWritableInstant;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class SmartDateService {
    private static Logger logger = Logger.getLogger((String)"dku.shaker.dates");

    public GuessFormat validate(MemTable mt, String column, String format, int trust) throws InvalidFormatException {
        MemColumn c2 = mt.column(column);
        GuessFormat gf = new GuessFormat();
        gf.trust = trust;
        gf.format = format;
        gf.nbOK = 0;
        HashSet<Language> languages = new HashSet<Language>();
        DateTimeFormatterFix sdf = null;
        if (gf.format.length() > 0) {
            try {
                sdf = DateTimeFormatterFix.forPattern(gf.format).withLocale(Locale.US).withZone(DateTimeZone.UTC);
                gf.validFormat = true;
            }
            catch (IllegalArgumentException e) {
                gf.validFormat = false;
                gf.invalidFormatMessage = e.getMessage();
            }
        } else {
            gf.validFormat = false;
            gf.invalidFormatMessage = "Empty format";
        }
        DateTime cal = new DateTime(2013, 4, 28, 17, 12, 13);
        if (sdf != null) {
            gf.example = sdf.print((ReadableInstant)cal);
        }
        DateTimeFormatter rfc822 = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss Z").withLocale(Locale.US);
        for (MemRow mr : mt.rows) {
            String v;
            if (mr.isDeleted() || (v = mr.get(c2)) == null || v.length() == 0) continue;
            if (sdf == null) {
                ++gf.nbNOK;
                continue;
            }
            try {
                v = DateFormatGuesser.translateEnglishMonthAndDay(v);
                MutableDateTime d = new MutableDateTime(0L, DateTimeZone.UTC);
                if (sdf.parseInto((ReadWritableInstant)d, v, 0) >= 0) {
                    ++gf.nbOK;
                    languages.add(Language.en_US);
                    continue;
                }
                d = new MutableDateTime(0L, DateTimeZone.UTC);
                if (sdf.parseInto((ReadWritableInstant)d, v = DateFormatGuesser.translateFrenchMonthAndDay(v), 0) >= 0) {
                    ++gf.nbOK;
                    languages.add(Language.fr_FR);
                    continue;
                }
                ++gf.nbNOK;
            }
            catch (Exception e) {
                ++gf.nbNOK;
            }
        }
        logger.debug((Object)("At end of pass1 ok=" + gf.nbOK + " nok=" + gf.nbNOK + " lang=" + String.valueOf(languages) + " sdf=" + String.valueOf(sdf)));
        gf.language = languages.size() == 1 ? (Language)languages.iterator().next() : Language.auto;
        int badExamples = gf.nbNOK < 4 ? gf.nbNOK : 4;
        int goodExamples = gf.nbOK < 6 ? gf.nbOK : 6;
        Random r = new Random();
        int seenGood = 0;
        int seenBad = 0;
        int keptGood = 0;
        int keptBad = 0;
        int foundPartial = 0;
        int foundNOK = 0;
        for (MemRow mr : mt.rows) {
            String v;
            if (mr.isDeleted() || (v = mr.get(c2)) == null || v.length() == 0) continue;
            if (sdf == null) {
                if (keptBad < badExamples && r.nextInt(gf.nbNOK + 1) <= badExamples || keptBad + (gf.nbNOK - seenBad) <= badExamples) {
                    gf.exampleIN.add(v);
                    gf.exampleStatus.add(-1);
                    gf.exampleClean.add(null);
                    gf.exampleTS.add(null);
                    ++keptBad;
                }
                ++seenBad;
                continue;
            }
            try {
                int pr = 0;
                String tv = DateFormatGuesser.translateMonthAndDay(v);
                MutableDateTime d = new MutableDateTime(0L, DateTimeZone.UTC);
                pr = sdf.parseInto((ReadWritableInstant)d, tv, 0);
                long ts = d.getMillis();
                if (pr >= tv.length() - 3 && pr < tv.length()) {
                    ++foundPartial;
                }
                if (pr >= 0 && pr < tv.length() - 3) {
                    ++foundNOK;
                }
                if (pr < 0) {
                    if (keptBad < badExamples && r.nextInt(gf.nbNOK) <= badExamples || keptBad + (gf.nbNOK - seenBad) <= badExamples) {
                        gf.exampleIN.add(v);
                        gf.exampleStatus.add(-1);
                        gf.exampleClean.add(null);
                        gf.exampleTS.add(null);
                        ++keptBad;
                    }
                    ++seenBad;
                    continue;
                }
                if (keptGood < goodExamples && r.nextInt(gf.nbOK) <= goodExamples || keptGood + (gf.nbOK - seenGood) <= goodExamples) {
                    gf.exampleIN.add(v);
                    if (pr == tv.length()) {
                        gf.exampleStatus.add(0);
                    } else {
                        int index = pr;
                        if (tv.length() != v.length() && !v.substring(0, index).equals(tv.substring(0, index))) {
                            index += v.length() - tv.length();
                        }
                        gf.exampleStatus.add(index);
                    }
                    gf.exampleClean.add(rfc822.print((ReadableInstant)d));
                    gf.exampleTS.add(ts);
                    ++keptGood;
                }
                ++seenGood;
            }
            catch (Exception e) {
                if (keptBad < badExamples && r.nextInt(gf.nbNOK) <= badExamples || keptBad + (gf.nbNOK - seenBad) <= badExamples) {
                    gf.exampleIN.add(v);
                    gf.exampleStatus.add(-1);
                    gf.exampleClean.add(null);
                    gf.exampleTS.add(null);
                    ++keptBad;
                }
                ++seenBad;
            }
        }
        gf.nbOK -= foundPartial + foundNOK;
        gf.nbPartial = foundPartial;
        gf.nbNOK += foundNOK;
        return gf;
    }

    public GuessResponse guess(MemTable mt, String column) throws InvalidFormatException {
        GuessResponse ret = new GuessResponse();
        MemColumn c2 = mt.column(column);
        DateFormatGuesser guesser = new DateFormatGuesser();
        int observed = 0;
        for (MemRow mr : mt.rows) {
            String v;
            if (mr.isDeleted() || (v = mr.get(c2)) == null || v.length() == 0) continue;
            guesser.addObservation(v);
            if (observed++ != 300) continue;
            break;
        }
        List<DateFormatGuesser.DetectedFormat> formats = guesser.getResults();
        for (DateFormatGuesser.DetectedFormat inFormat : formats) {
            if (inFormat.trust < 1) {
                logger.debug((Object)("not trusted format skipped: " + inFormat.format));
                continue;
            }
            logger.debug((Object)("candidate format: " + inFormat.format));
            GuessFormat gf = this.validate(mt, column, inFormat.format, inFormat.trust);
            if (!(((double)gf.nbOK + (double)gf.nbPartial) / (double)gf.nbNOK > 0.05)) continue;
            ret.formats.add(gf);
        }
        Collections.sort(ret.formats);
        return ret;
    }

    public static class GuessFormat
    implements Comparable<GuessFormat> {
        public boolean validFormat;
        public String invalidFormatMessage;
        public String format;
        public String example;
        @Nonnull
        public Language language = Language.en_US;
        public int nbOK;
        public int nbNOK;
        public int nbPartial;
        public int trust;
        public List<String> exampleIN = new ArrayList<String>();
        public List<Long> exampleTS = new ArrayList<Long>();
        public List<String> exampleClean = new ArrayList<String>();
        public List<Integer> exampleStatus = new ArrayList<Integer>();

        private boolean isDateFormatOnly() {
            if (this.format.contains("H") || this.format.contains("m") || this.format.contains("s") || this.format.contains("S")) {
                return false;
            }
            return this.format.contains("y") && this.format.contains("M") && this.format.contains("d");
        }

        @Override
        public int compareTo(GuessFormat o) {
            if (this.trust < o.trust) {
                return 1;
            }
            if (this.trust > o.trust) {
                return -1;
            }
            if (this.nbOK < o.nbOK) {
                return 1;
            }
            if (this.nbOK > o.nbOK) {
                return -1;
            }
            boolean lhsIsDateFormatOnly = this.isDateFormatOnly();
            boolean rhsIsDateFormatOnly = o.isDateFormatOnly();
            if (lhsIsDateFormatOnly && !rhsIsDateFormatOnly) {
                return -1;
            }
            if (!lhsIsDateFormatOnly && rhsIsDateFormatOnly) {
                return 1;
            }
            return 0;
        }
    }

    public static class GuessResponse {
        public List<GuessFormat> formats = new ArrayList<GuessFormat>();
    }

    public static class InvalidFormatException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidFormatException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

