/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.sql;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.FilterAndFlagProcessor;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class AbstractSqlFilterAndFlag {
    private static final boolean INVERTED = true;
    private Map<String, ExpressionBuilder> criteriaPerColumns;
    protected SQLQueryWithSchema chain;
    protected final StepParams parameter;
    protected ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sql");

    AbstractSqlFilterAndFlag(SQLQueryWithSchema chain, StepParams parameter) {
        this.chain = chain;
        this.parameter = parameter;
        this.init();
    }

    protected abstract void init();

    protected abstract FilterAndFlagProcessor.Action getAction();

    protected abstract List<String> getAppliesToColumns();

    @Nullable
    protected abstract FilterAndFlagProcessor.BooleanMode getBooleanConditionsForMultipleColumns();

    @Nullable
    protected abstract String getColumnToAddFlagColumnAfter();

    protected abstract String getFlagColumn();

    protected abstract ExpressionBuilder exprFor(String var1);

    public SQLQueryWithSchema apply() {
        switch (this.getAction()) {
            case KEEP_ROW: {
                return this.applyKeepRow(this.getBooleanConditionsForMultipleColumns());
            }
            case REMOVE_ROW: {
                return this.applyRemoveRow(this.getBooleanConditionsForMultipleColumns());
            }
            case CLEAR_CELL: {
                return this.applyClearCell(false);
            }
            case DONTCLEAR_CELL: {
                return this.applyClearCell(true);
            }
            case FLAG: {
                return this.applyFlag(this.getColumnToAddFlagColumnAfter(), this.getBooleanConditionsForMultipleColumns(), this.getFlagColumn());
            }
        }
        throw new IllegalArgumentException(String.format("Unknown action: %s", new Object[]{this.getAction()}));
    }

    private Map<String, ExpressionBuilder> getCriteriaPerColumns() {
        if (this.criteriaPerColumns != null) {
            return this.criteriaPerColumns;
        }
        this.criteriaPerColumns = new HashMap<String, ExpressionBuilder>();
        for (String column : this.getAppliesToColumns()) {
            this.criteriaPerColumns.put(column, this.exprFor(column));
        }
        return this.criteriaPerColumns;
    }

    private SQLQueryWithSchema applyKeepRow(FilterAndFlagProcessor.BooleanMode booleanMode) {
        return this.applyKeepOrRemoveRow(booleanMode, false);
    }

    private SQLQueryWithSchema applyRemoveRow(FilterAndFlagProcessor.BooleanMode booleanMode) {
        return this.applyKeepOrRemoveRow(booleanMode, true);
    }

    private SQLQueryWithSchema applyKeepOrRemoveRow(@Nullable FilterAndFlagProcessor.BooleanMode booleanMode, boolean removeRow) {
        ExpressionBuilder criteria = this.buildConditionsExpression(booleanMode);
        this.chain.where(removeRow ? criteria.not() : criteria);
        return this.chain;
    }

    private SQLQueryWithSchema applyClearCell(boolean inverted) {
        for (Map.Entry<String, ExpressionBuilder> entry : this.getCriteriaPerColumns().entrySet()) {
            String col = entry.getKey();
            ExpressionBuilder condition = entry.getValue();
            SchemaColumn schemaColumn = this.chain.getCurrentColumn(col);
            Type type = schemaColumn == null ? Type.STRING : schemaColumn.getType();
            int maxLength = schemaColumn == null ? 100 : schemaColumn.getMaxLength();
            ExpressionBuilder eb = this.chain.col(col).nullWhen(inverted ? condition.not() : condition, type, maxLength);
            this.chain.replaceSelect(col, eb, col);
            this.chain.markColumnModified(col);
        }
        return this.chain;
    }

    private SQLQueryWithSchema applyFlag(@Nullable String columnToAddAfter, @Nullable FilterAndFlagProcessor.BooleanMode booleanMode, String flagColumn) {
        boolean addLast;
        ExpressionBuilder eb = this.buildConditionsExpression(booleanMode);
        boolean flagColumnExisted = this.chain.getCurrentColumn(flagColumn) != null;
        SchemaColumn outputSchema = new SchemaColumn(flagColumn, Type.BIGINT);
        boolean bl = addLast = columnToAddAfter == null;
        if (addLast) {
            this.chain.addColumn(outputSchema);
        } else {
            this.chain.addColumnAfter(columnToAddAfter, outputSchema);
        }
        ExpressionBuilder newFlag = this.ebf.caseWhen(eb, this.ebf.cst(1), this.ebf.nullValue(Type.INT, -1));
        if (flagColumnExisted) {
            this.chain.coalesceAndCastSelect(flagColumn, newFlag, flagColumn, Type.BIGINT, -1);
        } else {
            this.chain.select(newFlag.castToBigint(), flagColumn);
        }
        return this.chain;
    }

    private ExpressionBuilder buildConditionsExpression(@Nullable FilterAndFlagProcessor.BooleanMode booleanMode) {
        Preconditions.checkState((!this.getCriteriaPerColumns().isEmpty() ? 1 : 0) != 0, (Object)"At least one criteria must be specified.");
        if (this.getCriteriaPerColumns().size() > 1 && booleanMode == null) {
            throw new IllegalStateException("A boolean mode must be specified when multiple conditions are defined.");
        }
        ExpressionBuilder result = null;
        for (ExpressionBuilder criteria : this.getCriteriaPerColumns().values()) {
            if (result == null) {
                result = criteria;
                continue;
            }
            if (FilterAndFlagProcessor.BooleanMode.AND.equals((Object)booleanMode)) {
                result = result.and(criteria);
                continue;
            }
            result = result.or(criteria);
        }
        assert (result != null);
        return result;
    }
}

