/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.sparksql;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.resources.ResourcesGatherer;
import com.dataiku.dip.spark.sparksql.DkuSparkAddFilesResponse;
import com.dataiku.dip.spark.sparksql.DkuSparkSQLConnection;
import com.dataiku.dip.spark.sparksql.DkuSparkSQLExecutionResponse;
import com.dataiku.dip.spark.sparksql.DkuSparkSQLResultSet;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DkuSparkSQLStatement
implements Statement {
    protected final DkuSparkSQLConnection connection;
    protected DkuSparkSQLExecutionResponse response = null;
    private boolean isClosed;
    private int fetchSize = 1000;
    private int maxRows = Integer.MAX_VALUE;
    private static Logger logger = Logger.getLogger((String)"dip.livy.statement");

    DkuSparkSQLStatement(DkuSparkSQLConnection connection, int fetchSize) {
        this.connection = connection;
        this.fetchSize = fetchSize;
        this.isClosed = false;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            this.isClosed = true;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        logger.info((Object)("Set maxRows=" + max));
        this.maxRows = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void cancel() throws SQLException {
        this.connection.getSparkSQLHandler().cancel();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        logger.info((Object)("Set fetchSize=" + rows));
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    DkuSparkSQLExecutionResponse fetchNextBatch(String statementIdentifier) throws SQLException {
        DkuSparkSQLExecutionResponse nextBatch = this.connection.getSparkSQLHandler().nextBatch(this.fetchSize, statementIdentifier);
        if (nextBatch.error != null) {
            throw new SQLException("Failed to get next batch", new APIError.SerializedErrorException(nextBatch.error));
        }
        return nextBatch;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.doExecute(sql);
    }

    protected boolean doExecute(String sql) throws SQLException {
        this.response = this.connection.getSparkSQLHandler().executeStatement(this.connection.getDatabase(), this.fetchSize, sql);
        if (this.response.error != null) {
            throw new SQLException("Failed to execute sql", new APIError.SerializedErrorException(this.response.error));
        }
        return true;
    }

    public boolean doExecuteAndScript(String sql, List<ScriptStep> scriptSteps, Schema scriptOutputSchema, String reportLocation) throws SQLException {
        Map<String, String> resourceMapping;
        try {
            ResourcesGatherer gatherer = new ResourcesGatherer();
            gatherer.gatherResources(scriptSteps);
            gatherer.computeMapping();
            resourceMapping = gatherer.getResourceMapping();
            Map<String, String> localResourceMapping = gatherer.getFullLocalPathResourceMapping();
            if (localResourceMapping.size() > 0) {
                DkuSparkAddFilesResponse added = this.connection.getSparkSQLHandler().addFiles(localResourceMapping);
                if (added.error != null) {
                    throw new SQLException("Failed to add files", new APIError.SerializedErrorException(added.error));
                }
                logger.info((Object)("File additions outcome is " + JSON.json(added.added)));
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Failed to gather files needed by steps", e);
        }
        this.response = this.connection.getSparkSQLHandler().executeStatementAndScript(this.connection.getDatabase(), this.fetchSize, sql, scriptSteps, scriptOutputSchema, reportLocation, resourceMapping);
        if (this.response.error != null) {
            throw new SQLException("Failed to execute sql and script", new APIError.SerializedErrorException(this.response.error));
        }
        return true;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return new DkuSparkSQLResultSet(this, this.maxRows, this.response);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.execute(sql)) {
            return this.getResultSet();
        }
        throw new SQLException("Query didn't return a result set");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (!this.execute(sql)) {
            return this.getUpdateCount();
        }
        throw new SQLException("Query didn't return an update count");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new NotImplementedException("Should not be accessed");
    }
}

