/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.yarnaware;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.yarnaware.SparkYarnClusterHelper;
import com.dataiku.dip.spark.yarnaware.YarnClusterCache;
import com.dataiku.dip.spark.yarnaware.YarnClusterCacheDAO;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class YarnClusterService {
    @Autowired
    private YarnClusterCacheDAO yarnClusterCacheDAO;
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    private static final Logger logger = Logger.getLogger((String)"dku.yarn.cluster.cache");

    public FutureResponse<String> preload(AuthCtx authCtx, SparkSettings.YarnClusterSettings yarnClusterSettings) throws Exception {
        YarnClusterCache oldCache = this.yarnClusterCacheDAO.getUnsafe();
        if (!JSON.jsonEquals((Object)yarnClusterSettings, (Object)oldCache.yarnClusterSettings)) {
            oldCache = new YarnClusterCache();
        }
        PreloadThread ft = new PreloadThread(authCtx, yarnClusterSettings, oldCache);
        return this.futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<String>>(){});
    }

    private class PreloadThread
    extends SimpleFutureThread<String> {
        private final FuturePayload futurePayload;
        private final AuthCtx authCtx;
        private final SparkSettings.YarnClusterSettings yarnClusterSettings;
        private final YarnClusterCache oldCache;

        private PreloadThread(AuthCtx authCtx, SparkSettings.YarnClusterSettings yarnClusterSettings, YarnClusterCache oldCache) {
            super(authCtx);
            this.authCtx = authCtx;
            this.yarnClusterSettings = yarnClusterSettings;
            this.oldCache = oldCache;
            this.futurePayload = FuturePayload.newSimple((String)"preload_yarn_cluster", (String)"Preload files for yarn-cluster apps");
        }

        @Override
        protected String compute() throws Exception {
            YarnClusterCache newCache = this.doPreload(this.authCtx, this.yarnClusterSettings, this.oldCache);
            try (RWTransaction tr = YarnClusterService.this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
                YarnClusterService.this.yarnClusterCacheDAO.save(newCache);
                tr.commit("Save preloaded files list");
            }
            return "done";
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        private YarnClusterCache doPreload(AuthCtx authCtx, SparkSettings.YarnClusterSettings yarnClusterSettings, YarnClusterCache oldCache) throws Exception {
            List<File> localFiles = this.getFilesToUpload();
            ArrayList sparkConf = Lists.newArrayList();
            sparkConf.add(new SimpleKeyValue("dku.keep.yarn.cluster.temp.files", "true"));
            try (SparkYarnClusterHelper helper = new SparkYarnClusterHelper(authCtx, "__dku-yarn-cluster-cached-files", yarnClusterSettings, sparkConf);){
                YarnClusterCache yarnClusterCache;
                block30: {
                    FutureProgress.AutocloseableFutureProgressState preloadingState = FutureProgress.pushAutoCloseableState((String)"Preloading", (double)3.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                    try {
                        ArrayList toUpload = Lists.newArrayList();
                        ArrayList toReplace = Lists.newArrayList();
                        for (File file : localFiles) {
                            YarnClusterCache.YarnClusterFile cachedFile = oldCache.getEntryFor(file.getAbsolutePath());
                            if (cachedFile != null) {
                                if (cachedFile.size == file.length() && cachedFile.lastModified == file.lastModified()) continue;
                                toUpload.add(file);
                                toReplace.add(cachedFile);
                                continue;
                            }
                            toUpload.add(file);
                        }
                        preloadingState.increment(1.0);
                        logger.info((Object)("Found " + toUpload.size() + " files to upload, and " + toReplace.size() + " to replace"));
                        try (FutureProgress.AutocloseableFutureProgressState clearingState = FutureProgress.pushAutoCloseableState((String)"Clearing", (double)toReplace.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                            for (YarnClusterCache.YarnClusterFile cached : toReplace) {
                                helper.clear(cached.remotePath);
                            }
                            clearingState.increment(1.0);
                        }
                        preloadingState.increment(1.0);
                        ArrayList newUploaded = Lists.newArrayList();
                        try (FutureProgress.AutocloseableFutureProgressState autocloseableFutureProgressState = FutureProgress.pushAutoCloseableState((String)"Uploading", (double)toUpload.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                            for (File localFile : toUpload) {
                                String uploaded = helper.uploadKeepName(localFile);
                                YarnClusterCache.YarnClusterFile remoteFile = new YarnClusterCache.YarnClusterFile();
                                remoteFile.localPath = localFile.getAbsolutePath();
                                remoteFile.size = localFile.length();
                                remoteFile.lastModified = localFile.lastModified();
                                remoteFile.remotePath = uploaded;
                                remoteFile.remoteUri = helper.getURIForUploadedPath(uploaded);
                                newUploaded.add(remoteFile);
                                autocloseableFutureProgressState.increment(1.0);
                            }
                        }
                        preloadingState.increment(1.0);
                        YarnClusterCache yarnClusterCache2 = new YarnClusterCache();
                        yarnClusterCache2.yarnClusterSettings = (SparkSettings.YarnClusterSettings)JSON.deepCopy((Object)yarnClusterSettings);
                        for (YarnClusterCache.YarnClusterFile f : oldCache.cached) {
                            if (toReplace.contains(f)) continue;
                            yarnClusterCache2.cached.add(f);
                        }
                        yarnClusterCache2.cached.addAll(newUploaded);
                        yarnClusterCache = yarnClusterCache2;
                        if (preloadingState == null) break block30;
                    }
                    catch (Throwable throwable) {
                        if (preloadingState != null) {
                            try {
                                preloadingState.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    preloadingState.close();
                }
                return yarnClusterCache;
            }
        }

        private List<File> getFilesToUpload() {
            ArrayList localFiles = Lists.newArrayList();
            for (String runConf : SparkJobHelper.IVY_RUN_CONFS) {
                for (File f : DKUFileUtils.listJarFiles((File)new File(ApplicationConfigurator.getInstallFolder() + "/lib/ivy/" + runConf))) {
                    if (SparkJobHelper.shouldExclude(f.getName())) continue;
                    localFiles.add(f);
                }
            }
            ImmutableList scalaDists = ImmutableList.of((Object)"dss-spark-public", (Object)"dss-spark-main");
            String scalaVersion = "2.12";
            for (String scalaDist : scalaDists) {
                localFiles.add(SparkJobHelper.getSparkJar(scalaVersion, scalaDist));
            }
            localFiles.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/shadelib", "dss-shadelib-assembly.jar"));
            localFiles.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/shadelib", "dss-shadelib-aws-sdk2.jar"));
            localFiles.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/shadelib", "dss-shadelib-azure.jar"));
            localFiles.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/shadelib", "dss-shadelib-apache-poi.jar"));
            localFiles.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/shadelib", "dss-shadelib-legacy-aws-assembly.jar"));
            for (String dist : SparkJobHelper.JARS_TO_SEND_TO_SPARK) {
                localFiles.add(new File(ApplicationConfigurator.getInstallFolder() + "/dist/" + dist));
            }
            for (File f : DKUFileUtils.listJarFiles((File)new File(ApplicationConfigurator.getInstallFolder() + "/lib/third"))) {
                if (f.getName().contains("dataiku-hive-udf")) continue;
                localFiles.add(f);
            }
            return localFiles;
        }
    }
}

