/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public class DremioSQLDialect
extends GenericSQLDialect {
    public static final boolean DREMIO_IS_SHIT = true;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.sqldialect.dremio");

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case TINYINT: {
                return new DSSTypeSQLMapping(Type.TINYINT, 4, "int", new Integer[0]);
            }
            case SMALLINT: {
                return new DSSTypeSQLMapping(Type.SMALLINT, 4, "int", new Integer[0]);
            }
            case FLOAT: {
                return new DSSTypeSQLMapping(Type.FLOAT, 6, "float", new Integer[0]);
            }
            case DOUBLE: {
                return new DSSTypeSQLMapping(Type.DOUBLE, 8, "double", new Integer[0]);
            }
            case STRING: {
                return new DSSTypeSQLMapping(Type.STRING, 12, "varchar(999999999)", new Integer[]{2003, 1, 1111, -16, -1, -9, 92});
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public boolean lacksTimezoneInfo(String sqlTypeName, int sqlPrecision) {
        return true;
    }

    @Override
    public String getValueAsDSSString(ResultSet rs2, int sqlType, int colIdx, SchemaColumn schemaColumn, boolean normalizeDoubles, boolean timestampNoTzAsDate, DateTimeZone assumedTz) throws SQLException {
        Type dssType = schemaColumn.getType();
        switch (sqlType) {
            case 93: {
                if (dssType == Type.DATETIMENOTZ) {
                    return DremioSQLDialect.getCleanTimestampStringFromDremio(rs2, colIdx);
                }
                if (dssType != Type.DATE || !timestampNoTzAsDate) break;
                this.ensureThreadLocalsAreHere();
                String s = DremioSQLDialect.getCleanTimestampStringFromDremio(rs2, colIdx);
                if (StringUtils.isBlank((String)s)) {
                    return null;
                }
                DateTimeFormatter sdf = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS").withZone(assumedTz);
                return ISODateTimeFormat.dateHourMinuteSecondMillis().withZone(DateTimeZone.UTC).print((ReadableInstant)sdf.parseDateTime(s)) + "Z";
            }
        }
        return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
    }

    private static String getCleanTimestampStringFromDremio(ResultSet rs2, int colIdx) throws SQLException {
        Object stringFromDremio = rs2.getString(colIdx);
        if (stringFromDremio != null && ((String)stringFromDremio).endsWith(".0")) {
            stringFromDremio = (String)stringFromDremio + "00";
        }
        return stringFromDremio;
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return -1;
    }

    @Override
    public String getQuotedTableFullName(String catalog, String schema, String table) {
        String quotedCatalog = StringUtils.isBlank((String)catalog) ? null : this.quoteIdentifier(catalog);
        String quotedSchema = schema;
        String quotedTable = this.quoteIdentifier(table);
        ArrayList<String> components = new ArrayList<String>();
        if (quotedCatalog != null) {
            components.add(quotedCatalog);
        }
        if (quotedSchema != null) {
            components.add(quotedSchema);
        }
        components.add(quotedTable);
        return StringUtils.join(components, (String)".");
    }

    @Override
    public SQLUtils.SQLTable postProcessTableFoundThroughJDBCMetadataSearch(SQLUtils.SQLTable input) {
        if (input.getCatalog() != null) {
            logger.warn((Object)("Dremio returned a catalog ?!: " + JSON.json((Object)input)));
            return input;
        }
        String tableSchema = input.getSchemaNullIfBlank();
        if (tableSchema == null) {
            logger.warn((Object)("Dremio did not return a schema ?!: " + JSON.json((Object)input)));
            return input;
        }
        String tableName = input.getTable();
        if (tableSchema.contains(".")) {
            logger.info((Object)(". found in Dremio schema name -> quoting only the catalog part: schema=" + tableSchema + "  table=" + tableName));
            String[] dotChunks = StringUtils.split((String)tableSchema, (char)'.');
            assert (dotChunks.length > 1);
            String actualCatalog = dotChunks[0];
            String actualSchema = StringUtils.join((Object[])Arrays.copyOfRange(dotChunks, 1, dotChunks.length), (char)'.');
            if (actualSchema.startsWith("samples.dremio.com")) {
                actualSchema = actualSchema.replaceAll("^samples.dremio.com", "\"samples.dremio.com\"");
                logger.debug((Object)("actualSchema replaced: " + actualSchema));
            }
            String fixedUpSchema = this.quoteIdentifier(actualCatalog) + "." + actualSchema;
            return new SQLUtils.SQLTable(null, fixedUpSchema, tableName, input.getRemarks(), input.isTrueTable());
        }
        logger.info((Object)("No . in Dremio schema name -> table at root of catalog, quoting the entire schema: schema=" + tableSchema + "  table=" + tableName));
        return new SQLUtils.SQLTable(null, this.quoteIdentifier(tableSchema), tableName, input.getRemarks(), input.isTrueTable());
    }

    @Override
    public String postProcessSchemaPatternForJDBCMetadataSearch(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("\"", "");
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.DATEDIFF, null, QueryUtils.Arity.NARY, GenericSQLDialect.SQLPriority.PLUS.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String unit;
                this.validateMinNumberOfParameters(args, 2);
                String end = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.PLUS.priority);
                String start = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.PLUS.priority);
                switch (unit = this.getParamAs(args[2], String.class)) {
                    case "DAY": {
                        return "DATEDIFF(" + start + "," + end + ")";
                    }
                }
                throw new NotImplementedException("Datediff with unit=" + unit + " not supported for Dremio");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 1);
                if (args.length > 2 && args[2] != null) {
                    return "CONVERT_TIMEZONE(" + this.toSQLNoBrackets(args[1]) + ", " + this.toSQLNoBrackets(args[2]) + ", " + this.toSQLNoBrackets(args[0]) + ")";
                }
                if (args.length > 1 && args[1] != null) {
                    return "CONVERT_TIMEZONE(" + this.toSQLNoBrackets(args[1]) + ", 'UTC', " + this.toSQLNoBrackets(args[0]) + ")";
                }
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.removeOperator(QueryUtils.OperatorType.REGEXP_SUBSTR);
    }

    @Override
    public SQLUtils.SQLTable getSafeRandomTemporaryTableName(String catalog, String schema, String prefix, String suffix) {
        return new SQLUtils.SQLTable(null, schema, this.getSafeRandomTemporaryTableName(prefix) + suffix);
    }

    @Override
    public String getLimitedQuery(String query, long size) {
        return this.getLimitedQueryUsingLimit(query, size);
    }

    @Override
    public boolean supportsIndexing() {
        return false;
    }

    @Override
    public boolean supportsIndexingOnTemporaryTables() {
        return false;
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        return new String[]{"CREATE TABLE " + this.getQuotedTableFullName(table) + " AS " + selectExpr};
    }

    @Override
    public String createTemporaryTable(SQLUtils.SQLTable table, String columnListExpr) {
        return "CREATE TABLE " + this.getQuotedTableFullName(table) + " (" + columnListExpr + ") ";
    }

    @Override
    public boolean supportsNullsOrdering() {
        return false;
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[0];
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    public int getIdentifiersMaxLength() {
        return 128;
    }

    @Override
    public boolean supportsCommitAndRollback() {
        return false;
    }

    @Override
    public String datetimenotzPartExpression(String inputDateExpression, DatePart part) {
        return this.datePartExpression(inputDateExpression, part);
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "EXTRACT(DAY FROM " + inputDateExpression + ")";
            }
            case HOUR_OF_DAY: {
                return "EXTRACT(HOUR FROM " + inputDateExpression + ")";
            }
            case MINUTE_OF_HOUR: {
                return "EXTRACT(MINUTE FROM " + inputDateExpression + ")";
            }
            case SECOND_OF_MINUTE: {
                return "EXTRACT(SECOND FROM " + inputDateExpression + ")";
            }
            case MONTH_OF_YEAR: {
                return "EXTRACT(MONTH FROM " + inputDateExpression + ")";
            }
            case WEEK_OF_YEAR: {
                return "WEEKOFYEAR(" + inputDateExpression + ")";
            }
            case QUARTER_OF_YEAR: {
                return "EXTRACT(QUARTER FROM " + inputDateExpression + ")";
            }
            case DAY_OF_WEEK: {
                return "(1 + MOD((DAYOFWEEK( " + inputDateExpression + ") + 5), 7))";
            }
            case YEAR: {
                return "EXTRACT(YEAR FROM " + inputDateExpression + ")";
            }
            case SECOND_FROM_EPOCH: {
                return "cast(EXTRACT(EPOCH FROM " + inputDateExpression + " ) as bigint)";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on Dremio", part));
    }

    @Override
    public String dateonlyPartExpression(String inputDateExpression, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "EXTRACT(DAY FROM " + inputDateExpression + ")";
            }
            case HOUR_OF_DAY: {
                return "EXTRACT(HOUR FROM " + inputDateExpression + ")";
            }
            case MONTH_OF_YEAR: {
                return "EXTRACT(MONTH FROM " + inputDateExpression + ")";
            }
            case WEEK_OF_YEAR: {
                return "WEEKOFYEAR(" + inputDateExpression + ")";
            }
            case QUARTER_OF_YEAR: {
                return "EXTRACT(QUARTER FROM " + inputDateExpression + ")";
            }
            case DAY_OF_WEEK: {
                return "(1 + MOD((DAYOFWEEK( " + inputDateExpression + ") + 5), 7))";
            }
            case YEAR: {
                return "EXTRACT(YEAR FROM " + inputDateExpression + ")";
            }
            case SECOND_FROM_EPOCH: {
                return "cast(EXTRACT(EPOCH FROM " + inputDateExpression + " ) as bigint)";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on Dremio", part));
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        String dateAtGmt = inputDateExpression;
        switch (rounding) {
            case YEAR: {
                return "DATE_TRUNC('YEAR', " + dateAtGmt + ")";
            }
            case QUARTER: {
                return "DATE_TRUNC('QUARTER', " + dateAtGmt + ")";
            }
            case MONTH: {
                return "DATE_TRUNC('MONTH', " + dateAtGmt + ")";
            }
            case WEEK: {
                return "DATE_TRUNC('WEEK', " + dateAtGmt + ")";
            }
            case DAY: {
                return "DATE_TRUNC('DAY', " + dateAtGmt + ")";
            }
            case HOUR: {
                return "DATE_TRUNC('HOUR', " + dateAtGmt + ")";
            }
            case MINUTE: {
                return "DATE_TRUNC('MINUTE', " + dateAtGmt + ")";
            }
            case SECOND: {
                return "DATE_TRUNC('SECOND', " + dateAtGmt + ")";
            }
        }
        throw new QueryUtils.SQLGenerationException("Date trunc with unit '" + String.valueOf(rounding) + "' not implemented for Dremio");
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        return this.dateTrunc(inputDateExpression, rounding);
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        String dateAtGmt = inputDateExpression;
        switch (rounding) {
            case YEAR: {
                return "DATE_TRUNC('YEAR', " + dateAtGmt + ")";
            }
            case QUARTER: {
                return "DATE_TRUNC('QUARTER', " + dateAtGmt + ")";
            }
            case MONTH: {
                return "DATE_TRUNC('MONTH', " + dateAtGmt + ")";
            }
            case WEEK: {
                return "DATE_TRUNC('WEEK', " + dateAtGmt + ")";
            }
            case DAY: {
                return "DATE_TRUNC('DAY', " + dateAtGmt + ")";
            }
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                throw new QueryUtils.SQLGenerationException("Date trunc with unit '" + String.valueOf(rounding) + "' not relevant for date only type");
            }
        }
        throw new QueryUtils.SQLGenerationException("Date trunc with unit '" + String.valueOf(rounding) + "' not implemented for Dremio");
    }

    @Override
    public boolean supportsBatchUpdates(SQLConnectionProvider.SQLConnectionData connData) {
        return false;
    }

    @Override
    public boolean supportsInsertWithPreparedStatement(SQLConnectionProvider.SQLConnectionData connData) {
        return false;
    }

    @Override
    public String getValueAsSQLString(Type type, String value) {
        if (value == null) {
            return null;
        }
        if (type == Type.DATE) {
            return DKUtils.isoFormatReadableByDatetimeNoTzFormat((long)this.dateToTimeStamp(value));
        }
        return super.getValueAsSQLString(type, value);
    }

    @Override
    public String appendLiteralForInsertStatementFromValueAsSQLString(Type type, String value) {
        if (type == Type.STRING) {
            if (value == null) {
                return "NULL";
            }
            return "_utf8" + this.quoteString(value);
        }
        return super.appendLiteralForInsertStatementFromValueAsSQLString(type, value);
    }

    @Override
    public String getId() {
        return "Dremio";
    }
}

