/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.crecipes.sync;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.streaming.crecipes.sync.CSyncRecipeParams;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class CsyncRecipeSchemaComputer
extends RecipeSchemaComputer {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;

    public CsyncRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public boolean computesDiffItself() {
        return false;
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            Preconditions.checkArgument((boolean)role.equals("main"), (Object)("Recipe only has output role 'main', got: " + role));
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
            ArrayList arrayList = Lists.newArrayList((Object[])new Schema[]{this.getSchema()});
            return arrayList;
        }
    }

    private Schema getSchema() throws Exception {
        CSyncRecipeParams syncParams = (CSyncRecipeParams)this.recipe.params;
        AnyLoc inputLoc = this.recipe.getSingleInput("main").getLoc(this.recipe.projectKey);
        AnyLoc outputLoc = this.recipe.getSingleOutput("main").getLoc(this.recipe.projectKey);
        StreamingEndpoint source = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatory(inputLoc);
        if (this.streamingEndpointsDAO.getOrNull(outputLoc) != null) {
            return (Schema)JSON.deepCopy((Object)source.schema);
        }
        Dataset outputDataset = this.datasetAccessService.getMandatory(outputLoc);
        ManagedDatasetsHelper.copySchema(this.authCtx, source.schema, outputDataset);
        return outputDataset.getSchema();
    }
}

