/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.timelines.workspace;

import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.DeleteQueryBuilder;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.InsertQueryBuilder;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.sql.queries.SimpleSelectQueryBuilder;
import com.dataiku.dip.timelines.workspace.WorkspaceTimeline;
import com.dataiku.dip.timelines.workspace.WorkspaceTimelineItem;
import com.dataiku.dip.timelines.workspace.WorkspaceTimelinesService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;

public class WorkspaceTimelineBehavior {
    public static final String WORKSPACE_TIMELINE_ITEM = "WORKSPACE_TIMELINE_ITEM";
    static final String USER_COLUMN = "USER";
    static final String ACTION_COLUMN = "ACTION";
    static final String DETAILS_COLUMN = "DETAILS";
    static final String ITEM_TIME_COLUMN = "ITEM_TIME";
    static final String OBJECT_TYPE_COLUMN = "OBJECT_TYPE";
    static final String OBJECT_PROJECT_KEY_COLUMN = "OBJECT_PROJECT_KEY";
    static final String OBJECT_ID_COLUMN = "OBJECT_ID";
    static final String WORKSPACE_KEY_COLUMN = "WORKSPACE_KEY";
    static final SchemaColumn WORKSPACE_KEY_SCHEMA_COLUMN = new SchemaColumn("WORKSPACE_KEY", Type.STRING);
    static final SchemaColumn[] TIMELINE_COLUMNS = new SchemaColumn[]{new SchemaColumn("USER", Type.STRING), new SchemaColumn("ACTION", Type.STRING), new SchemaColumn("OBJECT_TYPE", Type.STRING), new SchemaColumn("OBJECT_PROJECT_KEY", Type.STRING), new SchemaColumn("OBJECT_ID", Type.STRING), new SchemaColumn("DETAILS", Type.STRING), new SchemaColumn("ITEM_TIME", Type.BIGINT), WORKSPACE_KEY_SCHEMA_COLUMN};
    private static final String FAILED_TO_ACCESS_TIMELINES_DATABASE = "Failed to access timelines database";
    private static final ExpressionBuilder.ExpressionBuilderFactory EBF = new ExpressionBuilder.ExpressionBuilderFactory();
    public final String workspaceKey;
    private final SQLDialect dialect;
    private final SQLUtils.SQLTable resolvedTable;
    private final WorkspaceCache cache = new WorkspaceCache();
    private final String insert;
    private final String getRecent;
    private final String getForWorkspace;
    private final String getFirstForObject;
    private final String getLatestForObject;
    private final String getLatestForUser;
    private final String update;
    private final String fetchWorkspaceContributors;
    private final String deleteWorkspaceTimeline;
    private static final String ROOT_CACHE_KEY = "$$$root$$$";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.timelines");

    public WorkspaceTimelineBehavior(String workspaceKey, SQLUtils.SQLTable resolvedTable, SQLDialect dialect) {
        this.workspaceKey = workspaceKey;
        this.resolvedTable = resolvedTable;
        this.dialect = dialect;
        this.insert = InsertQueryBuilder.insertInto(resolvedTable).addColumns(TIMELINE_COLUMNS).toSQL(dialect);
        this.getRecent = this.selectAllColumnsFromTimeline().where(EBF.parameterizedColumnOperation(WORKSPACE_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(ITEM_TIME_COLUMN, QueryUtils.OperatorType.GT))).toSQL(dialect);
        this.getForWorkspace = SimpleSelectQueryBuilder.selectAll().from(resolvedTable, resolvedTable.getTable()).wheres(WORKSPACE_KEY_COLUMN).orderedBy(ITEM_TIME_COLUMN).descending().withParameterizedMax().toSQL(dialect);
        this.getFirstForObject = this.getQueryForObject().first().toSQL(dialect);
        this.getLatestForObject = this.getQueryForObject().last().toSQL(dialect);
        this.getLatestForUser = SimpleSelectQueryBuilder.selectAll().from(resolvedTable, resolvedTable.getTable()).wheres(WORKSPACE_KEY_COLUMN, USER_COLUMN).orderedBy(ITEM_TIME_COLUMN).last().toSQL(dialect);
        this.update = "UPDATE " + dialect.getQuotedTableFullName(resolvedTable) + " SET " + this.quote(ITEM_TIME_COLUMN) + "=?, " + this.quote(DETAILS_COLUMN) + "=? WHERE " + this.quote(WORKSPACE_KEY_COLUMN) + "=? AND " + this.quote(OBJECT_TYPE_COLUMN) + "=? AND " + this.quote(OBJECT_ID_COLUMN) + "=? AND " + this.quote(ACTION_COLUMN) + "=? AND " + this.quote(ITEM_TIME_COLUMN) + "=?";
        this.fetchWorkspaceContributors = SimpleSelectQueryBuilder.select(USER_COLUMN).from(resolvedTable, resolvedTable.getTable()).wheres(WORKSPACE_KEY_COLUMN).toSQL(dialect);
        this.deleteWorkspaceTimeline = DeleteQueryBuilder.deleteFrom(resolvedTable).withParameterizedEqualWheres(WORKSPACE_KEY_COLUMN).toSql(dialect);
    }

    void fetchInitialUIData(DSSDBConnection conn) {
        this.fetchWorkspaceContributors(conn);
    }

    public SQLUtils.SQLTable getResolvedTable() {
        return this.resolvedTable;
    }

    public SQLDialect getDialect() {
        return this.dialect;
    }

    protected PreparedStatement getPreparedStatement(DSSDBConnection conn, String sql) throws CodedSQLException {
        return conn.getOrCreatePreparedStatement(sql);
    }

    private String quote(String identifier) {
        return this.dialect.quoteIdentifier(identifier);
    }

    private SelectQueryBuilder selectAllColumnsFromTimeline() {
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        sqb.from(this.resolvedTable, this.resolvedTable.getTable());
        sqb.select("*");
        return sqb;
    }

    private SimpleSelectQueryBuilder getQueryForObject() {
        return SimpleSelectQueryBuilder.selectAll().from(this.resolvedTable, this.resolvedTable.getTable()).wheres(WORKSPACE_KEY_COLUMN, OBJECT_TYPE_COLUMN, OBJECT_PROJECT_KEY_COLUMN, OBJECT_ID_COLUMN).orderedBy(ITEM_TIME_COLUMN);
    }

    private void fetchWorkspaceContributors(DSSDBConnection conn) {
        try {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.fetchWorkspaceContributors);
            ps2.setString(1, this.workspaceKey);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    this.cache.contributors.add(rs2.getString(1));
                }
            }
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Could not fetch the workspace contributors for workspace %s.", new Object[]{this.workspaceKey});
        }
    }

    private String objectKey(ITaggingService.TaggableType objectType, String projectKey, String objectId) {
        return String.valueOf((Object)objectType) + "$$$" + projectKey + "$$$" + objectId;
    }

    private TaggableObjectsService.TaggableObjectRef makeTaggableObjectRef(ResultSet rs2) throws SQLException {
        ITaggingService.TaggableType type = null;
        try {
            type = ITaggingService.TaggableType.valueOf(rs2.getString(OBJECT_TYPE_COLUMN));
        }
        catch (Exception e) {
            logger.info((Object)("Taggable type does not exist anymore: " + rs2.getString(OBJECT_TYPE_COLUMN) + " " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        return new TaggableObjectsService.TaggableObjectRef(this.workspaceKey, type, rs2.getString(OBJECT_ID_COLUMN));
    }

    private WorkspaceTimelineItem.WorkspaceActionType readSafeActionType(String s) {
        try {
            if (!StringUtils.isBlank((String)s)) {
                return WorkspaceTimelineItem.WorkspaceActionType.valueOf(s);
            }
        }
        catch (IllegalArgumentException e) {
            logger.info((Object)"Failed to read action type.", (Throwable)e);
        }
        return WorkspaceTimelineItem.WorkspaceActionType.WORKSPACE_UNKNOWN;
    }

    public WorkspaceTimelineItem readWorkspaceTimelineItem(ResultSet rs2) throws SQLException {
        return new WorkspaceTimelineItem(rs2.getString(USER_COLUMN), this.readSafeActionType(rs2.getString(ACTION_COLUMN)), this.workspaceKey, ITaggingService.TaggableType.valueOf(rs2.getString(OBJECT_TYPE_COLUMN)), rs2.getString(OBJECT_PROJECT_KEY_COLUMN), rs2.getString(OBJECT_ID_COLUMN), rs2.getLong(ITEM_TIME_COLUMN)).withDetails((JsonObject)JSON.parse((String)rs2.getString(DETAILS_COLUMN), JsonObject.class));
    }

    private Map<TaggableObjectsService.TaggableObjectRef, List<WorkspaceTimelineItem>> readAsMap(ResultSet rs2) throws SQLException {
        HashMap<TaggableObjectsService.TaggableObjectRef, List<WorkspaceTimelineItem>> ret = new HashMap<TaggableObjectsService.TaggableObjectRef, List<WorkspaceTimelineItem>>();
        while (rs2.next()) {
            TaggableObjectsService.TaggableObjectRef ref = this.makeTaggableObjectRef(rs2);
            WorkspaceTimelineItem ti = this.readWorkspaceTimelineItem(rs2);
            if (ret.containsKey(ref)) {
                ((List)ret.get(ref)).add(ti);
                continue;
            }
            ret.put(ref, Lists.newArrayList((Object[])new WorkspaceTimelineItem[]{ti}));
        }
        return ret;
    }

    void insert(DSSDBConnection conn, WorkspaceTimelineItem ti) throws CodedSQLException {
        String key = this.objectKey(ti.objectType, ti.projectKey, ti.objectId);
        try {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.insert);
            ps2.setString(1, ti.user);
            if (ti.action != null) {
                ps2.setString(2, ti.action.toString());
            }
            if (ti.objectType != null) {
                ps2.setString(3, ti.objectType.toString());
            }
            if (ti.projectKey != null) {
                ps2.setString(4, ti.projectKey);
            }
            if (ti.objectId != null) {
                ps2.setString(5, ti.objectId);
            }
            ps2.setString(6, JSON.json((Object)ti.details));
            ps2.setLong(7, ti.time);
            ps2.setString(8, this.workspaceKey);
            ps2.execute();
            conn.commit();
            this.cache.latestItemCache.put((Object)key, (Object)ti);
            this.cache.latestItemCache.put((Object)ROOT_CACHE_KEY, (Object)ti);
            this.cache.latestItemCache.put((Object)this.getUserCacheKey(ti.user), (Object)ti);
            this.cache.contributors.add(ti.user);
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, FAILED_TO_ACCESS_TIMELINES_DATABASE, (Throwable)e);
        }
    }

    void update(DSSDBConnection conn, WorkspaceTimelineItem ti) throws CodedSQLException {
        String key = this.objectKey(ti.objectType, ti.projectKey, ti.objectId);
        try {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.update);
            ps2.setLong(1, System.currentTimeMillis());
            ps2.setString(2, JSON.json((Object)ti.details));
            ps2.setString(3, this.workspaceKey);
            ps2.setString(4, ti.objectType.toString());
            ps2.setString(5, ti.projectKey);
            ps2.setString(6, ti.objectId);
            ps2.setString(7, ti.action.toString());
            ps2.setLong(8, ti.time);
            ps2.execute();
            conn.commit();
            this.cache.latestItemCache.put((Object)key, (Object)ti);
            this.cache.latestItemCache.put((Object)ROOT_CACHE_KEY, (Object)ti);
            this.cache.latestItemCache.put((Object)this.getUserCacheKey(ti.user), (Object)ti);
            this.cache.contributors.add(ti.user);
        }
        catch (Exception e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, FAILED_TO_ACCESS_TIMELINES_DATABASE, (Throwable)e);
        }
    }

    WorkspaceTimelineItem getFirstForObject(DSSDBConnection conn, ITaggingService.TaggableType objectType, String projectKey, String objectId) throws CodedSQLException {
        try {
            String key = this.objectKey(objectType, projectKey, objectId);
            WorkspaceTimelineItem item = (WorkspaceTimelineItem)this.cache.firstItemCache.getIfPresent((Object)key);
            if (item != null && item.time > 0L) {
                return item;
            }
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getFirstForObject);
            ps2.setString(1, this.workspaceKey);
            ps2.setString(2, objectType.toString());
            ps2.setString(3, projectKey);
            ps2.setString(4, objectId);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                if (rs2.next()) {
                    item = this.readWorkspaceTimelineItem(rs2);
                    this.cache.firstItemCache.put((Object)key, (Object)item);
                } else {
                    this.cache.firstItemCache.put((Object)key, (Object)new WorkspaceTimelineItem());
                }
            }
            return item;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, FAILED_TO_ACCESS_TIMELINES_DATABASE, (Throwable)e);
        }
    }

    WorkspaceTimelineItem getLatestForObject(DSSDBConnection conn, ITaggingService.TaggableType objectType, String projectKey, String objectId) throws CodedSQLException {
        try {
            String key = this.objectKey(objectType, projectKey, objectId);
            WorkspaceTimelineItem item = (WorkspaceTimelineItem)this.cache.latestItemCache.getIfPresent((Object)key);
            if (item != null && item.time > 0L) {
                return item;
            }
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getLatestForObject);
            ps2.setString(1, this.workspaceKey);
            ps2.setString(2, objectType.toString());
            ps2.setString(3, projectKey);
            ps2.setString(4, objectId);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                if (rs2.next()) {
                    item = this.readWorkspaceTimelineItem(rs2);
                    this.cache.latestItemCache.put((Object)key, (Object)item);
                } else {
                    this.cache.latestItemCache.put((Object)key, (Object)new WorkspaceTimelineItem());
                }
            }
            return item;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, FAILED_TO_ACCESS_TIMELINES_DATABASE, (Throwable)e);
        }
    }

    WorkspaceTimelineItem getLatestForUser(DSSDBConnection conn, String userId) throws CodedSQLException {
        try {
            String key = this.getUserCacheKey(userId);
            WorkspaceTimelineItem item = (WorkspaceTimelineItem)this.cache.latestItemCache.getIfPresent((Object)key);
            if (item != null && item.time > 0L) {
                return item;
            }
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getLatestForUser);
            ps2.setString(1, this.workspaceKey);
            ps2.setString(2, userId);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                if (rs2.next()) {
                    item = this.readWorkspaceTimelineItem(rs2);
                    this.cache.latestItemCache.put((Object)key, (Object)item);
                } else {
                    this.cache.latestItemCache.put((Object)key, (Object)new WorkspaceTimelineItem());
                }
            }
            return item;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, FAILED_TO_ACCESS_TIMELINES_DATABASE, (Throwable)e);
        }
    }

    WorkspaceTimelineItem getLatest(DSSDBConnection conn) throws CodedSQLException {
        try {
            String key = ROOT_CACHE_KEY;
            WorkspaceTimelineItem item = (WorkspaceTimelineItem)this.cache.latestItemCache.getIfPresent((Object)key);
            if (item != null && item.time > 0L) {
                return item;
            }
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getForWorkspace);
            ps2.setString(1, this.workspaceKey);
            ps2.setInt(2, 1);
            ps2.setInt(3, 0);
            ps2.execute();
            WorkspaceTimeline result = new WorkspaceTimeline();
            try (ResultSet rs2 = ps2.getResultSet();){
                if (rs2.next()) {
                    item = this.readWorkspaceTimelineItem(rs2);
                    this.cache.latestItemCache.put((Object)key, (Object)item);
                } else {
                    this.cache.latestItemCache.put((Object)key, (Object)new WorkspaceTimelineItem());
                }
            }
            return item;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, FAILED_TO_ACCESS_TIMELINES_DATABASE, (Throwable)e);
        }
    }

    public void delete(DSSDBConnection conn) {
        this.clearTimelineTable(conn);
    }

    private void clearTimelineTable(DSSDBConnection conn) {
        try {
            PreparedStatement deleteWorkspaceTimelineItems = this.getPreparedStatement(conn, this.deleteWorkspaceTimeline);
            logger.debugV("Deleting timeline items for %s", new Object[]{this.workspaceKey});
            deleteWorkspaceTimelineItems.setString(1, this.workspaceKey);
            deleteWorkspaceTimelineItems.execute();
            conn.commit();
        }
        catch (SQLException e) {
            logger.errorV((Throwable)e, "Failed to remove timeline items from for workspace %s when deleting workspace.", new Object[]{this.workspaceKey});
        }
    }

    WorkspaceTimeline getTimeLineItemsForWorkspace(DSSDBConnection conn, int from, int limit) throws CodedSQLException {
        try {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getForWorkspace);
            ps2.setString(1, this.workspaceKey);
            ps2.setInt(2, limit);
            ps2.setInt(3, from);
            ps2.execute();
            WorkspaceTimeline result = new WorkspaceTimeline();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    try {
                        result.items.add(this.readWorkspaceTimelineItem(rs2));
                    }
                    catch (Exception e) {
                        logger.info((Object)"Failed to read timeline item", (Throwable)e);
                    }
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, FAILED_TO_ACCESS_TIMELINES_DATABASE, (Throwable)e);
        }
    }

    WorkspaceTimelinesService.WorkspaceTimelineWithVersioning getForWorkspace(DSSDBConnection conn, int from, int limit) throws CodedSQLException {
        try {
            WorkspaceTimelinesService.WorkspaceTimelineWithVersioning ret = new WorkspaceTimelinesService.WorkspaceTimelineWithVersioning();
            ret.items.addAll(this.getTimeLineItemsForWorkspace((DSSDBConnection)conn, (int)from, (int)limit).items);
            return ret;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, FAILED_TO_ACCESS_TIMELINES_DATABASE, (Throwable)e);
        }
    }

    Map<TaggableObjectsService.TaggableObjectRef, List<WorkspaceTimelineItem>> getRecent(DSSDBConnection conn, long since) throws CodedSQLException {
        Map<TaggableObjectsService.TaggableObjectRef, List<WorkspaceTimelineItem>> map;
        block8: {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getRecent);
            ps2.setString(1, this.workspaceKey);
            ps2.setLong(2, since);
            ResultSet rs2 = ps2.executeQuery();
            try {
                map = this.readAsMap(rs2);
                if (rs2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs2 != null) {
                        try {
                            rs2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, FAILED_TO_ACCESS_TIMELINES_DATABASE, (Throwable)e);
                }
            }
            rs2.close();
        }
        return map;
    }

    private String getUserCacheKey(String login) {
        return "$$$user$$$" + login;
    }

    public static class WorkspaceCache {
        Set<String> contributors = Collections.newSetFromMap(new ConcurrentHashMap());
        Cache<String, WorkspaceTimelineItem> firstItemCache = CacheBuilder.newBuilder().maximumSize(10000L).build();
        Cache<String, WorkspaceTimelineItem> latestItemCache = CacheBuilder.newBuilder().maximumSize(10000L).build();
    }
}

