/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import com.dataiku.dss.shadelib.org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.zip.GZIPInputStream;

public class TarArchiveUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.archive");

    private TarArchiveUtils() {
    }

    public static void extractTarGzFile(File tarGzFile, FilenameFilter filter) throws IOException {
        try (FileInputStream fis = new FileInputStream(tarGzFile);){
            File rootDir = tarGzFile.getParentFile();
            TarArchiveUtils.extractTarGzInputStream(fis, filter, rootDir);
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to decompress file %s", tarGzFile.getAbsolutePath()), e);
        }
        try {
            Files.delete(tarGzFile.toPath());
        }
        catch (IOException e) {
            logger.warn((Object)String.format("Could not delete expanded file %s", tarGzFile.getAbsolutePath()), (Throwable)e);
        }
    }

    public static void extractTarGzInputStream(InputStream tarGzIS, FilenameFilter filter, File destDir) throws IOException {
        try (GZIPInputStream gis = new GZIPInputStream(tarGzIS);
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)gis);){
            TarArchiveEntry entry;
            while ((entry = tin.getNextEntry()) != null) {
                File entryDir;
                String entryName;
                File entryFile = new File(destDir, entry.getName());
                if (!DKUFileUtils.isWithinFollowLinks((File)destDir, (File)entryFile)) {
                    throw new SecurityException(String.format("Cannot uncompress %s from %s", entryFile.getAbsolutePath(), destDir.getAbsolutePath()));
                }
                File parentDir = entryFile.getParentFile();
                if (!filter.accept(parentDir, entryName = entryFile.getCanonicalFile().getName())) continue;
                File file = entryDir = entry.isDirectory() ? entryFile : parentDir;
                if (!entryDir.exists() && !entryDir.mkdirs()) {
                    logger.error((Object)String.format("Could not create directory: %s", entryDir.getAbsolutePath()));
                }
                if (entry.isDirectory()) continue;
                try (FileOutputStream fos = new FileOutputStream(entryFile);){
                    IOUtils.copy((InputStream)tin, (OutputStream)fos);
                }
            }
        }
    }
}

