/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.variables;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariableExpandable;
import com.dataiku.dip.variables.VariablesContext;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;

public class VEInt
implements VariableExpandable {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.variables");
    private int value;
    private String expr;
    private transient boolean resolved;

    public VEInt(int value) {
        this.value = value;
    }

    public VEInt(String expr) {
        this.expr = expr;
    }

    @Override
    public void resolveValue(VariablesContext context) {
        this.value = context.getAsInt(this.expr);
        this.resolved = true;
    }

    public int getValue() {
        if (this.expr != null && !this.resolved) {
            throw new IllegalArgumentException("Value has not been resolved");
        }
        return this.value;
    }

    static {
        JSON.registerAdapter(VEInt.class, (Object)new JSON.Adapter<VEInt>(){

            public VEInt deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                logger.debug((Object)("DESER " + String.valueOf(jsonElement)));
                if (jsonElement.isJsonPrimitive()) {
                    return new VEInt(jsonElement.getAsInt());
                }
                JsonObject obj = jsonElement.getAsJsonObject();
                if (obj.has("expr")) {
                    return new VEInt(obj.get("expr").getAsString());
                }
                throw new IllegalArgumentException("Missing 'expr' in expandable int");
            }

            public JsonElement serialize(VEInt params, Type type, JsonSerializationContext ctx) {
                logger.debug((Object)("SERIALIZE " + String.valueOf(params)));
                if (params.expr != null) {
                    JsonObject ret = new JsonObject();
                    ret.addProperty("expr", params.expr);
                    logger.debug((Object)(" --> " + String.valueOf(ret)));
                    return ret;
                }
                logger.debug((Object)("Primitive " + params.value));
                return new JsonPrimitive((Number)params.value);
            }
        });
    }
}

