/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.variables;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariableExpandable;
import com.dataiku.dip.variables.VariablesContext;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;

public class VEString
implements VariableExpandable {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.variables");
    private String value;
    private String expr;
    private transient boolean resolved;

    public VEString() {
    }

    public VEString(String value) {
        this.value = value;
    }

    public static VEString fromExpr(String expr) {
        VEString ves = new VEString();
        ves.expr = expr;
        return ves;
    }

    @Override
    public void resolveValue(VariablesContext context) {
        this.value = context.getAsString(this.expr);
        this.resolved = true;
    }

    public String getValue() {
        if (this.expr != null && !this.resolved) {
            throw new IllegalArgumentException("Value has not been resolved");
        }
        return this.value;
    }

    static {
        JSON.registerAdapter(VEString.class, (Object)new JSON.Adapter<VEString>(){

            public VEString deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                if (jsonElement.isJsonPrimitive()) {
                    return new VEString(jsonElement.getAsString());
                }
                JsonObject obj = jsonElement.getAsJsonObject();
                if (obj.has("expr")) {
                    return new VEString(obj.get("expr").getAsString());
                }
                throw new IllegalArgumentException("Missing 'expr' in expandable int");
            }

            public JsonElement serialize(VEString params, Type type, JsonSerializationContext ctx) {
                logger.debug((Object)("SERIALIZE " + String.valueOf(params)));
                if (params.expr != null) {
                    JsonObject ret = new JsonObject();
                    ret.addProperty("expr", params.expr);
                    logger.debug((Object)(" --> " + String.valueOf(ret)));
                    return ret;
                }
                logger.debug((Object)("Primitive " + params.value));
                return new JsonPrimitive(params.value);
            }
        });
    }
}

