/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.yarn;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.springframework.beans.factory.annotation.Autowired;

public class YarnUtils {
    @Autowired
    private IImpersonationResolverService impersonationResolverService;
    private final HadoopSettings hadoopSettings;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.yarn.utils");

    public YarnUtils(HadoopSettings hadoopSettings) {
        this.hadoopSettings = hadoopSettings;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void tryFetchYarnLog(String yarnAppId, File yarnLogFile) throws IOException, InterruptedException {
        String user = this.fetchYarnJobUser(yarnAppId);
        logger.info((Object)("Application " + yarnAppId + " was run by " + user));
        try (FileOutputStream os = new FileOutputStream(yarnLogFile);){
            ArrayList command = Lists.newArrayList((Object[])new String[]{"com.dataiku.dip.cli.internalcmd.ConfigurableYarnLogsCLI", yarnAppId, JSON.json((Object)this.hadoopSettings.extraConf)});
            DKUtils.ExecBuilder execBuilder = new DKUtils.ExecBuilder().withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.OutputStreamSubscription((OutputStream)os, false));
            if (this.impersonationResolverService.isEnabled() && StringUtils.isNotBlank((String)user)) {
                execBuilder.withEnv("HADOOP_PROXY_USER", user);
            }
            this.runAbortableFakeYarnCommand(execBuilder, command);
        }
        if (yarnLogFile.exists() && yarnLogFile.length() == 0L && !yarnLogFile.delete()) {
            logger.warn((Object)("Unable to delete Yarn log file " + String.valueOf(yarnLogFile)));
        }
    }

    public void tryKillYarnApp(String yarnAppId) throws IOException, InterruptedException {
        String user = this.fetchYarnJobUser(yarnAppId);
        logger.info((Object)("Application " + yarnAppId + " is run by " + user));
        ArrayList command = Lists.newArrayList((Object[])new String[]{"com.dataiku.dip.cli.internalcmd.ConfigurableYarnApplicationKill", yarnAppId, JSON.json((Object)this.hadoopSettings.extraConf)});
        DKUtils.ExecBuilder execBuilder = new DKUtils.ExecBuilder().withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO));
        if (this.impersonationResolverService.isEnabled() && StringUtils.isNotBlank((String)user)) {
            execBuilder.withEnv("HADOOP_PROXY_USER", user);
        }
        this.runAbortableFakeYarnCommand(execBuilder, command);
    }

    public String fetchYarnJobUser(String yarnAppId) throws IOException, InterruptedException {
        if (StringUtils.isBlank((String)yarnAppId)) {
            return null;
        }
        ArrayList command = Lists.newArrayList((Object[])new String[]{"com.dataiku.dip.cli.internalcmd.ConfigurableYarnApplicationStatus", yarnAppId, JSON.json((Object)this.hadoopSettings.extraConf)});
        DKUtils.ByteCollectingSubscription cmdOutput = new DKUtils.ByteCollectingSubscription();
        DKUtils.ExecBuilder execBuilder = new DKUtils.ExecBuilder().withOutputConsumer((DKUtils.ExecSubscription)cmdOutput);
        this.runAbortableFakeYarnCommand(execBuilder, command);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(cmdOutput.getCollected())));){
            Pattern userDumPattern = Pattern.compile("^" + Pattern.quote("appReport.getUser() = ") + "(.*)$");
            String line = reader.readLine();
            while (line != null) {
                Matcher userDumMatcher = userDumPattern.matcher(line);
                if (userDumMatcher.matches()) {
                    String string = userDumMatcher.group(1);
                    return string;
                }
                line = reader.readLine();
            }
        }
        return null;
    }

    private void runAbortableFakeYarnCommand(DKUtils.ExecBuilder execBuilder, List<String> commandFromClassName) throws IOException, InterruptedException {
        DKUtils.AbortFromFutureKiller killer = new DKUtils.AbortFromFutureKiller();
        try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)killer);){
            ArrayList classPathChunks = Lists.newArrayList();
            classPathChunks.add(new File(ApplicationConfigurator.getInstallFolder(), "dist/*").getAbsolutePath());
            classPathChunks.add(new File(ApplicationConfigurator.getInstallFolder(), "lib/ivy/common-run/*").getAbsolutePath());
            if (StringUtils.isNotBlank((String)System.getenv("DKU_HADOOP_CP"))) {
                classPathChunks.add(System.getenv("DKU_HADOOP_CP"));
            }
            String classpath = Joiner.on((String)":").join((Iterable)classPathChunks);
            ArrayList command = Lists.newArrayList((Object[])new String[]{"java", "-cp", classpath});
            command.addAll(commandFromClassName);
            logger.info((Object)("Fetching yarn info with: " + Joiner.on((String)", ").join((Iterable)command)));
            execBuilder.withArgs((List)command).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withKiller((DKUtils.LazyInitExecKiller)killer);
            if (HadoopLoader.isKerberosLoginEnabled()) {
                HashMap krbVars = Maps.newHashMap();
                HadoopLoader.addTicketCacheEnvVar(krbVars);
                execBuilder.withEnv((Map)krbVars);
            }
            execBuilder.exec();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to fetch Yarn info", (Throwable)e);
        }
    }
}

