/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LicenseFeaturesStatusBuilder;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.CachedJSONFile;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.model.serverconfig.ActivityMonitoringSettings;
import com.dataiku.lambda.model.serverconfig.LambdaServerAdminAuthConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServerConfig;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class LambdaContext {
    CachedJSONFile<LambdaServerConfig> serverConfigFile = new CachedJSONFile(this.getFile("config/server.json"), LambdaServerConfig.class);
    CachedJSONFile<LambdaServerAdminAuthConfig> authConfigFile = new CachedJSONFile(this.getFile("config/adminkeys.json"), LambdaServerAdminAuthConfig.class);
    private AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus featureStatus;

    public abstract File getRootDir();

    public abstract MetricRegistry getRegistry();

    public abstract void setHealthChecksForService(String var1, Map<String, HealthCheck> var2);

    public abstract HealthCheckRegistry getHealthChecks();

    public LambdaServerConfig.AuditLog getAuditConfig() {
        try {
            return this.getMandatoryConfig().auditLog;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public void saveAuditConfig(LambdaServerConfig.AuditLog al) throws IOException {
        LambdaServerConfig config = this.getMandatoryConfig();
        config.auditLog = al;
        JSON.prettyToFile((Object)config, (File)this.getFile("config/server.json"));
        this.serverConfigFile.clear();
    }

    public boolean saveActivityMonitoringConfig(ActivityMonitoringSettings settings) throws IOException {
        LambdaServerConfig config = this.getMandatoryConfig();
        boolean activitySchedulingChanges = settings.getClass() != config.activityMonitoringSettings.getClass();
        ActivityMonitoringSettings copiedSettings = (ActivityMonitoringSettings)JSON.deepCopy((Object)settings);
        PasswordEncryptionService passwordEncryptionService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        copiedSettings.encryptFields(passwordEncryptionService);
        config.activityMonitoringSettings = copiedSettings;
        JSON.prettyToFile((Object)config, (File)this.getFile("config/server.json"));
        this.serverConfigFile.clear();
        return activitySchedulingChanges;
    }

    public File getFile(String ... chunks) {
        File f = this.getRootDir();
        for (String c2 : chunks) {
            f = new File(f, c2);
        }
        return f;
    }

    public AutoDelete getTempFolder(String path) throws IOException {
        if (ApplicationConfigurator.isDevLambdaServer()) {
            File tempDirectory = this.getFile("tmp", path + "-" + System.currentTimeMillis());
            try {
                DKUFileUtils.mkdirs((File)tempDirectory);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create temporary directory", e);
            }
            return new AutoDelete(tempDirectory);
        }
        return DSSTempUtils.getTempFolder((String)path);
    }

    public AutoDelete getTempFolder(String path, String prefix) throws IOException {
        if (ApplicationConfigurator.isDevLambdaServer()) {
            File tempDirectory = this.getFile("tmp", path, prefix);
            try {
                DKUFileUtils.mkdirs((File)tempDirectory);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create temporary directory", e);
            }
            return new AutoDelete(tempDirectory);
        }
        return DSSTempUtils.getTempFolder((String)path, (String)prefix);
    }

    public File getGlobalPythonCodeEnvFile() {
        return this.getGlobalCodeEnvFile("python");
    }

    public File getGlobalRCodeEnvFile() {
        return this.getGlobalCodeEnvFile("R");
    }

    public File getGlobalCodeEnvFile(String language) {
        return this.getFile("global-code-envs-cache", language);
    }

    public <T> T parseFile(Class<T> ofClass, String ... chunks) throws IOException {
        return (T)JSON.parseFile((File)this.getFile(chunks), ofClass);
    }

    public LambdaServerConfig getMandatoryConfig() throws IOException {
        LambdaServerConfig lsc = (LambdaServerConfig)this.serverConfigFile.getUnsafe();
        if (lsc == null) {
            throw new IllegalArgumentException("Failed to get server config. Most likely cause is that server.json is not valid JSON, does not exist or has bad permissions.");
        }
        return lsc;
    }

    @Nullable
    public LambdaServerConfig getConfigOrNull() throws IOException {
        return (LambdaServerConfig)this.serverConfigFile.getUnsafe();
    }

    public LambdaServerAdminAuthConfig getAuthConfig() throws IOException {
        return (LambdaServerAdminAuthConfig)this.authConfigFile.get();
    }

    public synchronized void checkMayRun() {
        this.fillLicenseCache();
        if (!this.featureStatus.apiNodeAllowed && !ApplicationConfigurator.isDevLambdaServer()) {
            throw new SecurityException("Your license does not cover usage of the API node. Please contact Dataiku");
        }
    }

    public synchronized boolean isDemoMode() {
        this.fillLicenseCache();
        return !this.featureStatus.apiNodeAllowed && ApplicationConfigurator.isDevLambdaServer();
    }

    private synchronized void fillLicenseCache() {
        if (this.featureStatus == null) {
            LicenseStatusService ls = (LicenseStatusService)SpringUtils.getBean(LicenseStatusService.class);
            this.featureStatus = LicenseFeaturesStatusBuilder.getFeaturesStatus(ls.getLicensingStatus());
        }
    }
}

