/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel;

import com.google.refine.grel.Control;
import com.google.refine.grel.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ControlFunctionRegistry {
    private final Map<String, Function> s_nameToFunction = new HashMap<String, Function>();
    private final Map<Function, String> s_functionToName = new HashMap<Function, String>();
    private final Map<String, Control> s_nameToControl = new HashMap<String, Control>();
    private final Map<Control, String> s_controlToName = new HashMap<Control, String>();

    public synchronized Function getFunction(String name) {
        return this.s_nameToFunction.get(name);
    }

    public synchronized String getFunctionName(Function f) {
        return this.s_functionToName.get(f);
    }

    public synchronized Set<Map.Entry<String, Function>> getFunctionMapping() {
        return this.s_nameToFunction.entrySet();
    }

    public synchronized Control getControl(String name) {
        return this.s_nameToControl.get(name);
    }

    public synchronized String getControlName(Control f) {
        return this.s_controlToName.get(f);
    }

    public synchronized Set<Map.Entry<String, Control>> getControlMapping() {
        return this.s_nameToControl.entrySet();
    }

    public synchronized void registerFunction(String name, Function f) {
        this.s_nameToFunction.put(name, f);
        this.s_functionToName.put(f, name);
    }

    public synchronized void registerControl(String name, Control c2) {
        this.s_nameToControl.put(name, c2);
        this.s_controlToName.put(c2, name);
    }

    public synchronized List<String> listFunctionAndControlNames() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(this.s_nameToFunction.keySet());
        ret.addAll(this.s_nameToControl.keySet());
        Collections.sort(ret);
        return ret;
    }
}

