/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel.controls;

import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.grel.Control;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class If
implements Control {
    @Override
    public String checkArguments(Evaluable[] args) {
        if (args.length != 3) {
            return GrelControlFunctionRegistry.getInstance().getControlName(this) + " expects 3 arguments";
        }
        return null;
    }

    @Override
    public Object call(Properties bindings, Evaluable[] args) {
        Object o = args[0].evaluate(bindings);
        if (ExpressionUtils.isError(o)) {
            return o;
        }
        if (ExpressionUtils.isTrue(o)) {
            return args[1].evaluate(bindings);
        }
        return args[2].evaluate(bindings);
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.If.DOCUMENTATION", "Evaluates to <code>expression_true</code> if the condition is true, to <code>expression_false</code> otherwise.").withParams("boolean condition, expression_true, expression_false").withReturns("GREL.FUNCTIONS.RETURNS.DEPENDS_ON_ARGUMENTS", "depends on arguments").withCategory("GREL.FUNCTIONS.CATEGORY.CONTROL_STRUCTURES", "Control structures").withExample(Example.with("3>2", "\"I heart #s\"", "\"my brain hurts\"").returns("\"I heart #s\""));
    }
}

