/*
 * Decompiled with CFR 0.152.
 */
package com.tlarsendataguy.yxdb;

import com.tlarsendataguy.yxdb.Extractors;
import com.tlarsendataguy.yxdb.MetaInfoField;
import com.tlarsendataguy.yxdb.YxdbField;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

class YxdbRecord {
    public final List<YxdbField> fields;
    public int fixedSize;
    public boolean hasVar;
    private final Map<String, Integer> nameToIndex;
    private final Map<Integer, Function<ByteBuffer, Boolean>> boolExtractors;
    private final Map<Integer, Function<ByteBuffer, Byte>> byteExtractors;
    private final Map<Integer, Function<ByteBuffer, Long>> longExtractors;
    private final Map<Integer, Function<ByteBuffer, Double>> doubleExtractors;
    private final Map<Integer, Function<ByteBuffer, String>> stringExtractors;
    private final Map<Integer, Function<ByteBuffer, LocalDate>> dateExtractors;
    private final Map<Integer, Function<ByteBuffer, LocalDateTime>> dateTimeExtractors;
    private final Map<Integer, Function<ByteBuffer, byte[]>> blobExtractors;

    private YxdbRecord(int fieldCount) {
        this.nameToIndex = new HashMap<String, Integer>(fieldCount);
        this.fields = new ArrayList<YxdbField>(fieldCount);
        this.boolExtractors = new HashMap<Integer, Function<ByteBuffer, Boolean>>(fieldCount);
        this.byteExtractors = new HashMap<Integer, Function<ByteBuffer, Byte>>(fieldCount);
        this.longExtractors = new HashMap<Integer, Function<ByteBuffer, Long>>(fieldCount);
        this.doubleExtractors = new HashMap<Integer, Function<ByteBuffer, Double>>(fieldCount);
        this.stringExtractors = new HashMap<Integer, Function<ByteBuffer, String>>(fieldCount);
        this.dateExtractors = new HashMap<Integer, Function<ByteBuffer, LocalDate>>(fieldCount);
        this.dateTimeExtractors = new HashMap<Integer, Function<ByteBuffer, LocalDateTime>>(fieldCount);
        this.blobExtractors = new HashMap<Integer, Function<ByteBuffer, byte[]>>(fieldCount);
    }

    static YxdbRecord newFromFieldList(List<MetaInfoField> fields) throws IllegalArgumentException {
        YxdbRecord record = new YxdbRecord(fields.size());
        int startAt = 0;
        block35: for (MetaInfoField field : fields) {
            switch (field.type()) {
                case "Int16": {
                    record.addLongExtractor(field.name(), Extractors.NewInt16Extractor(startAt));
                    startAt += 3;
                    continue block35;
                }
                case "Int32": {
                    record.addLongExtractor(field.name(), Extractors.NewInt32Extractor(startAt));
                    startAt += 5;
                    continue block35;
                }
                case "Int64": {
                    record.addLongExtractor(field.name(), Extractors.NewInt64Extractor(startAt));
                    startAt += 9;
                    continue block35;
                }
                case "Float": {
                    record.addDoubleExtractor(field.name(), Extractors.NewFloatExtractor(startAt));
                    startAt += 5;
                    continue block35;
                }
                case "Double": {
                    record.addDoubleExtractor(field.name(), Extractors.NewDoubleExtractor(startAt));
                    startAt += 9;
                    continue block35;
                }
                case "FixedDecimal": {
                    int size = field.size();
                    record.addDoubleExtractor(field.name(), Extractors.NewFixedDecimalExtractor(startAt, size));
                    startAt += size + 1;
                    continue block35;
                }
                case "String": {
                    int size = field.size();
                    record.addStringExtractor(field.name(), Extractors.NewStringExtractor(startAt, size));
                    startAt += size + 1;
                    continue block35;
                }
                case "WString": {
                    int size = field.size();
                    record.addStringExtractor(field.name(), Extractors.NewWStringExtractor(startAt, size));
                    startAt += size * 2 + 1;
                    continue block35;
                }
                case "V_String": {
                    record.addStringExtractor(field.name(), Extractors.NewV_StringExtractor(startAt));
                    startAt += 4;
                    record.hasVar = true;
                    continue block35;
                }
                case "V_WString": {
                    record.addStringExtractor(field.name(), Extractors.NewV_WStringExtractor(startAt));
                    startAt += 4;
                    record.hasVar = true;
                    continue block35;
                }
                case "Date": {
                    record.addDateExtractor(field.name(), Extractors.NewDateExtractor(startAt), Extractors.NewDateAsStringExtractor(startAt));
                    startAt += 11;
                    continue block35;
                }
                case "DateTime": {
                    record.addDateTimeExtractor(field.name(), Extractors.NewDateTimeExtractor(startAt), Extractors.NewDateTimeAsStringExtractor(startAt));
                    startAt += 20;
                    continue block35;
                }
                case "Bool": {
                    record.addBooleanExtractor(field.name(), Extractors.NewBoolExtractor(startAt));
                    ++startAt;
                    continue block35;
                }
                case "Byte": {
                    record.addByteExtractor(field.name(), Extractors.NewByteExtractor(startAt));
                    startAt += 2;
                    continue block35;
                }
                case "Blob": 
                case "SpatialObj": {
                    record.addBlobExtractor(field.name(), Extractors.NewBlobExtractor(startAt));
                    startAt += 4;
                    record.hasVar = true;
                    continue block35;
                }
            }
            throw new IllegalArgumentException("field type is invalid");
        }
        record.fixedSize = startAt;
        return record;
    }

    public Long extractLongFrom(int index, ByteBuffer buffer) {
        Function<ByteBuffer, Long> extractor = this.longExtractors.get(index);
        if (extractor == null) {
            YxdbRecord.throwInvalidIndex(index, "long integer");
        }
        return extractor.apply(buffer);
    }

    public Long extractLongFrom(String name, ByteBuffer buffer) {
        Integer index = this.nameToIndex.get(name);
        if (index == null) {
            YxdbRecord.throwInvalidName(name);
        }
        return this.extractLongFrom(index, buffer);
    }

    public Double extractDoubleFrom(int index, ByteBuffer buffer) {
        Function<ByteBuffer, Double> extractor = this.doubleExtractors.get(index);
        if (extractor == null) {
            YxdbRecord.throwInvalidIndex(index, "numeric");
        }
        return extractor.apply(buffer);
    }

    public Double extractDoubleFrom(String name, ByteBuffer buffer) {
        Integer index = this.nameToIndex.get(name);
        if (index == null) {
            YxdbRecord.throwInvalidName(name);
        }
        return this.extractDoubleFrom(index, buffer);
    }

    public String extractStringFrom(int index, ByteBuffer buffer) {
        Function<ByteBuffer, String> extractor = this.stringExtractors.get(index);
        if (extractor == null) {
            YxdbRecord.throwInvalidIndex(index, "text");
        }
        return extractor.apply(buffer);
    }

    public String extractStringFrom(String name, ByteBuffer buffer) {
        Integer index = this.nameToIndex.get(name);
        if (index == null) {
            YxdbRecord.throwInvalidName(name);
        }
        return this.extractStringFrom(index, buffer);
    }

    public LocalDate extractDateFrom(int index, ByteBuffer buffer) {
        Function<ByteBuffer, LocalDate> extractor = this.dateExtractors.get(index);
        if (extractor == null) {
            YxdbRecord.throwInvalidIndex(index, "text");
        }
        return extractor.apply(buffer);
    }

    public LocalDate extractDateFrom(String name, ByteBuffer buffer) {
        Integer index = this.nameToIndex.get(name);
        if (index == null) {
            YxdbRecord.throwInvalidName(name);
        }
        return this.extractDateFrom(index, buffer);
    }

    public LocalDateTime extractDateTimeFrom(int index, ByteBuffer buffer) {
        Function<ByteBuffer, LocalDateTime> extractor = this.dateTimeExtractors.get(index);
        if (extractor == null) {
            YxdbRecord.throwInvalidIndex(index, "text");
        }
        return extractor.apply(buffer);
    }

    public LocalDateTime extractDateTimeFrom(String name, ByteBuffer buffer) {
        Integer index = this.nameToIndex.get(name);
        if (index == null) {
            YxdbRecord.throwInvalidName(name);
        }
        return this.extractDateTimeFrom(index, buffer);
    }

    public Boolean extractBooleanFrom(int index, ByteBuffer buffer) {
        Function<ByteBuffer, Boolean> extractor = this.boolExtractors.get(index);
        if (extractor == null) {
            YxdbRecord.throwInvalidIndex(index, "boolean");
        }
        return extractor.apply(buffer);
    }

    public Boolean extractBooleanFrom(String name, ByteBuffer buffer) {
        Integer index = this.nameToIndex.get(name);
        if (index == null) {
            YxdbRecord.throwInvalidName(name);
        }
        return this.extractBooleanFrom(index, buffer);
    }

    public Byte extractByteFrom(int index, ByteBuffer buffer) {
        Function<ByteBuffer, Byte> extractor = this.byteExtractors.get(index);
        if (extractor == null) {
            YxdbRecord.throwInvalidIndex(index, "byte");
        }
        return extractor.apply(buffer);
    }

    public Byte extractByteFrom(String name, ByteBuffer buffer) {
        Integer index = this.nameToIndex.get(name);
        if (index == null) {
            YxdbRecord.throwInvalidName(name);
        }
        return this.extractByteFrom(index, buffer);
    }

    public byte[] extractBlobFrom(int index, ByteBuffer buffer) {
        Function<ByteBuffer, byte[]> extractor = this.blobExtractors.get(index);
        if (extractor == null) {
            YxdbRecord.throwInvalidIndex(index, "blob");
        }
        return extractor.apply(buffer);
    }

    public byte[] extractBlobFrom(String name, ByteBuffer buffer) {
        Integer index = this.nameToIndex.get(name);
        if (index == null) {
            YxdbRecord.throwInvalidName(name);
        }
        return this.extractBlobFrom(index, buffer);
    }

    private void addLongExtractor(String name, Function<ByteBuffer, Long> extractor) {
        int index = this.addFieldNameToIndexMap(name, YxdbField.DataType.LONG);
        this.longExtractors.put(index, extractor);
    }

    private void addDoubleExtractor(String name, Function<ByteBuffer, Double> extractor) {
        int index = this.addFieldNameToIndexMap(name, YxdbField.DataType.DOUBLE);
        this.doubleExtractors.put(index, extractor);
    }

    private void addStringExtractor(String name, Function<ByteBuffer, String> extractor) {
        int index = this.addFieldNameToIndexMap(name, YxdbField.DataType.STRING);
        this.stringExtractors.put(index, extractor);
    }

    private void addDateExtractor(String name, Function<ByteBuffer, LocalDate> dateExtractor, Function<ByteBuffer, String> stringExtractor) {
        int index = this.addFieldNameToIndexMap(name, YxdbField.DataType.DATE);
        this.dateExtractors.put(index, dateExtractor);
        this.stringExtractors.put(index, stringExtractor);
    }

    private void addDateTimeExtractor(String name, Function<ByteBuffer, LocalDateTime> dateTimeExtractor, Function<ByteBuffer, String> stringExtractor) {
        int index = this.addFieldNameToIndexMap(name, YxdbField.DataType.DATETIME);
        this.dateTimeExtractors.put(index, dateTimeExtractor);
        this.stringExtractors.put(index, stringExtractor);
    }

    private void addBooleanExtractor(String name, Function<ByteBuffer, Boolean> extractor) {
        int index = this.addFieldNameToIndexMap(name, YxdbField.DataType.BOOLEAN);
        this.boolExtractors.put(index, extractor);
    }

    private void addByteExtractor(String name, Function<ByteBuffer, Byte> extractor) {
        int index = this.addFieldNameToIndexMap(name, YxdbField.DataType.BYTE);
        this.byteExtractors.put(index, extractor);
    }

    private void addBlobExtractor(String name, Function<ByteBuffer, byte[]> extractor) {
        int index = this.addFieldNameToIndexMap(name, YxdbField.DataType.BLOB);
        this.blobExtractors.put(index, extractor);
    }

    private int addFieldNameToIndexMap(String name, YxdbField.DataType type) {
        int index = this.fields.size();
        this.fields.add(new YxdbField(name, type));
        this.nameToIndex.put(name, index);
        return index;
    }

    private static void throwInvalidIndex(int index, String expectedType) throws IllegalArgumentException {
        throw new IllegalArgumentException("index " + index + " is not a valid index or is not a " + expectedType + " field");
    }

    private static void throwInvalidName(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException("field " + name + " does not exist");
    }
}

