/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.governance;

import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.governance.AutoGovernanceAction;
import com.dataiku.gh.core.models.governance.AutoGovernanceStatus;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.Objects;
import javax.annotation.Nullable;

@UIModel
public class AutoGovernanceConfiguration {
    public AutoGovernanceAction action = AutoGovernanceAction.DO_NOTHING;
    @Nullable
    public AutoGovernanceStatus status = AutoGovernanceStatus.AUTO;
    @Nullable
    public BlueprintVersionId blueprintVersionId;

    public static AutoGovernanceConfiguration buildDoNothing() {
        return AutoGovernanceConfiguration.build(AutoGovernanceAction.DO_NOTHING, null);
    }

    public static AutoGovernanceConfiguration buildScriptTriggered() {
        return AutoGovernanceConfiguration.build(AutoGovernanceAction.RUN_SCRIPT, null);
    }

    public static AutoGovernanceConfiguration buildInherited() {
        return AutoGovernanceConfiguration.build(AutoGovernanceAction.INHERIT, null);
    }

    public static AutoGovernanceConfiguration buildHidden(boolean automatic) {
        return AutoGovernanceConfiguration.build(AutoGovernanceAction.HIDE, automatic ? AutoGovernanceStatus.AUTO : AutoGovernanceStatus.SUGGESTED, null);
    }

    public static AutoGovernanceConfiguration build(AutoGovernanceAction action, BlueprintVersionId blueprintVersionId) {
        AutoGovernanceConfiguration autoGovernanceConfiguration = new AutoGovernanceConfiguration();
        autoGovernanceConfiguration.action = action;
        autoGovernanceConfiguration.blueprintVersionId = blueprintVersionId;
        return autoGovernanceConfiguration;
    }

    public static AutoGovernanceConfiguration build(AutoGovernanceAction action, AutoGovernanceStatus status, BlueprintVersionId blueprintVersionId) {
        AutoGovernanceConfiguration autoGovernanceConfiguration = AutoGovernanceConfiguration.build(action, blueprintVersionId);
        autoGovernanceConfiguration.status = status;
        return autoGovernanceConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoGovernanceConfiguration that = (AutoGovernanceConfiguration)o;
        return this.action == that.action && this.status == that.status && Objects.equals(this.blueprintVersionId, that.blueprintVersionId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.status, this.blueprintVersionId});
    }

    public String toString() {
        return "AutoGovernanceConfiguration{action=" + String.valueOf((Object)this.action) + ", status=" + String.valueOf((Object)this.status) + ", blueprintVersionId=" + String.valueOf(this.blueprintVersionId) + "}";
    }
}

