/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionExport;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionStatus;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.security.UsersContainersValidationConfig;
import com.dataiku.gh.core.models.ui.UIBlueprintVersion;
import com.dataiku.gh.core.services.blueprints.IAdminBlueprintsService;
import com.dataiku.gh.core.services.import_export.IExportedEntityMigrationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.security.auth.MetaAuthService;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIAdminBlueprintVersionsController
extends PublicAPIControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IExportedEntityMigrationService importExportMigrationService;
    @Autowired
    private IAdminBlueprintsService adminBlueprintsService;

    @AuditedCall(value={"msgType", "admin-blueprint-versions-list", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/publicapi/admin/blueprint/{blueprintId}/versions"}, method={RequestMethod.GET})
    @ResponseBody
    public List<UIBlueprintVersion> list(HttpServletRequest req, @PathVariable String blueprintId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        return this.adminBlueprintsService.listBlueprintVersionsByBlueprint(authCtx, blueprintId);
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/blueprint/{blueprintId}/versions"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.BLUEPRINT_VERSION_CREATE)
    @ResponseBody
    public UIBlueprintVersion create(HttpServletRequest req, @PathVariable String blueprintId, @RequestParam String newIdentifier, @RequestParam(required=false) String name, @RequestParam(required=false) String originVersionId) throws Exception {
        try {
            AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            UIBlueprintVersion uiBlueprintVersion = this.adminBlueprintsService.createBlueprintVersion(authCtx, blueprintId, newIdentifier, name, originVersionId);
            this.auditTrailService.generic("admin-blueprint-version-create").with("blueprintId", uiBlueprintVersion.blueprintVersion.id.blueprintId).with("versionId", uiBlueprintVersion.blueprintVersion.id.versionId).emit();
            return uiBlueprintVersion;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-version-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "admin-blueprint-version-get", "blueprintId", "${blueprintId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/publicapi/admin/blueprint/{blueprintId}/version/{versionId}"}, method={RequestMethod.GET})
    @ResponseBody
    public UIBlueprintVersion get(HttpServletRequest req, @PathVariable String blueprintId, @PathVariable String versionId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        return this.adminBlueprintsService.getBlueprintVersion(authCtx, BlueprintVersionId.build(blueprintId, versionId));
    }

    @AuditedCall(value={"msgType", "admin-blueprint-version-save", "blueprintId", "${blueprintId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/publicapi/admin/blueprint/{blueprintId}/version/{versionId}"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.BLUEPRINT_VERSION_SAVE)
    @ResponseBody
    public UIBlueprintVersion save(HttpServletRequest req, @PathVariable String blueprintId, @PathVariable String versionId, @RequestParam(required=false) Boolean dangerZoneAccepted) throws Exception {
        BlueprintVersion bv = (BlueprintVersion)this.getRequestBodyAs(req, BlueprintVersion.class);
        if (bv.id != null && !StringUtils.equals((CharSequence)blueprintId, (CharSequence)bv.id.blueprintId)) {
            throw new ValidationException("Blueprint IDs do not match: " + blueprintId + " , " + bv.id.blueprintId);
        }
        if (bv.id != null && !StringUtils.equals((CharSequence)versionId, (CharSequence)bv.id.versionId)) {
            throw new ValidationException("Blueprint version IDs do not match: " + versionId + " , " + bv.id.versionId);
        }
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        return this.adminBlueprintsService.saveBlueprintVersion(authCtx, bv, Boolean.TRUE.equals(dangerZoneAccepted));
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/blueprint/{blueprintId}/version/{versionId}/status"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.BLUEPRINT_VERSION_STATUS_UPDATE)
    @ResponseBody
    public UIBlueprintVersion updateStatus(HttpServletRequest req, @PathVariable String blueprintId, @PathVariable String versionId) throws Exception {
        try {
            BlueprintVersionStatus bvs = (BlueprintVersionStatus)((Object)this.getRequestBodyAs(req, BlueprintVersionStatus.class));
            AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            UIBlueprintVersion uiBlueprintVersion = this.adminBlueprintsService.updateBlueprintVersionStatus(authCtx, BlueprintVersionId.build(blueprintId, versionId), bvs);
            this.auditTrailService.generic("admin-blueprint-version-update-status").with("blueprintId", blueprintId).with("versionId", versionId).emit();
            return uiBlueprintVersion;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-version-update-status", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "admin-blueprint-version-delete", "blueprintId", "${blueprintId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/publicapi/admin/blueprint/{blueprintId}/version/{versionId}"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.BLUEPRINT_VERSION_DELETE)
    @ResponseBody
    public void delete(HttpServletRequest req, @PathVariable String blueprintId, @PathVariable String versionId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        this.adminBlueprintsService.deleteBlueprintVersion(authCtx, BlueprintVersionId.build(blueprintId, versionId));
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/blueprint/{blueprintId}/versions/import"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.BLUEPRINT_VERSION_IMPORT)
    @ResponseBody
    public UIBlueprintVersion importVersion(HttpServletRequest req, @PathVariable String blueprintId, @RequestParam(required=false) Boolean ignoreOriginVersionErrors, @RequestParam(required=false) UsersContainersValidationConfig.ValidationBehavior signoffImportRoles, @RequestParam(required=false) BlueprintVersionExport.MigrationPathImportBehavior migrationPathImportBehavior) throws Exception {
        try {
            AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            JsonObject bpWithOriginVersionJson = (JsonObject)this.getRequestBodyAs(req, JsonObject.class);
            BlueprintVersionExport bpWithOriginVersion = this.importExportMigrationService.unwrapAndMigrateExportedEntity(bpWithOriginVersionJson, BlueprintVersionExport.class);
            if (bpWithOriginVersion != null && bpWithOriginVersion.blueprintVersion != null && bpWithOriginVersion.blueprintVersion.id != null && bpWithOriginVersion.blueprintVersion.id.blueprintId != null && !StringUtils.equals((CharSequence)blueprintId, (CharSequence)bpWithOriginVersion.blueprintVersion.id.blueprintId)) {
                throw new ValidationException("Blueprint IDs do not match: " + blueprintId + " , " + bpWithOriginVersion.blueprintVersion.id.blueprintId);
            }
            UIBlueprintVersion uiBlueprintVersion = this.adminBlueprintsService.importBlueprintVersion(authCtx, bpWithOriginVersion, Boolean.TRUE.equals(ignoreOriginVersionErrors), Optional.ofNullable(signoffImportRoles).orElse(UsersContainersValidationConfig.ValidationBehavior.ALL), Optional.ofNullable(migrationPathImportBehavior).orElse(BlueprintVersionExport.MigrationPathImportBehavior.FAIL_IMPORT_ON_EXISTING_MIGRATION_OR_MISSING_VERSION));
            this.auditTrailService.generic("admin-blueprint-version-import").with("blueprintId", uiBlueprintVersion.blueprintVersion.id.blueprintId).with("versionId", uiBlueprintVersion.blueprintVersion.id.versionId).emit();
            return uiBlueprintVersion;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-version-import", (Throwable)e).emit();
            throw e;
        }
    }
}

