/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.signoff.SignoffConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffConfigurationId;
import com.dataiku.gh.core.services.signoff.IAdminBlueprintVersionSignoffConfigurationsService;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.dataiku.gh.security.auth.MetaAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIAdminSignoffConfigurationsController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IAdminBlueprintVersionSignoffConfigurationsService adminBlueprintVersionSignoffConfigurationsService;

    @AuditedCall(value={"msgType", "admin-signoff-configurations-list", "blueprintId", "${blueprintId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/publicapi/admin/blueprint/{blueprintId}/version/{versionId}/signoffs"}, method={RequestMethod.GET})
    @ResponseBody
    public List<SignoffConfiguration> list(HttpServletRequest req, HttpServletResponse resp, @PathVariable String blueprintId, @PathVariable String versionId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        BlueprintVersionId blueprintVersionId = BlueprintVersionId.build(blueprintId, versionId);
        return this.adminBlueprintVersionSignoffConfigurationsService.getBlueprintVersionSignoffsConfigurations(authCtx, blueprintVersionId);
    }

    @AuditedCall(value={"msgType", "admin-signoff-configuration-get", "blueprintId", "${blueprintId}", "versionId", "${versionId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/publicapi/admin/blueprint/{blueprintId}/version/{versionId}/workflow/step/{stepId}/signoff"}, method={RequestMethod.GET})
    @ResponseBody
    public SignoffConfiguration get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String blueprintId, @PathVariable String versionId, @PathVariable String stepId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        SignoffConfigurationId signoffConfigurationId = SignoffConfigurationId.build(BlueprintVersionId.build(blueprintId, versionId), stepId);
        return this.adminBlueprintVersionSignoffConfigurationsService.getSignoffConfiguration(authCtx, signoffConfigurationId);
    }

    @AuditedCall(value={"msgType", "admin-signoff-configuration-create", "blueprintId", "${blueprintId}", "versionId", "${versionId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/publicapi/admin/blueprint/{blueprintId}/version/{versionId}/workflow/step/{stepId}/signoff"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SIGNOFF_CONFIGURATIONS_CREATE)
    @ResponseBody
    public SignoffConfiguration create(HttpServletRequest req, HttpServletResponse resp, @PathVariable String blueprintId, @PathVariable String versionId, @PathVariable String stepId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        SignoffConfiguration signoffConfiguration = (SignoffConfiguration)this.getRequestBodyAs(req, SignoffConfiguration.class);
        ValidatorUtils.validateThat(signoffConfiguration != null, "signoffConfiguration is mandatory", new Object[0]);
        ValidatorUtils.validateThat(signoffConfiguration.id == null, "signoffConfiguration.id must not be set in creation", new Object[0]);
        signoffConfiguration.id = SignoffConfigurationId.build(BlueprintVersionId.build(blueprintId, versionId), stepId);
        return this.adminBlueprintVersionSignoffConfigurationsService.createSignoffConfiguration(authCtx, signoffConfiguration);
    }

    @AuditedCall(value={"msgType", "admin-signoff-configuration-save", "blueprintId", "${blueprintId}", "versionId", "${versionId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/publicapi/admin/blueprint/{blueprintId}/version/{versionId}/workflow/step/{stepId}/signoff"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.SIGNOFF_CONFIGURATIONS_SAVE)
    @ResponseBody
    public SignoffConfiguration save(HttpServletRequest req, HttpServletResponse resp, @PathVariable String blueprintId, @PathVariable String versionId, @PathVariable String stepId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        SignoffConfiguration signoffConfiguration = (SignoffConfiguration)this.getRequestBodyAs(req, SignoffConfiguration.class);
        ValidatorUtils.validateThat(signoffConfiguration != null, "signoffConfiguration is mandatory", new Object[0]);
        if (signoffConfiguration.id != null) {
            ValidatorUtils.validateThat(signoffConfiguration.id.blueprintVersionId != null, "signoffConfiguration.id.blueprintVersionId is mandatory", new Object[0]);
            ValidatorUtils.validateThat(Objects.equals(signoffConfiguration.id.blueprintVersionId.blueprintId, blueprintId), "blueprintIds in URL and Body don't match", new Object[0]);
            ValidatorUtils.validateThat(Objects.equals(signoffConfiguration.id.blueprintVersionId.versionId, versionId), "versionIds in URL and Body don't match", new Object[0]);
            ValidatorUtils.validateThat(Objects.equals(signoffConfiguration.id.stepId, stepId), "stepIds in URL and Body don't match", new Object[0]);
        } else {
            signoffConfiguration.id = SignoffConfigurationId.build(BlueprintVersionId.build(blueprintId, versionId), stepId);
        }
        return this.adminBlueprintVersionSignoffConfigurationsService.saveSignoffConfiguration(authCtx, signoffConfiguration);
    }

    @AuditedCall(value={"msgType", "admin-signoff-configuration-delete", "blueprintId", "${blueprintId}", "versionId", "${versionId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/publicapi/admin/blueprint/{blueprintId}/version/{versionId}/workflow/step/{stepId}/signoff"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.SIGNOFF_CONFIGURATIONS_DELETE)
    @ResponseBody
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String blueprintId, @PathVariable String versionId, @PathVariable String stepId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        this.adminBlueprintVersionSignoffConfigurationsService.deleteSignoffConfiguration(authCtx, SignoffConfigurationId.build(BlueprintVersionId.build(blueprintId, versionId), stepId));
    }
}

