/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin.migrations;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.admin.MigrationFile;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.services.admin.migrations.Migration;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationEntitiesUtilsBetweenV13300AndBeyond;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationJsonUtils;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.springframework.jdbc.core.JdbcTemplate;

public class MigrationV13500
extends Migration {
    private static final String[] BPV_BLUEPRINT_IDS = new String[]{"dataiku_project", "dataiku_dataset", "dataiku_saved_model", "dataiku_retrievable_knowledge"};
    private Map<BlueprintVersionId, List<String>> bpvWorkflowCache;
    private HistoryCache bpvHistoryCache;
    private Long actionId;

    private Long getMigrationActionId(IDBMigrationDAO dbMigrationDAO, long migrationTS) throws IOException {
        if (this.actionId == null) {
            this.actionId = MigrationEntitiesUtilsBetweenV13300AndBeyond.createMigrationAction(dbMigrationDAO.getJdbcTemplate(), migrationTS);
        }
        return this.actionId;
    }

    @Override
    protected void updateProvidedSystemObjects(IDBMigrationDAO dbMigrationDAO, @Nullable File providedObjectsFolder) throws IOException {
        JdbcTemplate jdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        long migrationTS = this.getMigrationTimestamp();
        long actionId = this.getMigrationActionId(dbMigrationDAO, migrationTS);
        for (String bpvBlueprintId : BPV_BLUEPRINT_IDS) {
            MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{bpvBlueprintId, "blueprint_version_default.json"}), "bp.system." + bpvBlueprintId, "bv.system.default", actionId, migrationTS);
        }
    }

    @Override
    protected void postRunSQLFiles(IDBMigrationDAO dbMigrationDAO, List<MigrationFile> migrationFiles) throws IOException {
        this.migrateArtifactsWorkflow(dbMigrationDAO);
        this.migrateArtifactWorkflowHistory(dbMigrationDAO);
        MigrationV13500.updateInstanceAutoGovernanceConfiguration(dbMigrationDAO.getJdbcTemplate(), "govern_configuration");
        MigrationV13500.updateInstanceAutoGovernanceConfiguration(dbMigrationDAO.getJdbcTemplate(), "govern_configuration_history");
    }

    private void migrateArtifactsWorkflow(IDBMigrationDAO dbMigrationDAO) throws IOException {
        this.bpvWorkflowCache = this.getBPVWorkflowCache(dbMigrationDAO);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.migrateObjectsStructure(dbMigrationDAO.getJdbcTemplate(), "artifacts", "artifact_id=?", "artifact_json", null, null, artifact -> Collections.singletonList(MigrationJsonUtils.getStringSubpath((JsonElement)artifact, "id").orElse(null)), this::migrateArtifact);
    }

    private JsonObject migrateArtifact(JsonObject jsonObject) {
        BlueprintVersionId blueprintVersionId = BlueprintVersionId.build(jsonObject.getAsJsonObject("blueprintVersionId").get("blueprintId").getAsString(), jsonObject.getAsJsonObject("blueprintVersionId").get("versionId").getAsString());
        List<String> stepsDefinitions = this.bpvWorkflowCache.get(blueprintVersionId);
        JsonObject workflow = new JsonObject();
        JsonObject workflowSteps = this.buildWorkflowSteps(jsonObject, stepsDefinitions);
        workflow.add("steps", (JsonElement)workflowSteps);
        jsonObject.add("workflow", (JsonElement)workflow);
        return jsonObject;
    }

    private JsonObject buildWorkflowSteps(JsonObject artifact, @Nullable List<String> blueprintVersionWorkflowSteps) {
        JsonElement stepIdElement;
        JsonObject status;
        JsonObject workflowSteps = new JsonObject();
        if (blueprintVersionWorkflowSteps != null && !blueprintVersionWorkflowSteps.isEmpty() && (status = artifact.getAsJsonObject("status")) != null && (stepIdElement = status.get("stepId")) != null) {
            String stepId = stepIdElement.getAsString();
            boolean ongoingFound = false;
            for (String stepDefinition : blueprintVersionWorkflowSteps) {
                JsonObject stepObject = new JsonObject();
                if (ongoingFound) {
                    stepObject.addProperty("status", "NOT_STARTED");
                    stepObject.addProperty("visible", Boolean.valueOf(true));
                    workflowSteps.add(stepDefinition, (JsonElement)stepObject);
                    continue;
                }
                if (stepDefinition.equals(stepId)) {
                    stepObject.addProperty("status", "ONGOING");
                    stepObject.addProperty("visible", Boolean.valueOf(true));
                    workflowSteps.add(stepDefinition, (JsonElement)stepObject);
                    ongoingFound = true;
                    continue;
                }
                stepObject.addProperty("status", "FINISHED");
                stepObject.addProperty("visible", Boolean.valueOf(true));
                workflowSteps.add(stepDefinition, (JsonElement)stepObject);
            }
        }
        return workflowSteps;
    }

    private Map<BlueprintVersionId, List<String>> getBPVWorkflowCache(IDBMigrationDAO dbMigrationDAO) {
        HashMap<BlueprintVersionId, List<String>> workflowDefinitionCache = new HashMap<BlueprintVersionId, List<String>>();
        String sqlSelectAll = "SELECT * FROM blueprint_versions";
        try (Stream bpvs = dbMigrationDAO.getJdbcTemplate().queryForStream(sqlSelectAll, (rs, rowNum) -> (JsonObject)JSON.parse((String)rs.getString("blueprint_version_json"), JsonObject.class));){
            bpvs.forEach(bpv -> {
                JsonArray stepDefinitions;
                BlueprintVersionId blueprintVersionId = BlueprintVersionId.build(MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "blueprintId").orElse(""), MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "versionId").orElse(""));
                ArrayList steps = new ArrayList();
                JsonObject workflowDefinition = bpv.getAsJsonObject("workflowDefinition");
                if (workflowDefinition != null && (stepDefinitions = workflowDefinition.getAsJsonArray("stepDefinitions")) != null) {
                    stepDefinitions.forEach(sd -> steps.add(sd.getAsJsonObject().get("id").getAsString()));
                }
                workflowDefinitionCache.put(blueprintVersionId, steps);
            });
        }
        return workflowDefinitionCache;
    }

    private void migrateArtifactWorkflowHistory(IDBMigrationDAO dbMigrationDAO) throws IOException {
        this.bpvHistoryCache = this.getBPVHistoryWorkflowCache(dbMigrationDAO);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.migrateObjectsStructureHistoryAtTimestamp(dbMigrationDAO.getJdbcTemplate(), "artifacts_history", "artifact_json", null, this::migrateArtifactHistory);
    }

    private JsonObject migrateArtifactHistory(MigrationEntitiesUtilsBetweenV13300AndBeyond.JSONObjectAtTimestamp jsonObjectAtTimestamp) {
        Timestamp timestamp = jsonObjectAtTimestamp.timestamp;
        JsonObject jsonObject = jsonObjectAtTimestamp.jsonObject;
        BlueprintVersionId blueprintVersionId = BlueprintVersionId.build(MigrationJsonUtils.getStringSubpath((JsonElement)jsonObject, "blueprintVersionId", "blueprintId").orElse(""), MigrationJsonUtils.getStringSubpath((JsonElement)jsonObject, "blueprintVersionId", "versionId").orElse(""));
        List<String> workflowAtTimestamp = this.bpvHistoryCache.getWorkflowAtTimestamp(blueprintVersionId, timestamp);
        JsonObject workflowSteps = this.buildWorkflowSteps(jsonObject, workflowAtTimestamp);
        JsonObject workflow = new JsonObject();
        workflow.add("steps", (JsonElement)workflowSteps);
        jsonObject.add("workflow", (JsonElement)workflow);
        return jsonObject;
    }

    private HistoryCache getBPVHistoryWorkflowCache(IDBMigrationDAO dbMigrationDAO) {
        HashMap<BlueprintVersionId, TreeMap<Timestamp, List<String>>> cache = new HashMap<BlueprintVersionId, TreeMap<Timestamp, List<String>>>();
        String sqlSelectAll = "SELECT * FROM blueprint_versions_history";
        try (Stream bpvs = dbMigrationDAO.getJdbcTemplate().queryForStream(sqlSelectAll, (rs, rowNum) -> MigrationEntitiesUtilsBetweenV13300AndBeyond.JSONObjectAtTimestamp.build((JsonObject)JSON.parse((String)rs.getString("blueprint_version_json"), JsonObject.class), rs.getTimestamp("_revision_timestamp")));){
            bpvs.forEach(bpv -> {
                JsonArray stepDefinitions;
                BlueprintVersionId blueprintVersionId = BlueprintVersionId.build(MigrationJsonUtils.getStringSubpath((JsonElement)bpv.jsonObject, "id", "blueprintId").orElse(""), MigrationJsonUtils.getStringSubpath((JsonElement)bpv.jsonObject, "id", "versionId").orElse(""));
                ArrayList steps = new ArrayList();
                JsonObject workflowDefinition = bpv.jsonObject.getAsJsonObject("workflowDefinition");
                if (workflowDefinition != null && (stepDefinitions = workflowDefinition.getAsJsonArray("stepDefinitions")) != null) {
                    stepDefinitions.forEach(sd -> steps.add(sd.getAsJsonObject().get("id").getAsString()));
                }
                cache.computeIfAbsent(blueprintVersionId, bpvId -> new TreeMap()).put(bpv.timestamp, steps);
            });
        }
        return HistoryCache.build(cache);
    }

    private static void updateInstanceAutoGovernanceConfiguration(JdbcTemplate jdbcTemplate, String tableName) {
        jdbcTemplate.update(String.format("UPDATE %s\nSET configuration_item_json = jsonb_set(\nconfiguration_item_json - 'instanceConfiguration',\n'{instanceAutoGovernanceConfiguration}',\n(configuration_item_json -> 'instanceConfiguration') ||\n'{\"projectsConfig\": {\"status\": \"DISABLED\"}, \"type\": \"instance\"}'::jsonb)\nWHERE configuration_item_id = 'default-autogovern'", tableName));
    }

    private static class HistoryCache {
        Map<BlueprintVersionId, TreeMap<Timestamp, List<String>>> cache;

        private HistoryCache() {
        }

        static HistoryCache build(Map<BlueprintVersionId, TreeMap<Timestamp, List<String>>> cache) {
            HistoryCache historyCache = new HistoryCache();
            historyCache.cache = cache;
            return historyCache;
        }

        @Nullable
        List<String> getWorkflowAtTimestamp(BlueprintVersionId blueprintVersionId, Timestamp timestamp) {
            TreeMap<Timestamp, List<String>> versionsAtTimestamp = this.cache.get(blueprintVersionId);
            Timestamp closestTimestamp = (Timestamp)versionsAtTimestamp.headMap(timestamp, true).lastKey();
            if (closestTimestamp == null) {
                return null;
            }
            return versionsAtTimestamp.get(closestTimestamp);
        }
    }
}

