/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.import_export.configs;

import com.dataiku.gh.core.models.blueprints.BlueprintExport;
import com.dataiku.gh.core.services.admin.migrations.MigrationV13300;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationJsonUtils;
import com.dataiku.gh.core.services.import_export.ExportedEntityMigrationService;
import com.dataiku.gh.core.services.import_export.IExportedEntityMigrationConfigService;
import com.dataiku.gh.core.services.import_export.configs.BlueprintVersionMigrationConfigurationService;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BlueprintWithVersionsMigrationConfigurationService
implements IExportedEntityMigrationConfigService {
    @Autowired
    BlueprintVersionMigrationConfigurationService blueprintVersionImportConfigurationService;

    @Override
    public Class<?> getTargetClass() {
        return BlueprintExport.class;
    }

    @Override
    public Map<Long, ExportedEntityMigrationService.EntityMigration> getMigrationSteps() {
        return ImmutableMap.builder().put((Object)12200L, BlueprintWithVersionsMigrationConfigurationService::migrateBlueprintWithVersionsToV12200).put((Object)12400L, BlueprintWithVersionsMigrationConfigurationService::migrateBlueprintExportToV12400).put((Object)13300L, this::migrateBlueprintExportToV13300).put((Object)13400L, BlueprintWithVersionsMigrationConfigurationService::migrateBlueprintExportToV13400).put((Object)14000L, BlueprintWithVersionsMigrationConfigurationService::migrateBlueprintExportToV14000).put((Object)14100L, BlueprintWithVersionsMigrationConfigurationService::migrateBlueprintExportToV14100).build();
    }

    private static JsonObject migrateBlueprintWithVersionsToV12200(JsonObject ancestor) {
        JsonArray blueprintVersionsWithOriginVersionId = MigrationJsonUtils.getArraySubpath((JsonElement)ancestor, "blueprintVersionsWithOriginVersionId").orElse(new JsonArray());
        for (JsonElement el : blueprintVersionsWithOriginVersionId) {
            BlueprintVersionMigrationConfigurationService.migrateBlueprintVersionWithOriginVersionIdAndSignoffConfigurationsToV12200(el.getAsJsonObject());
        }
        return ancestor;
    }

    private static JsonObject migrateBlueprintExportToV12400(JsonObject ancestor) {
        JsonArray blueprintVersionsWithOriginVersionId = MigrationJsonUtils.getArraySubpath((JsonElement)ancestor, "blueprintVersionsWithOriginVersionId").orElse(new JsonArray());
        for (JsonElement el : blueprintVersionsWithOriginVersionId) {
            BlueprintVersionMigrationConfigurationService.migrateBlueprintVersionExportToV12400(el.getAsJsonObject());
        }
        return ancestor;
    }

    private JsonObject migrateBlueprintExportToV13300(JsonObject ancestor) throws IOException {
        Map<String, MigrationV13300.BlueprintInfo> bpMapping = this.blueprintVersionImportConfigurationService.getBlueprintInfo();
        JsonArray blueprintVersionsWithOriginVersionId = MigrationJsonUtils.getArraySubpath((JsonElement)ancestor, "blueprintVersionsWithOriginVersionId").orElse(new JsonArray());
        for (JsonElement el : blueprintVersionsWithOriginVersionId) {
            BlueprintVersionMigrationConfigurationService.migrateBlueprintVersionExportToV13300(el.getAsJsonObject(), bpMapping);
        }
        return ancestor;
    }

    private static JsonObject migrateBlueprintExportToV13400(JsonObject ancestor) {
        JsonArray blueprintVersionsWithOriginVersionId = MigrationJsonUtils.getArraySubpath((JsonElement)ancestor, "blueprintVersionsWithOriginVersionId").orElse(new JsonArray());
        for (JsonElement el : blueprintVersionsWithOriginVersionId) {
            BlueprintVersionMigrationConfigurationService.migrateBlueprintVersionExportToV13400(el.getAsJsonObject());
        }
        return ancestor;
    }

    private static JsonObject migrateBlueprintExportToV14000(JsonObject ancestor) {
        JsonArray blueprintVersionsWithOriginVersionId = MigrationJsonUtils.getArraySubpath((JsonElement)ancestor, "blueprintVersionsWithOriginVersionId").orElse(new JsonArray());
        for (JsonElement el : blueprintVersionsWithOriginVersionId) {
            BlueprintVersionMigrationConfigurationService.migrateBlueprintVersionExportToV14000(el.getAsJsonObject());
        }
        return ancestor;
    }

    private static JsonObject migrateBlueprintExportToV14100(JsonObject ancestor) {
        JsonArray blueprintVersionsWithOriginVersionId = MigrationJsonUtils.getArraySubpath((JsonElement)ancestor, "blueprintVersionsWithOriginVersionId").orElse(new JsonArray());
        for (JsonElement el : blueprintVersionsWithOriginVersionId) {
            BlueprintVersionMigrationConfigurationService.migrateBlueprintVersionExportToV14100(el.getAsJsonObject());
        }
        return ancestor;
    }
}

