/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.relationships.collectors;

import com.dataiku.gh.core.models.relationships.ReferenceRelationship;
import com.dataiku.gh.core.models.relationships.Relationship;
import com.dataiku.gh.core.models.relationships.TimeSeriesRelationship;
import com.dataiku.gh.core.models.relationships.UploadedFileRelationship;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class CollectorResult {
    private final Map<Class<?>, List<? extends Relationship>> relationshipsMap = new HashMap();
    public final List<Pair<String, List<String>>> artifactIdsAllowedBlueprintIds = new ArrayList<Pair<String, List<String>>>();
    private final List<String> transientFieldIds = new ArrayList<String>();

    public List<ReferenceRelationship> getReferenceRelationships() {
        return this.getRelationships(ReferenceRelationship.class);
    }

    public List<UploadedFileRelationship> getUploadedFileRelationships() {
        return this.getRelationships(UploadedFileRelationship.class);
    }

    public List<TimeSeriesRelationship> getTimeSeriesRelationships() {
        return this.getRelationships(TimeSeriesRelationship.class);
    }

    public List<String> getTransientFieldIds() {
        return this.transientFieldIds;
    }

    public <T> List<T> getRelationships(Class<? extends Relationship> clazz) {
        return this.relationshipsMap.computeIfAbsent(clazz, key -> new ArrayList());
    }

    public static CollectorResultDiff computeDiff(CollectorResult existingRelationships, CollectorResult computedRelationships) {
        CollectorResult toCreate = new CollectorResult();
        for (Map.Entry<Class<?>, List<Relationship>> entry : computedRelationships.relationshipsMap.entrySet()) {
            List list = entry.getValue().stream().filter(relationship -> existingRelationships.relationshipsMap.values().stream().flatMap(Collection::stream).noneMatch(actualRel -> actualRel.equalsExceptEntityId(relationship))).collect(Collectors.toList());
            toCreate.relationshipsMap.put(entry.getKey(), list);
        }
        CollectorResult toSave = new CollectorResult();
        for (Map.Entry<Class<?>, List<Relationship>> entry : computedRelationships.relationshipsMap.entrySet()) {
            List filteredRelations = entry.getValue().stream().filter(relationship -> existingRelationships.relationshipsMap.values().stream().flatMap(Collection::stream).anyMatch(actualRel -> actualRel.equalsExceptEntityId(relationship) && !actualRel.equals(relationship))).collect(Collectors.toList());
            toSave.relationshipsMap.put(entry.getKey(), filteredRelations);
        }
        CollectorResult collectorResult = new CollectorResult();
        for (Map.Entry<Class<?>, List<Relationship>> currentEntry : existingRelationships.relationshipsMap.entrySet()) {
            List filteredRelations = currentEntry.getValue().stream().filter(relationship -> computedRelationships.relationshipsMap.values().stream().flatMap(Collection::stream).noneMatch(actualRel -> actualRel.equalsExceptEntityId(relationship))).collect(Collectors.toList());
            collectorResult.relationshipsMap.put(currentEntry.getKey(), filteredRelations);
        }
        return CollectorResultDiff.build(toCreate, toSave, collectorResult);
    }

    public static CollectorResult build(List<Relationship> relationships) {
        CollectorResult computedResult = new CollectorResult();
        relationships.forEach(relationship -> computedResult.getRelationships(relationship.getClass()).add(relationship));
        return computedResult;
    }

    public static class CollectorResultDiff {
        public CollectorResult toCreate;
        public CollectorResult toSave;
        public CollectorResult toDelete;

        public static CollectorResultDiff build(CollectorResult toCreate, CollectorResult toSave, CollectorResult toDelete) {
            CollectorResultDiff collectorResultDiff = new CollectorResultDiff();
            collectorResultDiff.toCreate = toCreate;
            collectorResultDiff.toSave = toSave;
            collectorResultDiff.toDelete = toDelete;
            return collectorResultDiff;
        }
    }
}

