/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions.helpers;

import com.dataiku.gh.core.models.blueprints.ui.View;
import com.dataiku.gh.core.models.enriched.EnrichedArtifactWithoutPermissions;
import com.dataiku.gh.core.models.roles.permissions.EffectivePermissionsItem;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.roles_and_permissions.helpers.ViewComponentFilter;
import com.dataiku.gh.core.visitors.IBlueprintVersionVisitor;
import javax.annotation.Nullable;

public class ViewFilter {
    public static View filterReadable(View view, String viewId, EffectivePermissionsItem effectivePermissionsItem) {
        ViewPermissionFilter viewPermissionFilter = new ViewPermissionFilter(effectivePermissionsItem);
        view.accept(viewPermissionFilter, viewId);
        return viewPermissionFilter.view;
    }

    public static View filterConditional(View view, String viewId, EnrichedArtifactWithoutPermissions enrichedArtifact, IArtifactsDataService artifactsDataService) {
        ViewConditionFilter viewConditionFilter = new ViewConditionFilter(enrichedArtifact, artifactsDataService);
        view.accept(viewConditionFilter, viewId);
        return viewConditionFilter.view;
    }

    public static View filterReadableAndConditional(View view, String viewId, EffectivePermissionsItem effectivePermissionsItem, @Nullable EnrichedArtifactWithoutPermissions enrichedArtifact, IArtifactsDataService artifactsDataService) {
        View readable = ViewFilter.filterReadable(view, viewId, effectivePermissionsItem);
        if (readable.viewComponent == null || enrichedArtifact == null) {
            return readable;
        }
        return ViewFilter.filterConditional(readable, viewId, enrichedArtifact, artifactsDataService);
    }

    private static class ViewPermissionFilter
    implements IBlueprintVersionVisitor {
        private final EffectivePermissionsItem effectivePermissionsItem;
        public View view;

        public ViewPermissionFilter(EffectivePermissionsItem effectivePermissionsItem) {
            this.effectivePermissionsItem = effectivePermissionsItem;
        }

        @Override
        public void visit(View view, String viewId) {
            View newView = new View();
            newView.label = view.label;
            newView.description = view.description;
            if (view.viewComponent != null) {
                newView.viewComponent = ViewComponentFilter.filterReadable(view.viewComponent, this.effectivePermissionsItem);
            }
            newView.analysisDefinition = view.analysisDefinition;
            this.view = newView;
        }
    }

    private static class ViewConditionFilter
    implements IBlueprintVersionVisitor {
        private final EnrichedArtifactWithoutPermissions enrichedArtifact;
        private final IArtifactsDataService artifactsDataService;
        public View view;

        public ViewConditionFilter(EnrichedArtifactWithoutPermissions enrichedArtifact, IArtifactsDataService artifactsDataService) {
            this.enrichedArtifact = enrichedArtifact;
            this.artifactsDataService = artifactsDataService;
        }

        @Override
        public void visit(View view, String viewId) {
            View newView = new View();
            newView.label = view.label;
            newView.description = view.description;
            if (view.viewComponent != null) {
                newView.viewComponent = ViewComponentFilter.filterCondition(view.viewComponent, this.enrichedArtifact, this.artifactsDataService);
            }
            newView.analysisDefinition = view.analysisDefinition;
            this.view = newView;
        }
    }
}

