/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.signoff;

import com.dataiku.gh.core.models.signoff.EnrichedSignoff;
import com.dataiku.gh.core.models.signoff.SignoffConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffUser;
import com.dataiku.gh.core.models.signoff.SignoffUsersGroup;
import com.dataiku.gh.core.services.signoff.ISignoffsDataService;
import com.dataiku.gh.core.services.signoff.ISignoffsEventService;
import com.dataiku.gh.core.services.signoff.SignoffUtils;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SignoffsEventService
implements ISignoffsEventService {
    @Autowired
    private ISignoffsDataService signoffsDataService;

    @Override
    @GHMandatoryTransaction
    public void onUserDelete(String login) throws IOException {
        this.removeSignoffUsersFromAllSignoffItems(SignoffUtils.userUsersContainerContainsUser(login), login);
    }

    @Override
    @GHMandatoryTransaction
    public void onRoleDelete(String roleId) throws IOException {
        this.removeSignoffUsersFromAllSignoffItems(SignoffUtils.roleUsersContainerContainsRoleId(roleId), roleId);
    }

    @Override
    @GHMandatoryTransaction
    public void onGroupDelete(String groupName) throws IOException {
        this.removeSignoffUsersFromAllSignoffItems(SignoffUtils.groupUsersContainerContainsGroupName(groupName), groupName);
    }

    @Override
    @GHMandatoryTransaction
    public void onGlobalAPIKeyDelete(String globalAPIKeyId) throws IOException {
        this.removeSignoffUsersFromAllSignoffItems(SignoffUtils.globalApikeyUsersContainerContainsApiKeyId(globalAPIKeyId), globalAPIKeyId);
    }

    private void removeSignoffUsersFromAllSignoffItems(Predicate<SignoffUser> shouldRemoveUser, String keywordArtifactFilter) throws IOException {
        List<SignoffConfiguration> modified;
        List<SignoffConfiguration> allSignoffConfigurations = this.signoffsDataService.listSignoffsConfigurations();
        if (CollectionUtils.isNotEmpty(allSignoffConfigurations) && CollectionUtils.isNotEmpty(modified = allSignoffConfigurations.stream().filter(configuration -> this.removePotentialSignoffUserFromSignoffConfiguration((SignoffConfiguration)configuration, shouldRemoveUser)).collect(Collectors.toList()))) {
            this.signoffsDataService.storeSignoffsConfigurations(modified, false);
        }
        List<EnrichedSignoff> signoffs = this.signoffsDataService.fastListSignoffsContaining(keywordArtifactFilter);
        for (EnrichedSignoff enrichedSignoff : signoffs) {
            boolean signoffModified = this.removePotentialSignoffUserFromSignoffConfiguration(enrichedSignoff.signoff.configuration, shouldRemoveUser);
            if (!signoffModified) continue;
            this.signoffsDataService.storeSignoff(enrichedSignoff.signoff);
        }
    }

    private boolean removePotentialSignoffUserFromSignoffConfiguration(SignoffConfiguration signoffConfiguration, Predicate<SignoffUser> shouldRemoveUser) {
        boolean modified = false;
        List filteredApprovers = signoffConfiguration.approvers.stream().filter(shouldRemoveUser.negate()).collect(Collectors.toList());
        modified |= filteredApprovers.size() != signoffConfiguration.approvers.size();
        signoffConfiguration.approvers = filteredApprovers;
        for (SignoffUsersGroup feedbackUser : signoffConfiguration.feedbackUsersGroups) {
            List filteredUsers = feedbackUser.users.stream().filter(shouldRemoveUser.negate()).collect(Collectors.toList());
            modified |= filteredUsers.size() != feedbackUser.users.size();
            feedbackUser.users = filteredUsers;
        }
        return modified;
    }
}

