/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.time_series;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.gh.core.models.time_series.TimeSeriesDatapoint;
import com.dataiku.gh.core.models.time_series.TimeSeriesHead;
import com.dataiku.gh.core.services.relationships.permissions.ITimeSeriesRelationshipPermissionService;
import com.dataiku.gh.core.services.time_series.ITimeSeriesDataService;
import com.dataiku.gh.core.services.time_series.ITimeSeriesService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimeSeriesService
implements ITimeSeriesService {
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private ITimeSeriesDataService timeSeriesDataService;
    @Autowired
    private ITimeSeriesRelationshipPermissionService timeSeriesRelationshipPermissionService;

    @Override
    @GHWriteTransaction
    public String create(AuthCtx authCtx, Set<TimeSeriesDatapoint> timeSeriesDatapoints) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
        return this.timeSeriesDataService.create(authCtx.getIdentifier(), timeSeriesDatapoints);
    }

    @Override
    @GHWriteTransaction
    public void push(AuthCtx authCtx, Set<TimeSeriesDatapoint> timeSeriesDatapoints, boolean upsert) throws IOException, DKUSecurityException {
        List uniqueTSIds = timeSeriesDatapoints.stream().map(tsd -> tsd.timeSeriesId).distinct().collect(Collectors.toList());
        for (String tsId : uniqueTSIds) {
            TimeSeriesHead tsHead = this.timeSeriesDataService.getHead(tsId);
            this.timeSeriesRelationshipPermissionService.checkRelationshipWritePermission(authCtx, tsHead);
        }
        this.timeSeriesDataService.push(timeSeriesDatapoints, upsert);
    }

    @Override
    @GHWriteTransaction
    public List<TimeSeriesDatapoint> get(AuthCtx authCtx, String timeSeriesId, @Nullable Long timestampMin, @Nullable Long timestampMax) throws IOException, DKUSecurityException {
        TimeSeriesHead tsHead = this.timeSeriesDataService.getHead(timeSeriesId);
        this.timeSeriesRelationshipPermissionService.checkRelationshipReadPermission(authCtx, tsHead);
        return this.timeSeriesDataService.get(timeSeriesId, timestampMin, timestampMax);
    }

    @Override
    @GHReadonlyTransaction
    public TimeSeriesHead getHead(AuthCtx authCtx, String timeSeriesId) throws IOException, DKUSecurityException {
        TimeSeriesHead tsHead = this.timeSeriesDataService.getHead(timeSeriesId);
        this.timeSeriesRelationshipPermissionService.checkRelationshipReadPermission(authCtx, tsHead);
        return tsHead;
    }

    @Override
    @GHWriteTransaction
    public void delete(AuthCtx authCtx, String timeSeriesId, @Nullable Long timestampMin, @Nullable Long timestampMax) throws IOException, DKUSecurityException {
        TimeSeriesHead tsHead = this.timeSeriesDataService.getHead(timeSeriesId);
        this.timeSeriesRelationshipPermissionService.checkRelationshipWritePermission(authCtx, tsHead);
        this.timeSeriesDataService.delete(timeSeriesId, timestampMin, timestampMax);
    }
}

