/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation;

import com.dataiku.gh.core.models.security.GlobalAPIKeyUsersContainer;
import com.dataiku.gh.core.models.security.GroupUsersContainer;
import com.dataiku.gh.core.models.security.RoleUsersContainer;
import com.dataiku.gh.core.models.security.UserUsersContainer;
import com.dataiku.gh.core.models.security.UsersContainersExtraction;
import com.dataiku.gh.core.models.security.UsersContainersValidationConfig;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.gh.core.models.signoff.SignoffConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffUser;
import com.dataiku.gh.core.models.signoff.SignoffUsersGroup;
import com.dataiku.gh.core.services.validation.ISignoffsValidationService;
import com.dataiku.gh.core.services.validation.IUsersContainerValidationService;
import com.dataiku.gh.core.services.validation.validators.SignoffConfigurationValidator;
import com.dataiku.gh.core.services.validation.validators.SignoffValidator;
import com.dataiku.gh.core.visitors.ISignoffConfigurationVisitor;
import com.dataiku.gh.core.visitors.IUsersContainerVisitor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SignoffsValidationService
implements ISignoffsValidationService {
    @Autowired
    private IUsersContainerValidationService usersContainerValidationService;

    @Override
    public void validateSignoff(Signoff signoff) throws IOException {
        SignoffValidator validator = new SignoffValidator();
        signoff.accept(validator);
        this.usersContainerValidationService.validate(validator.signoffConfigurationValidator.usersContainersExtraction);
    }

    @Override
    public void validateSignoffConfigurationAndFixUsersContainers(SignoffConfiguration signoffConfiguration, UsersContainersValidationConfig usersContainersValidationConfig) throws IOException {
        SignoffConfigurationValidator validator = new SignoffConfigurationValidator();
        signoffConfiguration.accept(validator);
        UsersContainersExtraction toDelete = this.usersContainerValidationService.validate(validator.usersContainersExtraction, usersContainersValidationConfig);
        this.fixUsersContainers(signoffConfiguration, toDelete);
    }

    private void fixUsersContainers(SignoffConfiguration signoffConfiguration, final UsersContainersExtraction toDelete) {
        signoffConfiguration.accept(new ISignoffConfigurationVisitor(){

            @Override
            public void visit(SignoffConfiguration signoffConfiguration) {
                signoffConfiguration.approvers = SignoffsValidationService.this.deleteMissingSignoffUsers(signoffConfiguration.approvers, toDelete);
            }

            @Override
            public void visit(SignoffUsersGroup signoffUsersGroup) {
                signoffUsersGroup.users = SignoffsValidationService.this.deleteMissingSignoffUsers(signoffUsersGroup.users, toDelete);
            }
        });
    }

    private List<SignoffUser> deleteMissingSignoffUsers(List<SignoffUser> signoffUserList, final UsersContainersExtraction toDelete) {
        if (CollectionUtils.isNotEmpty(signoffUserList)) {
            return signoffUserList.stream().filter(signoffUser -> {
                if (signoffUser == null || signoffUser.usersContainer == null) {
                    return false;
                }
                final AtomicBoolean keep = new AtomicBoolean(false);
                signoffUser.usersContainer.accept(new IUsersContainerVisitor(){

                    @Override
                    public void visit(UserUsersContainer userUsersContainer) {
                        keep.set(!toDelete.logins.contains(userUsersContainer.login));
                    }

                    @Override
                    public void visit(GroupUsersContainer groupUsersContainer) {
                        keep.set(!toDelete.groupNames.contains(groupUsersContainer.groupName));
                    }

                    @Override
                    public void visit(GlobalAPIKeyUsersContainer globalAPIKeyUsersContainer) {
                        keep.set(!toDelete.globalAPIKeyIds.contains(globalAPIKeyUsersContainer.globalAPIKeyId));
                    }

                    @Override
                    public void visit(RoleUsersContainer roleUsersContainer) {
                        keep.set(!toDelete.roleIds.contains(roleUsersContainer.roleId));
                    }
                });
                return keep.get();
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

