/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.artifacts;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.history.RevisionType;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactSearchSourceConfig;
import com.dataiku.gh.core.storage.artifacts.IArtifactDAO;
import com.dataiku.gh.core.storage.search.IArtifactSearchDAO;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.QueryDslJdbcTemplate;
import com.dataiku.gh.core.storage.sql.artifacts.PartialEnrichedArtifactRowMapper;
import com.dataiku.gh.core.storage.sql.model.QArtifacts;
import com.dataiku.gh.core.storage.sql.model.QArtifactsHistory;
import com.dataiku.gh.core.storage.sql.model.QBlueprintVersionTraces;
import com.dataiku.gh.core.storage.sql.model.QBlueprintVersions;
import com.dataiku.gh.core.storage.sql.model.QBlueprints;
import com.dataiku.gh.core.storage.sql.model.QPartialEnrichedArtifacts;
import com.dataiku.gh.core.storage.sql.search.PartialEnrichedArtifact;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.querydsl.core.QueryFlag;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberTemplate;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.StringTemplate;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLBindings;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ArtifactDAO
extends AbstractItemBasedDAO<String, Artifact, PartialEnrichedArtifact>
implements IArtifactDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.artifacts");
    @Autowired
    private PartialEnrichedArtifactRowMapper partialEnrichedArtifactRowMapper;
    @Autowired
    private IArtifactSearchDAO artifactSearchDAO;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public EntityType getEntityType() {
        return EntityType.ARTIFACT;
    }

    @Override
    protected RowMapper<PartialEnrichedArtifact> getRowMapper() {
        return this.partialEnrichedArtifactRowMapper;
    }

    @Override
    protected String getId(Artifact item) {
        return item.id;
    }

    @Override
    protected RelationalPathBase<?> getItemTablePath() {
        return QArtifacts.artifacts;
    }

    @Override
    protected SimplePath<Object> getItemTableJsonColumnPath() {
        return QArtifacts.artifacts.artifactJson;
    }

    @Override
    protected Predicate getIdCondition(String id) {
        return QArtifacts.artifacts.artifactId.eq((Object)id);
    }

    @Override
    protected RelationalPathBase<?> getHistoryTablePath() {
        return QArtifactsHistory.artifactsHistory;
    }

    @Override
    protected SimplePath<Object> getHistoryRevisionColumnPath() {
        return QArtifactsHistory.artifactsHistory._revisionJson;
    }

    @Override
    protected SimplePath<Object> getHistoryJsonColumnPath() {
        return QArtifactsHistory.artifactsHistory.artifactJson;
    }

    @Override
    protected void sqlLock(String id) {
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QArtifacts.artifacts)).innerJoin((EntityPath)QBlueprints.blueprints)).on((Predicate)QBlueprints.blueprints.blueprintId.eq((Expression)QArtifacts.artifacts.artifactBlueprintId))).innerJoin((EntityPath)QBlueprintVersions.blueprintVersions)).on((Predicate)QBlueprintVersions.blueprintVersions.blueprintVersionBlueprintId.eq((Expression)QArtifacts.artifacts.artifactBlueprintId).and((Predicate)QBlueprintVersions.blueprintVersions.blueprintVersionVersionId.eq((Expression)QArtifacts.artifacts.artifactVersionId)))).innerJoin((EntityPath)QBlueprintVersionTraces.blueprintVersionTraces)).on((Predicate)QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceBlueprintId.eq((Expression)QBlueprintVersions.blueprintVersions.blueprintVersionBlueprintId).and((Predicate)QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceVersionId.eq((Expression)QBlueprintVersions.blueprintVersions.blueprintVersionVersionId)))).where((Predicate)QArtifacts.artifacts.artifactId.eq((Object)id))).forUpdate();
        this.querydslJdbcTemplate.queryForList(query);
    }

    @Override
    protected PartialEnrichedArtifact sqlGet(String id) {
        SQLQuery query = (SQLQuery)((SQLQuery)ArtifactDAO.buildSelectFromEnrichedArtifactQuery(this.sqlQueryFactory).where((Predicate)QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactId.eq((Object)id))).limit(1L);
        return this.querydslJdbcTemplate.queryForObject(query, this.partialEnrichedArtifactRowMapper);
    }

    @Override
    protected Stream<PartialEnrichedArtifact> sqlListStream() {
        return this.querydslJdbcTemplate.queryForStream(ArtifactDAO.buildSelectFromEnrichedArtifactQuery(this.sqlQueryFactory), this.partialEnrichedArtifactRowMapper);
    }

    @Override
    public List<PartialEnrichedArtifact> getEnrichedArtifactAndAncestry(String artifactId) throws DataStoreIOException {
        PathBuilder recursiveAlias = new PathBuilder(Object.class, "RECURSIVE_ALIAS");
        PathBuilder parentArtifactAlias = new PathBuilder(String.class, "PARENT_ARTIFACT");
        PathBuilder pathAlias = new PathBuilder(Object.class, "PATH");
        StringTemplate parentArtifactTemplate = Expressions.stringTemplate((String)"{0}->'fields'->>({1})", (Object[])new Object[]{QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactJsonWithRelationships, Expressions.stringTemplate((String)"{0}->>'hierarchicalParentFieldId'", (Object[])new Object[]{QBlueprintVersions.blueprintVersions.blueprintVersionJson})});
        NumberTemplate lengthTemplate = Expressions.numberTemplate(Long.class, (String)"cardinality({0})", (Object[])new Object[]{recursiveAlias.get((Path)pathAlias)});
        SQLQuery baseQuery = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.query().from((Expression)QPartialEnrichedArtifacts.partialEnrichedArtifacts)).innerJoin((EntityPath)QBlueprintVersions.blueprintVersions)).on((Predicate)QBlueprintVersions.blueprintVersions.blueprintVersionBlueprintId.eq((Expression)QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactBlueprintId).and((Predicate)QBlueprintVersions.blueprintVersions.blueprintVersionVersionId.eq((Expression)QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactVersionId)));
        SQLQuery initQuery = (SQLQuery)((SQLQuery)((SQLQuery)baseQuery.clone()).select(new Expression[]{QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactId, QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactBlueprintId, QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactVersionId, QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactJsonWithRelationships, QPartialEnrichedArtifacts.partialEnrichedArtifacts.signoffs, QPartialEnrichedArtifacts.partialEnrichedArtifacts.userMappingUserLogin, QPartialEnrichedArtifacts.partialEnrichedArtifacts.groupMappingGroupName, QPartialEnrichedArtifacts.partialEnrichedArtifacts.globalApiKeyMappingApiKeyId, QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactRoleAssignmentsJson, QBlueprintVersions.blueprintVersions.blueprintVersionJson, parentArtifactTemplate.as((Path)parentArtifactAlias), Expressions.template(Object.class, (String)"ARRAY[{0}]", (Object[])new Object[]{QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactId}).as((Path)pathAlias)}).where((Predicate)QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactId.eq((Object)artifactId))).limit(1L);
        SQLQuery recursiveQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)baseQuery.clone()).select(new Expression[]{QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactId, QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactBlueprintId, QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactVersionId, QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactJsonWithRelationships, QPartialEnrichedArtifacts.partialEnrichedArtifacts.signoffs, QPartialEnrichedArtifacts.partialEnrichedArtifacts.userMappingUserLogin, QPartialEnrichedArtifacts.partialEnrichedArtifacts.groupMappingGroupName, QPartialEnrichedArtifacts.partialEnrichedArtifacts.globalApiKeyMappingApiKeyId, QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactRoleAssignmentsJson, QBlueprintVersions.blueprintVersions.blueprintVersionJson, parentArtifactTemplate.as((Path)parentArtifactAlias), Expressions.template(Object.class, (String)"{0} || {1}", (Object[])new Object[]{recursiveAlias.get((Path)pathAlias), QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactId}).as((Path)pathAlias)}).join((EntityPath)recursiveAlias)).on((Predicate)recursiveAlias.get((Path)parentArtifactAlias).eq((Expression)QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactId))).where((Predicate)QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactId.eq((Expression)Expressions.stringTemplate((String)"ANY({0})", (Object[])new Object[]{recursiveAlias.get((Path)pathAlias)})).not().and((Predicate)recursiveAlias.get((Path)parentArtifactAlias).isNotNull()))).limit(1L);
        SQLQuery fullQuery = ((SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.query().withRecursive((Path)recursiveAlias, new Path[]{QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactId, QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactBlueprintId, QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactVersionId, QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactJsonWithRelationships, QPartialEnrichedArtifacts.partialEnrichedArtifacts.signoffs, QPartialEnrichedArtifacts.partialEnrichedArtifacts.userMappingUserLogin, QPartialEnrichedArtifacts.partialEnrichedArtifacts.groupMappingGroupName, QPartialEnrichedArtifacts.partialEnrichedArtifacts.globalApiKeyMappingApiKeyId, QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactRoleAssignmentsJson, QBlueprintVersions.blueprintVersions.blueprintVersionJson, parentArtifactAlias, pathAlias}).as((Expression)SQLExpressions.unionAll((SubQueryExpression[])new SubQueryExpression[]{initQuery, recursiveQuery}))).from((Expression)recursiveAlias)).orderBy(lengthTemplate.asc())).select(new Expression[]{recursiveAlias.get(QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactJsonWithRelationships), recursiveAlias.get(QPartialEnrichedArtifacts.partialEnrichedArtifacts.signoffs), recursiveAlias.get(QPartialEnrichedArtifacts.partialEnrichedArtifacts.userMappingUserLogin), recursiveAlias.get(QPartialEnrichedArtifacts.partialEnrichedArtifacts.groupMappingGroupName), recursiveAlias.get(QPartialEnrichedArtifacts.partialEnrichedArtifacts.globalApiKeyMappingApiKeyId), recursiveAlias.get(QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactRoleAssignmentsJson)});
        try {
            return this.querydslJdbcTemplate.query(fullQuery, this.partialEnrichedArtifactRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public Map<String, String> getBlueprintsFromArtifactIds(Set<String> artifactIds) throws IOException {
        if (CollectionUtils.isEmpty(artifactIds)) {
            return new HashMap<String, String>();
        }
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(new Expression[]{QBlueprintVersions.blueprintVersions.blueprintVersionBlueprintId, QArtifacts.artifacts.artifactId}).from((Expression)QArtifacts.artifacts)).innerJoin((EntityPath)QBlueprintVersions.blueprintVersions)).on((Predicate)QBlueprintVersions.blueprintVersions.blueprintVersionVersionId.eq((Expression)QArtifacts.artifacts.artifactVersionId).and((Predicate)QBlueprintVersions.blueprintVersions.blueprintVersionBlueprintId.eq((Expression)QArtifacts.artifacts.artifactBlueprintId)))).where((Predicate)QArtifacts.artifacts.artifactId.in(artifactIds));
            return this.querydslJdbcTemplate.query(query, (rs, rowNum) -> new AbstractMap.SimpleEntry<String, String>(rs.getString(ColumnMetadata.getName((Path)QArtifacts.artifacts.artifactId)), rs.getString(ColumnMetadata.getName((Path)QBlueprintVersions.blueprintVersions.blueprintVersionBlueprintId)))).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<String> batchUpdateArtifactsField(List<ArtifactFilter> artifactFilters, String fieldId, Object value) throws IOException {
        try {
            String artifactsToUpdateCTEName = "artifacts_to_update";
            String updatedArtifactsCTEName = "updated_artifacts";
            String artifactIdSelector = "artifact_id";
            SQLBindings artifactsIdsToUpdateQuery = this.artifactSearchDAO.buildSqlQuery(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), artifactFilters, null, null).select((Expression)Expressions.stringTemplate((String)artifactIdSelector, (Object[])new Object[0])).getSQL();
            SQLBindings updateArtifactsQuery = (SQLBindings)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.sqlQueryFactory.update((RelationalPath)QArtifacts.artifacts).set(QArtifacts.artifacts.artifactJson, QueryBuilderUtils.jsonSetField(value, QArtifacts.artifacts.artifactJson, new String[]{"fields", fieldId}))).where((Predicate)QArtifacts.artifacts.artifactId.in(new Expression[]{Expressions.stringTemplate((String)String.format("(SELECT %s FROM %s)", artifactIdSelector, artifactsToUpdateCTEName), (Object[])new Object[0])}))).addFlag(QueryFlag.Position.END, " RETURNING *")).getSQL().get(0);
            SQLBindings revisionCreationQuery = (SQLBindings)((SQLInsertClause)this.batchCreateRevisions(updatedArtifactsCTEName, RevisionType.UPDATE).addFlag(QueryFlag.Position.END, String.format(" RETURNING %s", artifactIdSelector))).getSQL().get(0);
            String updateArtifactsAndStoreRevisions = String.format("WITH %s AS (%s),\n%s AS (%s)\n%s", artifactsToUpdateCTEName, artifactsIdsToUpdateQuery.getSQL(), updatedArtifactsCTEName, updateArtifactsQuery.getSQL(), revisionCreationQuery.getSQL());
            Object[] combinedBindingsInOrder = Stream.of(QueryDslJdbcTemplate.getBindingsObjArray(artifactsIdsToUpdateQuery), QueryDslJdbcTemplate.getBindingsObjArray(updateArtifactsQuery), QueryDslJdbcTemplate.getBindingsObjArray(revisionCreationQuery)).flatMap(Arrays::stream).toArray();
            return this.jdbcTemplate.queryForList(updateArtifactsAndStoreRevisions, String.class, combinedBindingsInOrder);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    private static SQLQuery<?> buildSelectFromEnrichedArtifactQuery(SQLQueryFactory sqlQueryFactory) {
        return (SQLQuery)sqlQueryFactory.select(PartialEnrichedArtifactRowMapper.COLUMNS).from((Expression)QPartialEnrichedArtifacts.partialEnrichedArtifacts);
    }

    @Override
    protected SQLInsertClause batchCreateRevisions(String CTEName, RevisionType revisionType) throws IOException {
        return super.batchCreateRevisions(CTEName, revisionType);
    }
}

