/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.AcceptAddressTransferRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class AcceptAddressTransferRequestMarshaller
implements Marshaller<Request<AcceptAddressTransferRequest>, AcceptAddressTransferRequest> {
    @Override
    public Request<AcceptAddressTransferRequest> marshall(AcceptAddressTransferRequest acceptAddressTransferRequest) {
        SdkInternalList acceptAddressTransferRequestTagSpecificationsList;
        if (acceptAddressTransferRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AcceptAddressTransferRequest> request = new DefaultRequest<AcceptAddressTransferRequest>(acceptAddressTransferRequest, "AmazonEC2");
        request.addParameter("Action", "AcceptAddressTransfer");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (acceptAddressTransferRequest.getAddress() != null) {
            request.addParameter("Address", StringUtils.fromString(acceptAddressTransferRequest.getAddress()));
        }
        if (!(acceptAddressTransferRequestTagSpecificationsList = (SdkInternalList)acceptAddressTransferRequest.getTagSpecifications()).isEmpty() || !acceptAddressTransferRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification acceptAddressTransferRequestTagSpecificationsListValue : acceptAddressTransferRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (acceptAddressTransferRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(acceptAddressTransferRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)acceptAddressTransferRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

