/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.BundleInstanceRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.S3Storage;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Storage;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class BundleInstanceRequestMarshaller
implements Marshaller<Request<BundleInstanceRequest>, BundleInstanceRequest> {
    @Override
    public Request<BundleInstanceRequest> marshall(BundleInstanceRequest bundleInstanceRequest) {
        S3Storage s3;
        Storage storage;
        if (bundleInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BundleInstanceRequest> request = new DefaultRequest<BundleInstanceRequest>(bundleInstanceRequest, "AmazonEC2");
        request.addParameter("Action", "BundleInstance");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (bundleInstanceRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(bundleInstanceRequest.getInstanceId()));
        }
        if ((storage = bundleInstanceRequest.getStorage()) != null && (s3 = storage.getS3()) != null) {
            if (s3.getAWSAccessKeyId() != null) {
                request.addParameter("Storage.S3.AWSAccessKeyId", StringUtils.fromString(s3.getAWSAccessKeyId()));
            }
            if (s3.getBucket() != null) {
                request.addParameter("Storage.S3.Bucket", StringUtils.fromString(s3.getBucket()));
            }
            if (s3.getPrefix() != null) {
                request.addParameter("Storage.S3.Prefix", StringUtils.fromString(s3.getPrefix()));
            }
            if (s3.getUploadPolicy() != null) {
                request.addParameter("Storage.S3.UploadPolicy", StringUtils.fromString(s3.getUploadPolicy()));
            }
            if (s3.getUploadPolicySignature() != null) {
                request.addParameter("Storage.S3.UploadPolicySignature", StringUtils.fromString(s3.getUploadPolicySignature()));
            }
        }
        return request;
    }
}

