/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ModifyVerifiedAccessGroupPolicyRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.VerifiedAccessSseSpecificationRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.IdempotentUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class ModifyVerifiedAccessGroupPolicyRequestMarshaller
implements Marshaller<Request<ModifyVerifiedAccessGroupPolicyRequest>, ModifyVerifiedAccessGroupPolicyRequest> {
    @Override
    public Request<ModifyVerifiedAccessGroupPolicyRequest> marshall(ModifyVerifiedAccessGroupPolicyRequest modifyVerifiedAccessGroupPolicyRequest) {
        if (modifyVerifiedAccessGroupPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyVerifiedAccessGroupPolicyRequest> request = new DefaultRequest<ModifyVerifiedAccessGroupPolicyRequest>(modifyVerifiedAccessGroupPolicyRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVerifiedAccessGroupPolicy");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVerifiedAccessGroupPolicyRequest.getVerifiedAccessGroupId() != null) {
            request.addParameter("VerifiedAccessGroupId", StringUtils.fromString(modifyVerifiedAccessGroupPolicyRequest.getVerifiedAccessGroupId()));
        }
        if (modifyVerifiedAccessGroupPolicyRequest.getPolicyEnabled() != null) {
            request.addParameter("PolicyEnabled", StringUtils.fromBoolean(modifyVerifiedAccessGroupPolicyRequest.getPolicyEnabled()));
        }
        if (modifyVerifiedAccessGroupPolicyRequest.getPolicyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString(modifyVerifiedAccessGroupPolicyRequest.getPolicyDocument()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(modifyVerifiedAccessGroupPolicyRequest.getClientToken()));
        VerifiedAccessSseSpecificationRequest sseSpecification = modifyVerifiedAccessGroupPolicyRequest.getSseSpecification();
        if (sseSpecification != null) {
            if (sseSpecification.getCustomerManagedKeyEnabled() != null) {
                request.addParameter("SseSpecification.CustomerManagedKeyEnabled", StringUtils.fromBoolean(sseSpecification.getCustomerManagedKeyEnabled()));
            }
            if (sseSpecification.getKmsKeyArn() != null) {
                request.addParameter("SseSpecification.KmsKeyArn", StringUtils.fromString(sseSpecification.getKmsKeyArn()));
            }
        }
        return request;
    }
}

